/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.fragments;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.AbstractRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.ParserRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.clones.DebugTimestamp;
import org.eclipse.ocl.examples.xtext.build.fragments.GenModelHelper;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsStandaloneSetup;
import org.eclipse.ocl.examples.xtext.serializer.AbstractSerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.DeclarativeFormatter;
import org.eclipse.ocl.examples.xtext.serializer.DeclarativeSerializer;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.EClassValue;
import org.eclipse.ocl.examples.xtext.serializer.EnumerationValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.ParserRuleValue;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMatchStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMatchTerm;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationSegment;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.serializer.SerializerFragment2;

public abstract class DeclarativeSerializerFragment
extends SerializerFragment2 {
    @Inject
    CodeConfig codeConfig;
    public static DebugTimestamp timestamp = new DebugTimestamp("DeclarativeSerializerFragment"){

        @Override
        protected void doLog(String message) {
        }
    };
    private static final Logger LOG = Logger.getLogger(DeclarativeSerializerFragment.class);
    private static final @NonNull List<@Nullable Integer> UNPAGED_PAGE_NUMBER_LIST = Collections.singletonList(null);
    public static int ECLASS_VALUES_PER_PAGE = 128;
    public static int ENUM_VALUES_PER_PAGE = 512;
    public static int GRAMMAR_RULE_VALUES_PER_PAGE = 256;
    public static int GRAMMAR_RULE_VECTORS_PER_PAGE = 512;
    public static int MATCH_STEPS_PER_PAGE = 512;
    public static int MATCH_TERMS_PER_PAGE = 512;
    public static int SERIALIZATION_RULES_PER_PAGE = 64;
    public static int SERIALIZATION_SEGMENTS_PER_PAGE = 512;
    public static int SERIALIZATION_STEPS_PER_PAGE = 512;
    @Inject
    private XtextGeneratorNaming xtextGeneratorNaming;
    @Inject
    private FileAccessFactory fileAccessFactory;
    @Inject
    private @NonNull Provider<ResourceSet> resourceSetProvider;
    private @Nullable GrammarAnalysis grammarAnalysis;
    private @NonNull Set<@NonNull String> referredClassNames = new HashSet<String>();
    private @Nullable GenModelHelper genModelHelper = null;
    private @Nullable Map<@NonNull EClass, @Nullable Integer> eClass2id = null;
    private @Nullable List<@NonNull EClass> eClassList = null;
    private @Nullable Map<@NonNull EnumerationValue, @Nullable Integer> enumerationValue2id = null;
    private @Nullable List<@NonNull EnumerationValue> enumerationValuesList = null;
    private @Nullable Map<@NonNull GrammarRuleValue, @Nullable Integer> grammarRuleValue2id = null;
    private @Nullable Map<@NonNull Integer, @NonNull String> grammarRuleValueIndex2ruleName = null;
    private @Nullable List<@NonNull GrammarRuleValue> grammarRuleValueList = null;
    private @Nullable Map<@NonNull GrammarRuleVector, @Nullable Integer> grammarRuleVector2id = null;
    private @Nullable List<@NonNull GrammarRuleVector> grammarRuleVectors = null;
    private @Nullable Map<@NonNull SerializationMatchStep, @Nullable Integer> matchStep2id = null;
    private @Nullable List<@NonNull SerializationMatchStep> matchStepList = null;
    private @Nullable Map<@NonNull SerializationMatchTerm, @Nullable Integer> matchTerm2id = null;
    private @Nullable List<@NonNull SerializationMatchTerm> matchTermList = null;
    private @Nullable List<@NonNull List<@NonNull SerializationSegment>> serializationSegmentsList = null;
    private @Nullable Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id = null;
    private @Nullable Map<@NonNull SerializationRule, @Nullable Integer> serializationRule2id = null;
    private @Nullable List<@NonNull SerializationRuleAnalysis> serializationRuleAnalysisList = null;
    private @Nullable Map<@NonNull SerializationStep, @Nullable Integer> serializationStep2id = null;
    private @Nullable List<@NonNull SerializationStep> serializationStepList = null;
    private int firstGlobalSerializationStepAssignmentIndex = -1;
    private int firstGlobalSerializationStepLiteralIndex = -1;
    protected int firstStepLiteralIndex;
    private int lastGlobalSerializationStepAssignmentIndex = -1;
    private int lastGlobalSerializationStepLiteralIndex = -1;

    protected abstract StringConcatenationClient doGetSerializationMetaDataContent(@NonNull GrammarAnalysis var1);

    protected void doGenerateAnalysisStubFile() {
        JavaFileAccess javaFile = this.doGetAnalysisStubFile();
        timestamp.log("generate analysis stub");
        if (javaFile != null) {
            javaFile.setMarkedAsGenerated(true);
            javaFile.writeTo((IFileSystemAccess2)this.getProjectConfig().getRuntime().getSrcGen());
        }
    }

    protected @Nullable JavaFileAccess doGetAnalysisStubFile() {
        if (!this.isGenerateStub()) {
            return null;
        }
        if (this.isGenerateXtendStub()) {
            String name = ((Object)((Object)this)).getClass().getName();
            LOG.error((Object)(String.valueOf(name) + " has been configured to generate an Xtend stub, but that's not yet supported."));
            return null;
        }
        IXtextGeneratorLanguage language = this.getLanguage();
        Grammar grammar = this.getGrammar();
        assert (grammar != null);
        TypeReference serializationMetaDataStub = this.getSerializationMetaDataClass(grammar);
        JavaFileAccess javaFile = this.fileAccessFactory.createJavaFile(serializationMetaDataStub);
        javaFile.setResourceSet(language.getResourceSet());
        GrammarAnalysis grammarAnalysis = this.getGrammarAnalysis();
        javaFile.setContent(this.doGetSerializationMetaDataContent(grammarAnalysis));
        return javaFile;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void doGetIdiomsStubFile() throws IOException {
        if (!this.isGenerateStub()) {
            return;
        }
        IXtextGeneratorLanguage language = this.getLanguage();
        Grammar grammar = this.getGrammar();
        assert (grammar != null);
        URI xtextURI = grammar.eResource().getURI();
        URI idiomsURI = xtextURI.trimFileExtension().appendFileExtension("idioms");
        ResourceSet resourceSet = language.getResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        boolean idiomsExists = uriConverter.exists(idiomsURI, null);
        if (idiomsExists) {
            return;
        }
        OutputStream outputStream = uriConverter.createOutputStream(idiomsURI);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        writer.append(this.codeConfig.getFileHeader());
        writer.append("\nmodel " + grammar.getName() + "\n");
        @NonNull Iterable usedGrammars = SerializationUtils.getUsedGrammars((Grammar)grammar);
        if (!Iterables.isEmpty((Iterable)usedGrammars)) {
            writer.append("\n/** Inherit idioms from inherited grammars. */\n");
            for (Grammar usedGrammar : usedGrammars) {
                writer.append("// with \"platform:/resource/... " + usedGrammar.eResource().getURI().toString() + "...idioms\"\n");
            }
        }
        writer.append("\n/** Import any Ecore metamodels used by EClass or assignment-location. */\n");
        writer.append("// import \"platform:/resource/...ecore#/\" as mymodel\n");
        writer.append("\n/** Mix-in idiom weaving standard Xtext comments everywhere visible. */\n");
        writer.append("mixin idiom COMMENTS at final do pre-comment value post-comment;\n");
        writer.append("\n/** Idiom indenting text between braces */\n");
        writer.append("idiom BRACES {\n");
        writer.append("\tat \"{\" do soft-space value push soft-new-line;\n");
        writer.append("\tat \"}\" do pop soft-space value soft-new-line;\n");
        writer.append("}\n");
        writer.append("\n/** Returned EClass-Localized idiom overiding a subsequent global idiom imposing spacing around colons */\n");
        writer.append("//idiom COLON for mymodel::MyClass at \":\" do soft-space value soft-space;\n");
        writer.append("\n/** Rule-Localized idiom overiding a subsequent global idiom imposing lines around colons */\n");
        writer.append("//idiom COLON in MyRule at \":\" do soft-new-line value soft-new-line;\n");
        writer.append("\n/** Idiom suppressing spaces before all colons */\n");
        writer.append("idiom COLON at \":\" do no-space value soft-space;\n");
        writer.append("\n/** Idiom separating repeated XXX assignments by a blank line */\n");
        writer.append("//idiom XXX_SPACING at each assignment mymodel::MyClass::XXX do half-new-line value half-new-line;\n");
        writer.append("\n/** Idiom surrounding repeated YYY assignments by a blank line */\n");
        writer.append("//idiom YYY_SPACING at all assignment mymodel::MyClass::YYY do new-line soft-new-line value soft-new-line;\n");
        writer.append("\n/** Default idiom imposing spacing for visible leaf terms must be last */\n");
        writer.append("idiom FINAL at final do soft-space value soft-space;\n");
        writer.close();
    }

    protected @NonNull String emitCalledRule(@NonNull CrossReference crossReference) {
        RuleCall ruleCall = (RuleCall)SerializationUtils.getTerminal((CrossReference)crossReference);
        AbstractRule abstractRule = SerializationUtils.getRule((RuleCall)ruleCall);
        AbstractRuleAnalysis ruleAnalysis = this.getGrammarAnalysis().getRuleAnalysis(abstractRule);
        return ruleAnalysis.getName();
    }

    protected @NonNull String emitLiteral(@NonNull EClassifier eClassifier) {
        return String.valueOf(this.newTypeReference(this.getGenModelHelper().getQualifiedPackageInterfaceName(SerializationUtils.getEPackage((EClassifier)eClassifier)))) + ".Literals." + this.getGenModelHelper().getLiteralName(eClassifier);
    }

    protected @NonNull String emitLiteral(@NonNull EStructuralFeature eStructuralFeature) {
        return String.valueOf(this.newTypeReference(this.getGenModelHelper().getQualifiedPackageInterfaceName(SerializationUtils.getEPackage((EClassifier)SerializationUtils.getEContainingClass((EStructuralFeature)eStructuralFeature))))) + ".Literals." + this.getGenModelHelper().getEcoreLiteralName(eStructuralFeature);
    }

    protected @NonNull String emitGrammarCardinality(@NonNull GrammarCardinality grammarCardinality) {
        if (grammarCardinality.equals((Object)GrammarCardinality.ONE)) {
            return String.valueOf(this.newTypeReference(GrammarCardinality.class)) + ".ONE";
        }
        if (grammarCardinality.equals((Object)GrammarCardinality.ZERO_OR_ONE)) {
            return String.valueOf(this.newTypeReference(GrammarCardinality.class)) + ".ZERO_OR_ONE";
        }
        if (grammarCardinality.equals((Object)GrammarCardinality.ZERO_OR_MORE)) {
            return String.valueOf(this.newTypeReference(GrammarCardinality.class)) + ".ZERO_OR_MORE";
        }
        if (grammarCardinality.equals((Object)GrammarCardinality.ONE_OR_MORE)) {
            return String.valueOf(this.newTypeReference(GrammarCardinality.class)) + ".ONE_OR_MORE";
        }
        return grammarCardinality.toString();
    }

    protected @NonNull String emitQualifiedLiteral(@NonNull EPackage ePackage) {
        return (String)SerializationUtils.nonNullState((Object)this.getGenModelHelper().getQualifiedPackageInterfaceName(ePackage));
    }

    private void gatherFormattingTexts(@NonNull AbstractElement grammarElement, @NonNull List<@NonNull String> formattingTexts) {
        StringBuilder s = new StringBuilder();
        if (grammarElement instanceof Assignment) {
            Assignment assignment = (Assignment)grammarElement;
            s.append(assignment.getFeature());
            s.append(assignment.getOperator());
            AbstractElement terminal = assignment.getTerminal();
            assert (terminal != null);
            this.gatherFormattingTexts(terminal, s);
        } else if (grammarElement instanceof Action) {
            s.append("{");
            s.append(((Action)grammarElement).getType().getClassifier().getName());
            s.append("}");
        } else if (grammarElement instanceof Group) {
            s.append("Group");
        } else if (grammarElement instanceof Alternatives) {
            s.append("Alternatives");
        } else {
            this.gatherFormattingTexts(grammarElement, s);
        }
        String cardinality = grammarElement.getCardinality();
        if (cardinality != null) {
            s.append(cardinality);
        }
        String string = s.toString();
        assert (string != null);
        formattingTexts.add(string);
        if (grammarElement instanceof CompoundElement) {
            for (AbstractElement nestedElement : ((CompoundElement)grammarElement).getElements()) {
                assert (nestedElement != null);
                this.gatherFormattingTexts(nestedElement, formattingTexts);
            }
        }
    }

    private void gatherFormattingTexts(@NonNull AbstractElement grammarElement, @NonNull StringBuilder s) {
        if (grammarElement instanceof Keyword) {
            s.append("\"");
            s.append(Strings.convertToJavaString((String)((Keyword)grammarElement).getValue()));
            s.append("\"");
        } else if (grammarElement instanceof CrossReference) {
            CrossReference crossReference = (CrossReference)grammarElement;
            AbstractElement terminal = crossReference.getTerminal();
            assert (terminal != null);
            this.gatherFormattingTexts(terminal, s);
            String cardinality = terminal.getCardinality();
            if (cardinality != null) {
                s.append(cardinality);
            }
        } else if (grammarElement instanceof RuleCall) {
            RuleCall ruleCall = (RuleCall)grammarElement;
            s.append(ruleCall.getRule().getName());
        } else if (grammarElement instanceof Alternatives) {
            s.append("(");
            boolean isFirst = true;
            for (AbstractElement nestedElement : ((Alternatives)grammarElement).getElements()) {
                assert (nestedElement != null);
                if (!isFirst) {
                    s.append("|");
                }
                this.gatherFormattingTexts(nestedElement, s);
                String cardinality = grammarElement.getCardinality();
                if (cardinality != null) {
                    s.append(cardinality);
                }
                isFirst = false;
            }
            s.append(")");
        }
    }

    public void generate() {
        try {
            timestamp.log("generate start");
            IdiomsStandaloneSetup.doSetup();
            Grammar grammar = this.getGrammar();
            timestamp.log("generate gotGrammar");
            GuiceModuleAccess.BindingFactory bindingFactory = new GuiceModuleAccess.BindingFactory();
            GuiceModuleAccess runtimeGenModule = this.getLanguage().getRuntimeGenModule();
            bindingFactory.addTypeToType(TypeReference.typeRef(INodeModelFormatter.class, (TypeReference[])new TypeReference[0]), TypeReference.typeRef(DeclarativeFormatter.class, (TypeReference[])new TypeReference[0])).contributeTo(runtimeGenModule);
            bindingFactory.addTypeToType(TypeReference.typeRef(ISerializer.class, (TypeReference[])new TypeReference[0]), TypeReference.typeRef(DeclarativeSerializer.class, (TypeReference[])new TypeReference[0])).contributeTo(runtimeGenModule);
            bindingFactory.addTypeToType(TypeReference.typeRef(SerializationMetaData.Provider.class, (TypeReference[])new TypeReference[0]), this.getSerializationMetaDataProviderClass(grammar)).contributeTo(runtimeGenModule);
            timestamp.log("generate idioms stub");
            this.doGetIdiomsStubFile();
            timestamp.log("generate analysis stub");
            this.doGenerateAnalysisStubFile();
            timestamp.log("generate end");
        }
        catch (AssertionError e) {
            LOG.error((Object)"Assertion failed", (Throwable)((Object)e));
        }
        catch (IOException e) {
            LOG.error((Object)"File access failed", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Failure", (Throwable)e);
            throw e;
        }
    }

    protected void generateAbstractSemanticSequencer() {
        throw new UnsupportedOperationException();
    }

    protected void generateAbstractSyntacticSequencer() {
        throw new UnsupportedOperationException();
    }

    protected void generateGrammarConstraints() {
        throw new UnsupportedOperationException();
    }

    protected void generateSemanticSequencer() {
        throw new UnsupportedOperationException();
    }

    protected void generateSyntacticSequencer() {
        throw new UnsupportedOperationException();
    }

    protected TypeReference getAbstractSemanticSequencerClass(Grammar grammar) {
        throw new UnsupportedOperationException();
    }

    protected TypeReference getAbstractSyntacticSequencerClass(Grammar grammar) {
        throw new UnsupportedOperationException();
    }

    protected int getEClassCount() {
        assert (this.eClass2id != null);
        return this.eClass2id.size();
    }

    protected int getEClassIndex(@NonNull EClass eClass) {
        assert (this.eClass2id != null);
        Integer id = this.eClass2id.get(eClass);
        assert (id != null);
        return id;
    }

    protected @NonNull List<@NonNull EClass> getEClassList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull EClass> eClassList2 = this.eClassList;
        if (eClassList2 == null) {
            timestamp.log("getEClassList start");
            Map<@NonNull EClass, @Nullable Integer> eClass2id2 = this.eClass2id;
            if (eClass2id2 == null) {
                this.eClass2id = eClass2id2 = new HashMap<EClass, Integer>();
            }
            for (EClassValue eClassValue : grammarAnalysis.getSortedProducedEClassValues()) {
                eClass2id2.put(eClassValue.getEClass(), null);
            }
            eClassList2 = this.eClassList = new ArrayList<EClass>(eClass2id2.keySet());
            Collections.sort(eClassList2, SerializationUtils.ENAMED_ELEMENT_COMPARATOR);
            int i = 0;
            for (EClass eClass : eClassList2) {
                eClass2id2.put(eClass, i++);
            }
        }
        return eClassList2;
    }

    protected int getEnumerationValueCount() {
        assert (this.enumerationValue2id != null);
        return this.enumerationValue2id.size();
    }

    protected int getEnumerationValueIndex(@NonNull EnumerationValue enumerationValue) {
        if (enumerationValue.isNull()) {
            return -1;
        }
        assert (this.enumerationValue2id != null);
        Integer id = this.enumerationValue2id.get(enumerationValue);
        assert (id != null);
        return id;
    }

    protected @NonNull List<@NonNull EnumerationValue> getEnumerationValueList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull EnumerationValue> enumerationValuesList2 = this.enumerationValuesList;
        if (enumerationValuesList2 == null) {
            timestamp.log("getEnumerationValueList start");
            Map<@NonNull EnumerationValue, @Nullable Integer> enumerationValue2id2 = this.enumerationValue2id;
            if (enumerationValue2id2 == null) {
                this.enumerationValue2id = enumerationValue2id2 = new HashMap<EnumerationValue, Integer>();
            }
            for (EnumerationValue enumerationValue : grammarAnalysis.getEnumerationValues()) {
                enumerationValue2id2.put(enumerationValue, null);
            }
            for (EClassValue eClassValue : grammarAnalysis.getSortedProducedEClassValues()) {
                SerializationRule[] serializationRuleArray = eClassValue.getSerializationRules();
                int n = serializationRuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SerializationRule serializationRule = serializationRuleArray[n2];
                    SerializationRuleAnalysis serializationRuleAnalysis = grammarAnalysis.getSerializationRuleAnalysis(serializationRule);
                    for (SerializationMatchStep solutionStep : serializationRuleAnalysis.getSerializationMatchSteps()) {
                        for (SerializationMatchTerm solution : solutionStep.getMatchTermClosure()) {
                            if (!(solution instanceof SerializationMatchTerm.SerializationMatchTermEAttributeSize)) continue;
                            enumerationValue2id2.put(((SerializationMatchTerm.SerializationMatchTermEAttributeSize)solution).getEnumerationValue(), null);
                        }
                    }
                    SerializationStep[] serializationStepArray = serializationRule.getSerializationSteps();
                    int n3 = serializationStepArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object serializationStep = serializationStepArray[n4];
                        if (serializationStep instanceof SerializationStep.SerializationStepAssignKeyword) {
                            enumerationValue2id2.put(((SerializationStep.SerializationStepAssignKeyword)serializationStep).getEnumerationValue(), null);
                        }
                        ++n4;
                    }
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull SerializationRule.SerializationAttribute[] serializationAttributes = serializationRuleAnalysis.basicGetSerializationAttributes();
                    if (serializationAttributes != null) {
                        SerializationRule.SerializationAttribute[] serializationAttributeArray = serializationAttributes;
                        int n5 = serializationAttributes.length;
                        n3 = 0;
                        while (n3 < n5) {
                            SerializationRule.SerializationAttribute serializationAttribute = serializationAttributeArray[n3];
                            EnumerationValue[] enumerationValueArray = serializationAttribute.getEnumerationValues();
                            int n6 = enumerationValueArray.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                EnumerationValue enumerationValue = enumerationValueArray[n7];
                                enumerationValue2id2.put(enumerationValue, null);
                                ++n7;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
            }
            enumerationValuesList2 = this.enumerationValuesList = new ArrayList<EnumerationValue>(enumerationValue2id2.keySet());
            Collections.sort(enumerationValuesList2, SerializationUtils.NAMEABLE_COMPARATOR);
            int i = 0;
            for (EnumerationValue enumerationValue : enumerationValuesList2) {
                enumerationValue2id2.put(enumerationValue, i++);
            }
        }
        return enumerationValuesList2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EClassValue.EReference_TargetGrammarRuleVector> getEReferenceRuleIndexesIterable(@NonNull GrammarAnalysis grammarAnalysis, @NonNull EClass eClass) {
        @NonNull ArrayList eReferenceRuleIndexes = Lists.newArrayList((Object[])grammarAnalysis.getEReferenceRuleIndexes(eClass));
        assert (eReferenceRuleIndexes != null);
        Collections.sort(eReferenceRuleIndexes, SerializationUtils.NAMEABLE_COMPARATOR);
        return eReferenceRuleIndexes;
    }

    protected int getFirstGlobalSerializationStepAssignmentIndex() {
        assert (this.serializationStep2id != null);
        return this.firstGlobalSerializationStepAssignmentIndex;
    }

    protected int getFirstGlobalSerializationStepLiteralIndex() {
        assert (this.serializationStep2id != null);
        return this.firstGlobalSerializationStepLiteralIndex;
    }

    protected @NonNull List<@NonNull List<@NonNull SerializationSegment>> getFormattingSegmentsInnerList(@NonNull GrammarAnalysis grammarAnalysis, @NonNull ParserRuleValue parserRuleValue) {
        @NonNull SerializationSegment @NonNull [] @NonNull [] innerFormattingSegmentsArray = grammarAnalysis.getInnerFormattingSegments(parserRuleValue);
        ArrayList<@NonNull List<@NonNull SerializationSegment>> serializationSegmentsList = new ArrayList<List<SerializationSegment>>(innerFormattingSegmentsArray.length);
        SerializationSegment[][] serializationSegmentArray = innerFormattingSegmentsArray;
        int n = innerFormattingSegmentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] innerFormattingSegments = serializationSegmentArray[n2];
            serializationSegmentsList.add((List)SerializationUtils.nonNullState((Object)Lists.newArrayList((Object[])innerFormattingSegments)));
            ++n2;
        }
        return serializationSegmentsList;
    }

    protected @NonNull List<@NonNull List<@NonNull SerializationSegment>> getFormattingSegmentsOuterList(@NonNull GrammarAnalysis grammarAnalysis, @NonNull ParserRuleValue parserRuleValue) {
        @NonNull SerializationSegment @NonNull [] @NonNull [] outerFormattingSegmentsArray = grammarAnalysis.getOuterFormattingSegments(parserRuleValue);
        ArrayList<@NonNull List<@NonNull SerializationSegment>> serializationSegmentsList = new ArrayList<List<SerializationSegment>>(outerFormattingSegmentsArray.length);
        SerializationSegment[][] serializationSegmentArray = outerFormattingSegmentsArray;
        int n = outerFormattingSegmentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] outerFormattingSegments = serializationSegmentArray[n2];
            serializationSegmentsList.add((List)SerializationUtils.nonNullState((Object)Lists.newArrayList((Object[])outerFormattingSegments)));
            ++n2;
        }
        return serializationSegmentsList;
    }

    protected @NonNull List<@NonNull String> getFormattingTexts(@NonNull GrammarAnalysis grammarAnalysis, @NonNull ParserRuleValue parserRuleValue) {
        @NonNull ArrayList<@NonNull String> formattingTexts = new ArrayList<String>();
        AbstractElement alternatives = grammarAnalysis.getRuleAnalysis(parserRuleValue.getIndex()).getRule().getAlternatives();
        assert (alternatives != null);
        this.gatherFormattingTexts(alternatives, formattingTexts);
        return formattingTexts;
    }

    private @NonNull GenModelHelper getGenModelHelper() {
        GenModelHelper genModelHelper2 = this.genModelHelper;
        if (genModelHelper2 == null) {
            ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
            assert (resourceSet != null);
            this.genModelHelper = genModelHelper2 = new GenModelHelper(resourceSet);
        }
        return genModelHelper2;
    }

    protected @NonNull GrammarAnalysis getGrammarAnalysis() {
        GrammarAnalysis grammarAnalysis2 = this.grammarAnalysis;
        if (grammarAnalysis2 == null) {
            Grammar grammar = this.getGrammar();
            assert (grammar != null);
            this.grammarAnalysis = grammarAnalysis2 = new GrammarAnalysis(grammar);
            timestamp.log("grammarAnalysis.analyze() start");
            grammarAnalysis2.analyze();
            timestamp.log("grammarAnalysis.analyze() end");
        }
        return grammarAnalysis2;
    }

    protected String getGrammarConstraintsPath(Grammar grammar) {
        throw new UnsupportedOperationException();
    }

    protected @NonNull String getGrammarRuleName(@NonNull Integer grammarRuleValueIndex) {
        assert (this.grammarRuleValueIndex2ruleName != null);
        String id = (String)SerializationUtils.maybeNull((Object)this.grammarRuleValueIndex2ruleName.get(grammarRuleValueIndex));
        assert (id != null);
        return id;
    }

    protected int getGrammarRuleValueCount() {
        assert (this.grammarRuleValue2id != null);
        return this.grammarRuleValue2id.size();
    }

    protected int getGrammarRuleValueIndex(@NonNull GrammarRuleValue grammarRuleValue) {
        assert (this.grammarRuleValue2id != null);
        Integer id = this.grammarRuleValue2id.get(grammarRuleValue);
        assert (id != null);
        return id;
    }

    protected @NonNull List<@NonNull GrammarRuleValue> getGrammarRuleValueList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull GrammarRuleValue> grammarRuleValueList2 = this.grammarRuleValueList;
        if (grammarRuleValueList2 == null) {
            timestamp.log("getGrammarRuleValueList start");
            Map<@NonNull GrammarRuleValue, @Nullable Integer> grammarRuleValue2id2 = this.grammarRuleValue2id;
            Map<@NonNull Integer, @NonNull String> grammarRuleValueIndex2ruleName2 = this.grammarRuleValueIndex2ruleName;
            if (grammarRuleValue2id2 == null) {
                this.grammarRuleValue2id = grammarRuleValue2id2 = new HashMap<GrammarRuleValue, Integer>();
            }
            if (grammarRuleValueIndex2ruleName2 == null) {
                this.grammarRuleValueIndex2ruleName = grammarRuleValueIndex2ruleName2 = new HashMap<Integer, String>();
            }
            for (AbstractRuleAnalysis grammarRuleAnalysis : grammarAnalysis.getRuleAnalyses()) {
                grammarRuleValue2id2.put(grammarRuleAnalysis.getRuleValue(), null);
                grammarRuleValueIndex2ruleName2.put(grammarRuleAnalysis.getRuleValue().getIndex(), grammarRuleAnalysis.getName());
            }
            grammarRuleValueList2 = this.grammarRuleValueList = new ArrayList<GrammarRuleValue>(grammarRuleValue2id2.keySet());
            Collections.sort(grammarRuleValueList2, SerializationUtils.NAMEABLE_COMPARATOR);
            int i = 0;
            for (GrammarRuleValue grammarRuleValue : grammarRuleValueList2) {
                grammarRuleValue2id2.put(grammarRuleValue, i++);
            }
        }
        return grammarRuleValueList2;
    }

    protected int getGrammarRuleVectorCount() {
        assert (this.grammarRuleVector2id != null);
        return this.grammarRuleVector2id.size();
    }

    protected int getGrammarRuleVectorIndex(@NonNull GrammarRuleVector grammarRuleVector) {
        assert (this.grammarRuleVector2id != null);
        Integer id = this.grammarRuleVector2id.get(grammarRuleVector);
        assert (id != null);
        return id;
    }

    protected @NonNull List<@NonNull GrammarRuleVector> getGrammarRuleVectorList(@NonNull GrammarAnalysis grammarAnalysis) {
        Map<@NonNull GrammarRuleVector, @Nullable Integer> grammarRuleVector2id2 = this.grammarRuleVector2id;
        List<@NonNull GrammarRuleVector> grammarRuleVectors2 = this.grammarRuleVectors;
        if (grammarRuleVector2id2 == null || grammarRuleVectors2 == null) {
            int n;
            timestamp.log("getGrammarRuleVectorList start");
            this.grammarRuleVector2id = grammarRuleVector2id2 = new HashMap<GrammarRuleVector, Integer>();
            for (EClass eClass : this.getEClassList(grammarAnalysis)) {
                // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull EClassValue.EReference_TargetGrammarRuleVector[] eReferenceRuleIndexes = grammarAnalysis.basicGetEReferenceRuleIndexes(eClass);
                if (eReferenceRuleIndexes == null) continue;
                EClassValue.EReference_TargetGrammarRuleVector[] eReference_TargetGrammarRuleVectorArray = eReferenceRuleIndexes;
                int n2 = eReferenceRuleIndexes.length;
                n = 0;
                while (n < n2) {
                    EClassValue.EReference_TargetGrammarRuleVector eReferenceRuleIndex = eReference_TargetGrammarRuleVectorArray[n];
                    GrammarRuleVector assignedTargetRuleValues = eReferenceRuleIndex.getTargetGrammarRuleVector();
                    grammarRuleVector2id2.put(assignedTargetRuleValues, null);
                    ++n;
                }
            }
            for (GrammarRuleValue grammarRuleValue : this.getGrammarRuleValueList(grammarAnalysis)) {
                GrammarRuleVector subParserRuleValueIndexes;
                if (!(grammarRuleValue instanceof ParserRuleValue) || (subParserRuleValueIndexes = ((ParserRuleValue)grammarRuleValue).getSubParserRuleValueIndexes()) == null) continue;
                grammarRuleVector2id2.put(subParserRuleValueIndexes, null);
            }
            for (SerializationMatchStep matchStep : this.getMatchStepList(grammarAnalysis)) {
                if (!(matchStep instanceof SerializationMatchStep.MatchStep_RuleCheck)) continue;
                grammarRuleVector2id2.put(((SerializationMatchStep.MatchStep_RuleCheck)matchStep).getRuleValueIndexes(), null);
            }
            for (EClassValue eClassValue : grammarAnalysis.getSortedProducedEClassValues()) {
                SerializationRule[] serializationRuleArray = eClassValue.getSerializationRules();
                n = serializationRuleArray.length;
                int eReferenceRuleIndex = 0;
                while (eReferenceRuleIndex < n) {
                    SerializationRule serializationRule = serializationRuleArray[eReferenceRuleIndex];
                    SerializationRuleAnalysis serializationRuleAnalysis = grammarAnalysis.getSerializationRuleAnalysis(serializationRule);
                    for (SerializationMatchStep solutionStep : serializationRuleAnalysis.getSerializationMatchSteps()) {
                        for (SerializationMatchTerm solution : solutionStep.getMatchTermClosure()) {
                            if (!(solution instanceof SerializationMatchTerm.SerializationMatchTermEReferenceSize)) continue;
                            grammarRuleVector2id2.put(((SerializationMatchTerm.SerializationMatchTermEReferenceSize)solution).getGrammarRuleVector(), null);
                        }
                    }
                    SerializationStep[] serializationStepArray = serializationRule.getSerializationSteps();
                    int n3 = serializationStepArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object serializationStep = serializationStepArray[n4];
                        if (serializationStep instanceof SerializationStep.SerializationStepAssigns) {
                            int[] calledRuleIndexes = ((SerializationStep.SerializationStepAssigns)serializationStep).getCalledRuleIndexes();
                            grammarRuleVector2id2.put(new GrammarRuleVector(calledRuleIndexes), null);
                        }
                        ++n4;
                    }
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull SerializationRule.SerializationFeature[] serializationFeatures = serializationRule.basicGetSerializationFeatures();
                    if (serializationFeatures != null) {
                        SerializationRule.SerializationFeature[] serializationFeatureArray = serializationFeatures;
                        int n5 = serializationFeatures.length;
                        n3 = 0;
                        while (n3 < n5) {
                            GrammarRuleVector grammarRuleVector;
                            SerializationRule.SerializationFeature serializationFeature = serializationFeatureArray[n3];
                            if (serializationFeature instanceof SerializationRule.SerializationReference && (grammarRuleVector = ((SerializationRule.SerializationReference)serializationFeature).getTargetGrammarRuleVector()) != null) {
                                grammarRuleVector2id2.put(grammarRuleVector, null);
                            }
                            ++n3;
                        }
                    }
                    ++eReferenceRuleIndex;
                }
            }
            this.grammarRuleVectors = grammarRuleVectors2 = new ArrayList<GrammarRuleVector>(grammarRuleVector2id2.keySet());
            Collections.sort(grammarRuleVectors2);
            int i = 0;
            for (GrammarRuleVector grammarRuleVector : grammarRuleVectors2) {
                GrammarRuleVector prevGrammarRuleVector;
                if (i > 0 && grammarRuleVector.compareTo(prevGrammarRuleVector = (GrammarRuleVector)SerializationUtils.nonNullState((Object)grammarRuleVectors2.get(i - 1))) <= 0) assert (grammarRuleVector.compareTo(prevGrammarRuleVector) > 0);
                grammarRuleVector2id2.put(grammarRuleVector, i++);
            }
        }
        return grammarRuleVectors2;
    }

    protected @NonNull Iterable<@NonNull String> getImportedClassNameIterable() {
        ArrayList<@NonNull String> referredClassesList = new ArrayList<String>(this.referredClassNames);
        Collections.sort(referredClassesList);
        return referredClassesList;
    }

    protected int getLastGlobalSerializationStepAssignmentIndex() {
        assert (this.serializationStep2id != null);
        return this.lastGlobalSerializationStepAssignmentIndex;
    }

    protected int getLastGlobalSerializationStepLiteralIndex() {
        assert (this.serializationStep2id != null);
        return this.lastGlobalSerializationStepLiteralIndex;
    }

    protected int getMatchStepCount() {
        assert (this.matchStepList != null);
        return this.matchStepList.size();
    }

    protected int getMatchStepIndex(@NonNull SerializationMatchStep matchStep) {
        assert (this.matchStep2id != null);
        Integer id = this.matchStep2id.get(matchStep);
        assert (id != null);
        return id;
    }

    protected @NonNull List<@NonNull SerializationMatchStep> getMatchStepList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull SerializationMatchStep> matchStepList2 = this.matchStepList;
        if (matchStepList2 == null) {
            timestamp.log("getMatchStepList start");
            Map<@NonNull SerializationMatchStep, @Nullable Integer> matchStep2id2 = this.matchStep2id;
            if (matchStep2id2 == null) {
                this.matchStep2id = matchStep2id2 = new HashMap<SerializationMatchStep, Integer>();
                for (EClassValue eClassValue : grammarAnalysis.getSortedProducedEClassValues()) {
                    SerializationRule[] serializationRuleArray = eClassValue.getSerializationRules();
                    int n = serializationRuleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SerializationRule serializationRule = serializationRuleArray[n2];
                        SerializationRuleAnalysis serializationRuleAnalysis = grammarAnalysis.getSerializationRuleAnalysis(serializationRule);
                        for (SerializationMatchStep matchStep : serializationRuleAnalysis.getSerializationMatchSteps()) {
                            matchStep2id2.put(matchStep, null);
                        }
                        ++n2;
                    }
                }
            }
            this.matchStepList = matchStepList2 = new ArrayList<SerializationMatchStep>(matchStep2id2.keySet());
            Collections.sort(matchStepList2, new SerializationUtils.ToStringComparator());
            int i = 0;
            for (SerializationMatchStep matchStep : matchStepList2) {
                matchStep2id2.put(matchStep, i++);
            }
        }
        return matchStepList2;
    }

    protected int getMatchTermCount() {
        assert (this.matchTermList != null);
        return this.matchTermList.size();
    }

    protected int getMatchTermIndex(@NonNull SerializationMatchTerm matchTerm) {
        assert (this.matchTerm2id != null);
        Integer id = this.matchTerm2id.get(matchTerm);
        assert (id != null);
        return id;
    }

    protected @NonNull List<@NonNull SerializationMatchTerm> getMatchTermList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull SerializationMatchTerm> matchTermList2 = this.matchTermList;
        if (matchTermList2 == null) {
            timestamp.log("getMatchTermList start");
            Map<@NonNull SerializationMatchTerm, @Nullable Integer> matchTerm2id2 = this.matchTerm2id;
            if (matchTerm2id2 == null) {
                assert (this.matchTermList == null);
                this.matchTerm2id = matchTerm2id2 = new HashMap<SerializationMatchTerm, Integer>();
                for (EClassValue eClassValue : grammarAnalysis.getSortedProducedEClassValues()) {
                    SerializationRule[] serializationRuleArray = eClassValue.getSerializationRules();
                    int n = serializationRuleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SerializationRule serializationRule = serializationRuleArray[n2];
                        SerializationRuleAnalysis serializationRuleAnalysis = grammarAnalysis.getSerializationRuleAnalysis(serializationRule);
                        for (SerializationMatchStep solutionStep : serializationRuleAnalysis.getSerializationMatchSteps()) {
                            for (SerializationMatchTerm matchTerm : solutionStep.getMatchTermClosure()) {
                                matchTerm2id2.put(matchTerm, null);
                            }
                        }
                        ++n2;
                    }
                }
            }
            this.matchTermList = matchTermList2 = new ArrayList<SerializationMatchTerm>(matchTerm2id2.keySet());
            Collections.sort(matchTermList2, new Comparator<SerializationMatchTerm>(){
                private final @NonNull Map<@NonNull Object, String> object2string = new HashMap<Object, String>();

                @Override
                public int compare(@NonNull SerializationMatchTerm o1, @NonNull SerializationMatchTerm o2) {
                    int i2;
                    int i1 = o1.getChildClosure().size();
                    if (i1 != (i2 = o2.getChildClosure().size())) {
                        return i1 - i2;
                    }
                    String s1 = this.getString(o1);
                    String s2 = this.getString(o2);
                    return SerializationUtils.safeCompareTo((Comparable)((Object)s1), (Comparable)((Object)s2));
                }

                private String getString(@NonNull Object o) {
                    String string = this.object2string.get(o);
                    if (string == null) {
                        string = o.toString();
                        this.object2string.put(o, string);
                    }
                    return string;
                }
            });
            int i = 0;
            for (SerializationMatchTerm matchTerm : matchTermList2) {
                matchTerm2id2.put(matchTerm, i++);
            }
        }
        return matchTermList2;
    }

    private static @Nullable String deduceMidfix(@NonNull String prefix, @NonNull String suffix) {
        int i = 0;
        while (i < prefix.length()) {
            String midfix = prefix.substring(i);
            if (suffix.startsWith(midfix)) {
                StringBuilder s = new StringBuilder();
                int j = 0;
                while (j < i) {
                    s.append(" ");
                    ++j;
                }
                s.append(midfix);
                return s.toString();
            }
            ++i;
        }
        return null;
    }

    protected List<@Nullable String> getMultipleLineCommentMidfixes(@NonNull Map<@NonNull String, @NonNull String> multipleLineCommentCharacterRanges) {
        ArrayList<@Nullable String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : multipleLineCommentCharacterRanges.entrySet()) {
            list.add(DeclarativeSerializerFragment.deduceMidfix(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    protected @NonNull Iterable<@NonNull Integer> getPageElementList(@Nullable Integer page, int size, int pageSize) {
        int pageEnd;
        int pageStart;
        if (page != null) {
            pageStart = page * pageSize;
            pageEnd = Math.min(pageStart + pageSize, size);
        } else {
            pageStart = 0;
            pageEnd = size;
        }
        ArrayList<@NonNull Integer> elements = new ArrayList<Integer>(size);
        int i = pageStart;
        while (i < pageEnd) {
            elements.add(i);
            ++i;
        }
        return elements;
    }

    protected @NonNull Iterable<@Nullable Integer> getPageNumberList(int size, int pageSize) {
        if (size > pageSize) {
            int pageCount = (size + pageSize - 1) / pageSize;
            ArrayList<@Nullable Integer> pages = new ArrayList<Integer>(pageCount);
            int i = 0;
            while (i < pageCount) {
                pages.add(i);
                ++i;
            }
            return pages;
        }
        return UNPAGED_PAGE_NUMBER_LIST;
    }

    protected TypeReference getSemanticSequencerClass(Grammar grammar) {
        throw new UnsupportedOperationException();
    }

    protected TypeReference getSerializationMetaDataClass(Grammar grammar) {
        return new TypeReference(this.getSerializerBasePackage(grammar), String.valueOf(GrammarUtil.getSimpleName((Grammar)grammar)) + "SerializationMetaData");
    }

    protected TypeReference getSerializationMetaDataProviderClass(Grammar grammar) {
        return new TypeReference(this.getSerializerBasePackage(grammar), String.valueOf(GrammarUtil.getSimpleName((Grammar)grammar)) + "SerializationMetaData.Provider");
    }

    protected TypeReference getSerializationMetaDataSuperClass(Grammar grammar) {
        return new TypeReference(AbstractSerializationMetaData.class);
    }

    protected @NonNull List<@NonNull SerializationRuleAnalysis> getSerializationRuleAnalysisList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull SerializationRuleAnalysis> serializationRuleAnalysisList2 = this.serializationRuleAnalysisList;
        if (serializationRuleAnalysisList2 == null) {
            timestamp.log("getSerializationRuleAnalysisList start");
            HashSet<@NonNull SerializationRuleAnalysis> serializationRuleAnalysesSet = new HashSet<SerializationRuleAnalysis>();
            for (AbstractRuleAnalysis ruleAnalysis : grammarAnalysis.getRuleAnalyses()) {
                if (!(ruleAnalysis instanceof ParserRuleAnalysis)) continue;
                for (SerializationRuleAnalysis serializationRule : ((ParserRuleAnalysis)ruleAnalysis).getSerializationRuleAnalyses()) {
                    serializationRuleAnalysesSet.add(serializationRule);
                }
            }
            serializationRuleAnalysisList2 = this.serializationRuleAnalysisList = new ArrayList<SerializationRuleAnalysis>(serializationRuleAnalysesSet);
            Collections.sort(serializationRuleAnalysisList2, new SerializationUtils.ToStringComparator());
            Map<@NonNull SerializationRule, @Nullable Integer> serializationRule2id2 = this.serializationRule2id;
            this.serializationRule2id = serializationRule2id2 = new HashMap<SerializationRule, Integer>();
            int i = 0;
            for (SerializationRuleAnalysis serializationRuleAnalysis : serializationRuleAnalysisList2) {
                serializationRule2id2.put(serializationRuleAnalysis.getSerializationRule(), i++);
            }
        }
        return serializationRuleAnalysisList2;
    }

    protected int getSerializationRuleCount() {
        assert (this.serializationRuleAnalysisList != null);
        return this.serializationRuleAnalysisList.size();
    }

    protected int getSerializationRuleIndex(@NonNull SerializationRule serializationRule) {
        assert (this.serializationRule2id != null);
        Integer id = this.serializationRule2id.get(serializationRule);
        assert (id != null);
        return id;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull List<@NonNull SerializationRule> getSerializationRuleList(@NonNull GrammarAnalysis grammarAnalysis, @NonNull ParserRuleValue parserRuleValue) {
        @NonNull ArrayList serializationRules = Lists.newArrayList((Object[])grammarAnalysis.getSerializationRules(parserRuleValue));
        assert (serializationRules != null);
        Collections.sort(serializationRules, new SerializationUtils.ToStringComparator());
        return serializationRules;
    }

    protected int getSerializationSegmentsCount() {
        assert (this.serializationSegments2id != null);
        return this.serializationSegments2id.size();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected int getSerializationSegmentsIndex(@NonNull SerializationSegment @Nullable [] segments) {
        if (segments == null) {
            return -1;
        }
        @NonNull ArrayList newArrayList = Lists.newArrayList((Object[])segments);
        assert (newArrayList != null);
        return this.getSerializationSegmentsIndex(newArrayList);
    }

    protected int getSerializationSegmentsIndex(@NonNull List<@NonNull SerializationSegment> segments) {
        assert (this.serializationSegments2id != null);
        Integer id = this.serializationSegments2id.get(segments);
        assert (id != null);
        return id;
    }

    protected @NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> getSerializationSegments2id() {
        assert (this.serializationSegments2id != null);
        return this.serializationSegments2id;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull List<@NonNull List<@NonNull SerializationSegment>> getSerializationSegmentsList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull List<@NonNull SerializationSegment>> serializationSegmentsList2 = this.serializationSegmentsList;
        if (serializationSegmentsList2 == null) {
            timestamp.log("getSerializationSegmentsList start");
            Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id2 = this.serializationSegments2id;
            if (serializationSegments2id2 == null) {
                this.serializationSegments2id = serializationSegments2id2 = new HashMap<List<SerializationSegment>, Integer>();
                serializationSegments2id2.put(SerializationSegment.VALUE_SEGMENTS_LIST, null);
                for (SerializationRuleAnalysis serializationRuleAnalysis : this.getSerializationRuleAnalysisList(grammarAnalysis)) {
                    SerializationStep[] serializationStepArray = serializationRuleAnalysis.getSerializationRule().getSerializationSteps();
                    int n = serializationStepArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SerializationStep serializationStep = serializationStepArray[n2];
                        @NonNull Object[] staticSegments = serializationStep.getSerializationSegments();
                        if (staticSegments != null && staticSegments.length > 0) {
                            @NonNull ArrayList serializationSegments = Lists.newArrayList((Object[])staticSegments);
                            assert (serializationSegments != null);
                            serializationSegments2id2.put(serializationSegments, null);
                        }
                        ++n2;
                    }
                }
            }
            serializationSegmentsList2 = this.serializationSegmentsList = new ArrayList<List<SerializationSegment>>(serializationSegments2id2.keySet());
            Collections.sort(serializationSegmentsList2, new SerializationUtils.ToStringComparator<List<SerializationSegment>>(){

                public int compare(@NonNull List<@NonNull SerializationSegment> o1, @NonNull List<@NonNull SerializationSegment> o2) {
                    int s2;
                    int s1 = o1.size();
                    int diff = s1 - (s2 = o2.size());
                    if (diff != 0) {
                        return diff;
                    }
                    return super.compare(o1, o2);
                }
            });
            int i = 0;
            for (List<SerializationSegment> segmentList : serializationSegmentsList2) {
                serializationSegments2id2.put(segmentList, i++);
            }
        }
        assert (SerializationSegment.VALUE_SEGMENTS_LIST.equals(serializationSegmentsList2.get(0)));
        return serializationSegmentsList2;
    }

    protected int getSerializationStepCount() {
        assert (this.serializationStep2id != null);
        return this.serializationStep2id.size();
    }

    protected int getSerializationStepIndex(@NonNull SerializationStep serializationStep) {
        assert (this.serializationStep2id != null);
        Integer id = this.serializationStep2id.get(serializationStep);
        assert (id != null);
        return id;
    }

    protected @NonNull List<@NonNull SerializationStep> getSerializationStepList(@NonNull GrammarAnalysis grammarAnalysis) {
        List<@NonNull SerializationStep> serializationStepList2 = this.serializationStepList;
        if (serializationStepList2 == null) {
            timestamp.log("getSerializationStepList start");
            Map<@NonNull SerializationStep, @Nullable Integer> serializationStep2id2 = this.serializationStep2id;
            if (serializationStep2id2 == null) {
                this.serializationStep2id = serializationStep2id2 = new HashMap<SerializationStep, Integer>();
            }
            for (EClassValue eClassValue : grammarAnalysis.getSortedProducedEClassValues()) {
                SerializationRule[] serializationRuleArray = eClassValue.getSerializationRules();
                int n = serializationRuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SerializationRule serializationRule = serializationRuleArray[n2];
                    SerializationStep[] serializationStepArray = serializationRule.getSerializationSteps();
                    int n3 = serializationStepArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SerializationStep serializationStep = serializationStepArray[n4];
                        serializationStep2id2.put(serializationStep, null);
                        ++n4;
                    }
                    ++n2;
                }
            }
            serializationStepList2 = this.serializationStepList = new ArrayList<SerializationStep>(serializationStep2id2.keySet());
            SerializationStepComparator serializationStepComparator = new SerializationStepComparator(serializationStepList2, this.getSerializationSegments2id());
            Collections.sort(serializationStepList2, serializationStepComparator);
            int i = 0;
            for (SerializationStep step : serializationStepList2) {
                if (serializationStepComparator.isGloballyConsistent(step)) {
                    if (step instanceof SerializationStep.SerializationStepAbstractFeature) {
                        if (this.firstGlobalSerializationStepAssignmentIndex < 0) {
                            this.firstGlobalSerializationStepAssignmentIndex = i;
                        }
                        this.lastGlobalSerializationStepAssignmentIndex = i;
                    } else if (step instanceof SerializationStep.SerializationStepKeyword) {
                        if (this.firstGlobalSerializationStepLiteralIndex < 0) {
                            this.firstGlobalSerializationStepLiteralIndex = i;
                        }
                        this.lastGlobalSerializationStepLiteralIndex = i;
                    }
                }
                serializationStep2id2.put(step, i++);
            }
        }
        return serializationStepList2;
    }

    protected String getSerializerBasePackage(Grammar grammar) {
        return String.valueOf(this.xtextGeneratorNaming.getRuntimeBasePackage(grammar)) + ".serializer";
    }

    protected TypeReference getSyntacticSequencerClass(Grammar grammar) {
        throw new UnsupportedOperationException();
    }

    protected void initSerializationMetaDataContent(@NonNull GrammarAnalysis grammarAnalysis) {
        this.getEnumerationValueList(grammarAnalysis);
        this.getSerializationSegmentsList(grammarAnalysis);
        this.getSerializationStepList(grammarAnalysis);
        this.getMatchTermList(grammarAnalysis);
        this.getMatchStepList(grammarAnalysis);
        this.getGrammarRuleValueList(grammarAnalysis);
        this.getGrammarRuleVectorList(grammarAnalysis);
        this.getEClassList(grammarAnalysis);
        this.getSerializationRuleAnalysisList(grammarAnalysis);
    }

    protected @NonNull Integer @NonNull [] integersIterable(int size) {
        @NonNull Integer @NonNull [] integers = new Integer[size];
        int i = 0;
        while (i < size) {
            integers[i] = i;
            ++i;
        }
        return integers;
    }

    protected @NonNull String newTypeReference(@NonNull Class<?> referredClass) {
        return this.newTypeReference(referredClass.getName());
    }

    protected @NonNull String newTypeReference(@Nullable String referredClassName) {
        if (referredClassName == null) {
            return "";
        }
        int index = referredClassName.lastIndexOf(36);
        if (index >= 0) {
            this.referredClassNames.add(referredClassName);
            String substring = referredClassName.substring(index + 1);
            assert (substring != null);
            return substring;
        }
        this.referredClassNames.add(referredClassName);
        index = referredClassName.lastIndexOf(46);
        String substring = referredClassName.substring(index + 1);
        assert (substring != null);
        return substring;
    }

    public @NonNull String toString(@NonNull GrammarRuleVector grammarRuleVector) {
        DeclarativeSerializerFragmentDiagnosticStringBuilder s = new DeclarativeSerializerFragmentDiagnosticStringBuilder();
        grammarRuleVector.toString((DiagnosticStringBuilder)s);
        return s.toString();
    }

    public @NonNull String toString(@NonNull SerializationMatchStep matchStep) {
        DeclarativeSerializerFragmentDiagnosticStringBuilder s = new DeclarativeSerializerFragmentDiagnosticStringBuilder();
        matchStep.toString((DiagnosticStringBuilder)s);
        return s.toString();
    }

    public @NonNull String toString(@NonNull SerializationRule serializationRule) {
        DeclarativeSerializerFragmentDiagnosticStringBuilder s = new DeclarativeSerializerFragmentDiagnosticStringBuilder();
        s.append(serializationRule.getName());
        s.append(": ");
        serializationRule.toRuleString((DiagnosticStringBuilder)s);
        return s.toString();
    }

    public @NonNull String toString(@NonNull SerializationStep serializationStep) {
        DeclarativeSerializerFragmentDiagnosticStringBuilder s = new DeclarativeSerializerFragmentDiagnosticStringBuilder();
        serializationStep.toString((DiagnosticStringBuilder)s, 0);
        return s.toString();
    }

    protected final class DeclarativeSerializerFragmentDiagnosticStringBuilder
    extends DiagnosticStringBuilder {
        protected DeclarativeSerializerFragmentDiagnosticStringBuilder() {
        }

        public void appendRuleName(int ruleValueIndex) {
            assert (DeclarativeSerializerFragment.this.grammarRuleValueIndex2ruleName != null);
            this.appendObject(DeclarativeSerializerFragment.this.grammarRuleValueIndex2ruleName.get(ruleValueIndex));
        }
    }

    protected static final class SerializationStepComparator
    extends SerializationUtils.ToStringComparator<SerializationStep> {
        protected final @NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id;
        private @NonNull Map<@NonNull SerializationStep, @NonNull String> step2key = new HashMap<SerializationStep, String>();
        private @NonNull Map<@NonNull String, @NonNull Object> key2indexOrIndexes = new HashMap<String, Object>();

        public SerializationStepComparator(@NonNull List<@NonNull SerializationStep> serializationStepList, @NonNull Map<@NonNull List<@NonNull SerializationSegment>, @Nullable Integer> serializationSegments2id) {
            this.serializationSegments2id = serializationSegments2id;
            int index = 0;
            for (SerializationStep step : serializationStepList) {
                ArrayList<Integer> indexes;
                String key = step.getGlobalSortKey(serializationSegments2id);
                this.step2key.put(step, key);
                Object indexOrIndexes = SerializationUtils.maybeNull((Object)this.key2indexOrIndexes.get(key));
                if (indexOrIndexes == null) {
                    this.key2indexOrIndexes.put(key, index);
                } else if (!(indexOrIndexes instanceof List)) {
                    indexes = new ArrayList<Integer>();
                    this.key2indexOrIndexes.put(key, indexes);
                    indexes.add((Integer)indexOrIndexes);
                    indexes.add(index);
                } else {
                    indexes = (ArrayList<Integer>)indexOrIndexes;
                    indexes.add(index);
                }
                ++index;
            }
        }

        public int compare(@NonNull SerializationStep s1, @NonNull SerializationStep s2) {
            Class<?> c2;
            String k1 = (String)SerializationUtils.nonNullState((Object)this.step2key.get(s1));
            String k2 = (String)SerializationUtils.nonNullState((Object)this.step2key.get(s2));
            Class<?> c1 = SerializationUtils.nonNullState((Object)this.key2indexOrIndexes.get(k1)).getClass();
            if (c1 != (c2 = SerializationUtils.nonNullState((Object)this.key2indexOrIndexes.get(k2)).getClass())) {
                return c1 == Integer.class ? -1 : 1;
            }
            int comparison = k1.compareTo(k2);
            if (comparison != 0) {
                return comparison;
            }
            int r1 = -999;
            int r2 = -999;
            if (s1 instanceof SerializationStep.SerializationStepSequence) {
                r1 = ((SerializationStep.SerializationStepSequence)s1).getStepsRange();
            }
            if (s2 instanceof SerializationStep.SerializationStepSequence) {
                r2 = ((SerializationStep.SerializationStepSequence)s2).getStepsRange();
            }
            if (r1 != r2) {
                return r1 - r2;
            }
            return super.compare((Object)s1, (Object)s2);
        }

        public boolean isGloballyConsistent(@NonNull SerializationStep step) {
            return this.key2indexOrIndexes.get(this.step2key.get(step)) instanceof Integer;
        }
    }
}

