/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.build.analysis.AbstractRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.AssignmentAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.ParserRuleAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;

public abstract class AbstractAssignmentAnalysis<T extends AbstractElement>
implements AssignmentAnalysis {
    protected final @NonNull GrammarAnalysis grammarAnalysis;
    protected final @NonNull ParserRuleAnalysis sourceRuleAnalysis;
    protected final @NonNull EClass eClass;
    protected final @NonNull EStructuralFeature eStructuralFeature;
    protected final @NonNull T actionOrAssignment;
    private final @NonNull List<@NonNull AbstractRuleAnalysis> targetRuleAnalyses = new ArrayList<AbstractRuleAnalysis>();

    protected AbstractAssignmentAnalysis(@NonNull ParserRuleAnalysis sourceRuleAnalysis, @NonNull EClass eClass, @NonNull String featureName, @NonNull T actionOrAssignment) {
        this.grammarAnalysis = sourceRuleAnalysis.getGrammarAnalysis();
        this.sourceRuleAnalysis = sourceRuleAnalysis;
        this.eClass = eClass;
        this.eStructuralFeature = SerializationUtils.getEStructuralFeature((EClass)eClass, (String)featureName);
        this.actionOrAssignment = actionOrAssignment;
    }

    protected void addTargetRuleAnalysis(@NonNull AbstractRuleAnalysis targetRuleAnalysis) {
        if (targetRuleAnalysis instanceof ParserRuleAnalysis) {
            Collection<@NonNull ParserRuleAnalysis> subRuleAnalysesClosure = ((ParserRuleAnalysis)targetRuleAnalysis).getSubRuleAnalysesClosure();
            for (ParserRuleAnalysis ruleAnalysis : subRuleAnalysesClosure) {
                this.targetRuleAnalyses.add(ruleAnalysis);
            }
        } else {
            this.targetRuleAnalyses.add(targetRuleAnalysis);
        }
    }

    protected void analyzeContainment() {
        EReference eReference;
        if (this.eStructuralFeature instanceof EReference && (eReference = (EReference)this.eStructuralFeature).isContainment()) {
            this.grammarAnalysis.addContainment(this, eReference);
        }
    }

    public @NonNull T getActionOrAssignment() {
        return this.actionOrAssignment;
    }

    public @NonNull String getCardinality() {
        String cardinality = this.actionOrAssignment.getCardinality();
        return cardinality != null ? cardinality : "@";
    }

    @Override
    public @NonNull EClass getEClass() {
        return this.eClass;
    }

    @Override
    public @NonNull EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    @Override
    public @NonNull GrammarAnalysis getGrammarAnalysis() {
        return this.grammarAnalysis;
    }

    public @NonNull GrammarCardinality getGrammarCardinality() {
        return GrammarCardinality.toEnum(this.actionOrAssignment);
    }

    public @NonNull String getName() {
        return String.valueOf(SerializationUtils.getName((AbstractRule)this.sourceRuleAnalysis.getRule())) + "-" + this.eStructuralFeature.getName();
    }

    @Override
    public @NonNull ParserRuleAnalysis getSourceRuleAnalysis() {
        return this.sourceRuleAnalysis;
    }

    public @NonNull List<@NonNull AbstractRuleAnalysis> getTargetRuleAnalyses() {
        return this.targetRuleAnalyses;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getName());
        s.append(" : ");
        boolean isFirst = true;
        for (AbstractRuleAnalysis targetRuleAnalysis : this.getTargetRuleAnalyses()) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(targetRuleAnalysis.getQualifiedName());
            isFirst = false;
        }
        @NonNull String castString = s.toString();
        return castString;
    }
}

