/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests;

import junit.textui.TestRunner;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.filters.OrFilter;
import org.eclipse.ocl.examples.eventmanager.tests.filters.ClassFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.EventFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.util.BaseTest;
import org.junit.Test;

public class EventManagerTest
extends BaseTest {
    protected EventManager fixture = null;
    private ResourceImpl res;

    public static void main(String[] args) {
        TestRunner.run(EventManagerTest.class);
    }

    protected void setFixture(EventManager fixture) {
        this.fixture = fixture;
    }

    protected EventManager getFixture() {
        return this.fixture;
    }

    public void setUp() throws Exception {
        super.setUp();
        ResourceSetImpl set = new ResourceSetImpl();
        this.res = new ResourceImpl();
        set.getResources().add((Object)this.res);
        this.setFixture(EventManagerFactory.eINSTANCE.getEventManagerFor((ResourceSet)set));
    }

    public void tearDown() {
        this.setFixture(null);
        this.res = null;
    }

    @Test
    public void testSimpleElementInsertFilter() {
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        EventFilter f = EventManagerFactory.eINSTANCE.createFilterForElementInsertionOrDeletion(cls);
        this.res.getContents().add((Object)new DynamicEObjectImpl(cls));
        Application app = new Application();
        this.getFixture().subscribe(f, (Adapter)app);
        this.getFixture().handleEMFEvent((Notification)new NotificationImpl(3, null, new DynamicEObjectImpl(cls)){

            public Object getFeature() {
                EReference ref = EcoreFactory.eINSTANCE.createEReference();
                ref.setContainment(true);
                return ref;
            }
        });
        EventManagerTest.assertTrue((String)"Not notified", (boolean)app.isNotified());
    }

    @Test
    public void testDoubleElementInsertFilter() {
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        EventFilter f1 = EventManagerFactory.eINSTANCE.createFilterForElementInsertionOrDeletion(cls);
        EventFilter f2 = EventManagerFactory.eINSTANCE.createFilterForElementInsertionOrDeletion(cls);
        OrFilter f = new OrFilter(new EventFilter[]{f1, f2});
        Application app = new Application();
        this.getFixture().subscribe((EventFilter)f, (Adapter)app);
        this.getFixture().handleEMFEvent((Notification)new NotificationImpl(3, null, new DynamicEObjectImpl(cls)){

            public Object getFeature() {
                EReference ref = EcoreFactory.eINSTANCE.createEReference();
                ref.setContainment(true);
                return ref;
            }
        });
        EventManagerTest.assertTrue((String)"Not notified", (boolean)app.isNotified());
    }

    public void testUnsubscribe__Adapter() {
        ClassFilterTest test = new ClassFilterTest();
        Application adapter = new Application();
        this.assertSubscribeAndUnsubscribe(test, adapter);
    }

    public void testUnsubscribeDouble__Adapter() {
        ClassFilterTest test = new ClassFilterTest();
        Application adapter = new Application();
        this.assertSubscribeAndUnsubscribe(test, adapter);
        this.assertSubscribeAndUnsubscribe(test, adapter);
    }

    public void testUnsubscribeDoubleAndDifferentFilters__Adapter() {
        Application adapter = new Application();
        this.assertSubscribeAndUnsubscribe(new ClassFilterTest(), adapter);
        this.assertSubscribeAndUnsubscribe(new ClassFilterTest(), adapter);
    }

    public void testUnsubscribeFiltersWithListAsCrit__Adapter() {
        EClass cls1 = EcoreFactory.eINSTANCE.createEClass();
        EClass cls2 = EcoreFactory.eINSTANCE.createEClass();
        cls1.getESuperTypes().add((Object)cls2);
        Application adapter = new Application();
        EventFilter f = EventManagerFactory.eINSTANCE.createAndFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createNewValueClassFilterIncludingSubclasses(cls2), EventManagerFactory.eINSTANCE.createNewValueClassFilterIncludingSubclasses(cls1)});
        this.getFixture().subscribe(f, (Adapter)adapter);
        this.getFixture().unsubscribe((Adapter)adapter);
        BasicEList list = new BasicEList();
        list.add((Object)new DynamicEObjectImpl(cls1));
        list.add((Object)new DynamicEObjectImpl(cls2));
        this.getFixture().handleEMFEvent((Notification)new ENotificationImpl(null, 0, null, null, (Object)list));
        EventManagerTest.assertFalse((String)"App get wrongly notified", (boolean)adapter.isNotified());
    }

    private void assertSubscribeAndUnsubscribe(EventFilterTest test, Application adapter) {
        this.getFixture().subscribe(test.giveTestFilter(), (Adapter)adapter);
        this.getFixture().handleEMFEvent(test.giveMatchingNotifications()[0]);
        EventManagerTest.assertTrue((String)"Subscription failed", (boolean)adapter.isNotified());
        this.getFixture().unsubscribe((Adapter)adapter);
        adapter.reset();
        this.getFixture().handleEMFEvent(test.giveMatchingNotifications()[0]);
        EventManagerTest.assertFalse((String)"Unsubscription failed", (boolean)adapter.isNotified());
    }

    public void testResourceAddContainmentFilter() {
        Application app = new Application();
        this.getFixture().subscribe(EventManagerFactory.eINSTANCE.createContainmentFilter(), (Adapter)app);
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        this.res.getContents().add((Object)new DynamicEObjectImpl(cls));
        EventManagerTest.assertTrue((String)"Not notified", (boolean)app.isNotified());
    }

    public void testDoubleSubscribeOneFilter() {
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        Application app1 = new Application();
        Application app2 = new Application();
        EventFilter f = EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(cls);
        this.getFixture().subscribe(f, (Adapter)app1);
        this.getFixture().subscribe(f, (Adapter)app2);
        this.getFixture().handleEMFEvent((Notification)new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(cls), 0, null, null, null));
        EventManagerTest.assertTrue((String)"App1 not get notified", (boolean)app1.isNotified());
        EventManagerTest.assertTrue((String)"App2 not get notified", (boolean)app2.isNotified());
    }

    public void testDoubleSubscribeTwoFilter() {
        EClass cls = EcoreFactory.eINSTANCE.createEClass();
        Application app1 = new Application();
        Application app2 = new Application();
        EventFilter f1 = EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(cls);
        EventFilter f2 = EventManagerFactory.eINSTANCE.createOrFilterFor(new EventFilter[]{EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(cls), EventManagerFactory.eINSTANCE.createContainmentFilter()});
        this.getFixture().subscribe(f1, (Adapter)app1);
        this.getFixture().subscribe(f2, (Adapter)app2);
        this.getFixture().handleEMFEvent((Notification)new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(cls), 0, null, null, null));
        EventManagerTest.assertTrue((String)"App1 not get notified", (boolean)app1.isNotified());
        EventManagerTest.assertTrue((String)"App2 not get notified", (boolean)app2.isNotified());
    }

    public void testDoubleSubscribeCreate2MatchingFilterTableEntries() {
        EClass cls1 = EcoreFactory.eINSTANCE.createEClass();
        EClass cls2 = EcoreFactory.eINSTANCE.createEClass();
        cls1.getESuperTypes().add((Object)cls2);
        Application app1 = new Application();
        Application app2 = new Application();
        EventFilter f1 = EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(cls1);
        EventFilter f2 = EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(cls2);
        this.getFixture().subscribe(f1, (Adapter)app1);
        this.getFixture().subscribe(f2, (Adapter)app2);
        this.getFixture().handleEMFEvent((Notification)new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(cls1), 0, null, null, null));
        EventManagerTest.assertTrue((String)"App1 not get notified", (boolean)app1.isNotified());
        EventManagerTest.assertTrue((String)"App2 not get notified", (boolean)app2.isNotified());
    }

    public void testDoubleSubscribeCreate2MatchingFilterTableEntriesSameApp() {
        EClass cls1 = EcoreFactory.eINSTANCE.createEClass();
        EClass cls2 = EcoreFactory.eINSTANCE.createEClass();
        cls1.getESuperTypes().add((Object)cls2);
        EventFilter f1 = EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(cls1);
        EventFilter f2 = EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(cls2);
        Application app = new Application(){
            public Integer count = 0;

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                this.count = this.count + 1;
            }

            public boolean isNotified() {
                Integer n = this.count;
                this.count = n - 1;
                return n > 1;
            }
        };
        this.getFixture().subscribe(f1, (Adapter)app);
        this.getFixture().subscribe(f2, (Adapter)app);
        this.getFixture().handleEMFEvent((Notification)new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(cls1), 0, null, null, null));
        EventManagerTest.assertTrue((String)"App not get notified", (boolean)app.isNotified());
        EventManagerTest.assertFalse((String)"App get notified more than once", (boolean)app.isNotified());
    }

    public static class Application
    extends AdapterImpl
    implements Adapter {
        private boolean b = false;

        public boolean isNotified() {
            return this.b;
        }

        public void reset() {
            this.b = false;
        }

        public void notifyChanged(Notification msg) {
            this.b = true;
        }

        public String toString() {
            return this.isNotified() ? "" : "not notfied app";
        }
    }
}

