/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.browser.queries.SelectedQuery;
import org.eclipse.modisco.infra.browser.uicore.ChangeListener;
import org.eclipse.modisco.infra.query.ModelQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedQueriesManager {
    private final Map<EObject, List<SelectedQuery>> selectedQueries = new HashMap<EObject, List<SelectedQuery>>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public void add(EObject eObject, ModelQuery modelQuery) {
        SelectedQuery selectedQuery2;
        if (modelQuery == null) {
            throw new IllegalArgumentException("modelQuery is null");
        }
        List<SelectedQuery> list = this.selectedQueries.get(eObject);
        if (list == null) {
            list = new ArrayList<SelectedQuery>();
            this.selectedQueries.put(eObject, list);
        }
        for (SelectedQuery selectedQuery2 : list) {
            if (selectedQuery2.getModelQuery() != modelQuery) continue;
            return;
        }
        selectedQuery2 = new SelectedQuery(modelQuery, eObject, this);
        list.add(selectedQuery2);
        this.fireChangeNotification();
    }

    public void remove(SelectedQuery selectedQuery) {
        boolean changed = false;
        Collection<List<SelectedQuery>> values = this.selectedQueries.values();
        for (List<SelectedQuery> list : values) {
            ListIterator<SelectedQuery> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                if (listIterator.next() != selectedQuery) continue;
                changed = true;
                listIterator.remove();
            }
        }
        if (changed) {
            this.fireChangeNotification();
        }
    }

    public void clear() {
        this.selectedQueries.clear();
        this.fireChangeNotification();
    }

    public List<SelectedQuery> getSelectedQueriesFor(EObject eObject) {
        return this.selectedQueries.get(eObject);
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeNotification() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.changed();
        }
    }
}

