/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class DoubleColumn
extends AbstractColumn {
    private double[] m_values;
    private int m_size;

    public DoubleColumn() {
        this(0, 10, 0.0);
    }

    public DoubleColumn(int nrows) {
        this(nrows, nrows, 0.0);
    }

    public DoubleColumn(int nrows, int capacity, double defaultValue) {
        super(Double.TYPE, new Double(defaultValue));
        if (capacity < nrows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new double[capacity];
        Arrays.fill(this.m_values, defaultValue);
        this.m_size = nrows;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int nrows) {
        if (nrows > this.m_values.length) {
            int capacity = Math.max(3 * this.m_values.length / 2 + 1, nrows);
            double[] values = new double[capacity];
            System.arraycopy(this.m_values, 0, values, 0, this.m_size);
            Arrays.fill(values, this.m_size, capacity, (Double)this.m_defaultValue);
            this.m_values = values;
        }
        this.m_size = nrows;
    }

    public Object get(int row) {
        return new Double(this.getDouble(row));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (val == null) throw new DataTypeException("Column does not accept null values");
        if (val instanceof Number) {
            this.setDouble(((Number)val).doubleValue(), row);
            return;
        } else {
            if (!(val instanceof String)) throw new DataTypeException(val.getClass());
            this.setString((String)val, row);
        }
    }

    public double getDouble(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    public void setDouble(double val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        double prev = this.m_values[row];
        if (prev == val) {
            return;
        }
        this.m_values[row] = val;
        this.fireColumnEvent(row, prev);
    }

    public int getInt(int row) throws DataTypeException {
        return (int)this.getDouble(row);
    }

    public void setInt(int val, int row) throws DataTypeException {
        this.setDouble(val, row);
    }

    public long getLong(int row) throws DataTypeException {
        return (long)this.getDouble(row);
    }

    public void setLong(long val, int row) throws DataTypeException {
        this.setDouble(val, row);
    }

    public float getFloat(int row) throws DataTypeException {
        return (float)this.getDouble(row);
    }

    public void setFloat(float val, int row) throws DataTypeException {
        this.setDouble(val, row);
    }
}

