/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.data.query.NumberRangeModel;
import prefuse.util.ArrayLib;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;

public class StackedAreaChart
extends Layout {
    private String m_field;
    private String m_start;
    private String m_end;
    private String[] columns;
    private double[] baseline;
    private double[] peaks;
    private float[] poly;
    private double m_padding = 0.05;
    private float m_threshold;
    private Rectangle2D bounds;
    private int m_orientation = 3;
    private boolean m_horiz = false;
    private boolean m_top = false;
    private boolean m_norm = false;
    private NumberRangeModel m_model;

    public StackedAreaChart(String group, String field, String[] columns) {
        this(group, field, columns, 1.0);
    }

    public StackedAreaChart(String group, String field, String[] columns, double threshold) {
        super(group);
        this.columns = columns;
        this.baseline = new double[columns.length];
        this.peaks = new double[columns.length];
        this.poly = new float[4 * columns.length];
        this.m_field = field;
        this.m_start = PrefuseLib.getStartField(field);
        this.m_end = PrefuseLib.getEndField(field);
        this.setThreshold(threshold);
        this.m_model = new NumberRangeModel(0, 1, 0, 1);
    }

    public void setColumns(String[] cols) {
        this.columns = cols;
    }

    public void setNormalized(boolean b) {
        this.m_norm = b;
    }

    public boolean isNormalized() {
        return this.m_norm;
    }

    public double getPaddingPercentage() {
        return this.m_padding;
    }

    public void setPaddingPercentage(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Illegal padding percentage: " + p);
        }
        this.m_padding = p;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public void setThreshold(double threshold) {
        this.m_threshold = (float)threshold;
    }

    public ValuedRangeModel getRangeModel() {
        return this.m_model;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int orient) {
        if (orient != 2 && orient != 3 && orient != 0 && orient != 1) {
            throw new IllegalArgumentException("Invalid orientation value: " + orient);
        }
        this.m_orientation = orient;
        this.m_horiz = this.m_orientation == 0 || this.m_orientation == 1;
        this.m_top = this.m_orientation == 2 || this.m_orientation == 0;
    }

    public void run(double frac) {
        this.bounds = this.getLayoutBounds();
        Arrays.fill(this.baseline, 0.0);
        float min = (float)(this.m_horiz ? this.bounds.getMaxY() : this.bounds.getMinX());
        float hgt = (float)(this.m_horiz ? this.bounds.getWidth() : this.bounds.getHeight());
        int xbias = this.m_horiz ? 1 : 0;
        int ybias = this.m_horiz ? 0 : 1;
        int mult = this.m_top ? 1 : -1;
        float inc = (float)(this.m_horiz ? this.bounds.getMinY() - this.bounds.getMaxY() : this.bounds.getMaxX() - this.bounds.getMinX());
        inc /= (float)(this.columns.length - 1);
        int len = this.columns.length;
        double maxValue = this.getPeaks();
        float b = (float)(this.m_horiz ? (this.m_top ? this.bounds.getMinX() : this.bounds.getMaxX()) : (this.m_top ? this.bounds.getMinY() : this.bounds.getMaxY()));
        Arrays.fill(this.baseline, (double)b);
        this.m_model.setValueRange(0.0, maxValue, 0.0, maxValue);
        Table t = (Table)this.m_vis.getGroup(this.m_group);
        Iterator iter = t.tuplesReversed();
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            if (!item.isVisible()) continue;
            float height = 0.0f;
            int i = len;
            while (--i >= 0) {
                this.poly[2 * (len - 1 - i) + xbias] = min + (float)i * inc;
                this.poly[2 * (len - 1 - i) + ybias] = (float)this.baseline[i];
            }
            i = 0;
            while (i < this.columns.length) {
                int base = 2 * (len + i);
                double value = item.getDouble(this.columns[i]);
                int n = i;
                this.baseline[n] = this.baseline[n] + (double)((float)mult * hgt) * MathLib.linearInterp(value, 0.0, this.peaks[i]);
                this.poly[base + xbias] = min + (float)i * inc;
                this.poly[base + ybias] = (float)this.baseline[i];
                height = Math.max(height, Math.abs(this.poly[2 * (len - 1 - i) + ybias] - this.poly[base + ybias]));
                ++i;
            }
            if (height < this.m_threshold) {
                item.setVisible(false);
            }
            this.setX(item, null, 0.0);
            this.setY(item, null, 0.0);
            this.setPolygon(item, this.poly);
        }
    }

    private double getPeaks() {
        double sum = 0.0;
        Arrays.fill(this.peaks, 0.0);
        Iterator iter = this.m_vis.visibleItems(this.m_group);
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            int i = 0;
            while (i < this.columns.length) {
                double val = item.getDouble(this.columns[i]);
                int n = i++;
                this.peaks[n] = this.peaks[n] + val;
                sum += val;
            }
        }
        double max = ArrayLib.max(this.peaks);
        if (!this.m_norm) {
            Arrays.fill(this.peaks, max);
        }
        if (!this.m_norm) {
            int i = 0;
            while (i < this.peaks.length) {
                int n = i;
                this.peaks[n] = this.peaks[n] + this.m_padding * this.peaks[i];
                ++i;
            }
            max += this.m_padding * max;
        }
        if (this.m_norm) {
            max = 1.0;
        }
        if (Double.isNaN(max)) {
            max = 0.0;
        }
        return max;
    }

    private void setPolygon(VisualItem item, float[] poly) {
        float[] a = this.getPolygon(item, this.m_field);
        float[] s = this.getPolygon(item, this.m_start);
        float[] e = this.getPolygon(item, this.m_end);
        System.arraycopy(a, 0, s, 0, a.length);
        System.arraycopy(poly, 0, a, 0, poly.length);
        System.arraycopy(poly, 0, e, 0, poly.length);
        item.setValidated(false);
    }

    private float[] getPolygon(VisualItem item, String field) {
        float[] poly = (float[])item.get(field);
        if (poly == null || poly.length < 4 * this.columns.length) {
            int len = this.columns.length;
            float inc = (float)(this.m_horiz ? this.bounds.getMinY() - this.bounds.getMaxY() : this.bounds.getMaxX() - this.bounds.getMinX());
            inc /= (float)(len - 1);
            float max = (float)(this.m_horiz ? (this.m_top ? this.bounds.getMaxX() : this.bounds.getMinX()) : (this.m_top ? this.bounds.getMinY() : this.bounds.getMaxY()));
            float min = (float)(this.m_horiz ? this.bounds.getMaxY() : this.bounds.getMinX());
            int bias = this.m_horiz ? 1 : 0;
            poly = new float[4 * len];
            Arrays.fill(poly, max);
            int i = 0;
            while (i < len) {
                float x;
                poly[2 * (len + i) + bias] = x = (float)i * inc + min;
                poly[2 * (len - 1 - i) + bias] = x;
                ++i;
            }
            item.set(field, (Object)poly);
        }
        return poly;
    }
}

