/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;

public class CompositeComparator
implements Comparator {
    private static final int INCREMENT = 2;
    private Comparator[] m_cmp;
    private int m_rev = 1;
    private int m_size = 0;

    public CompositeComparator(int size) {
        this(size, false);
    }

    public CompositeComparator(int size, boolean reverse) {
        this.m_cmp = new Comparator[size];
        this.m_rev = reverse ? -1 : 1;
    }

    public CompositeComparator(Comparator[] cmp) {
        this(cmp, false);
    }

    public CompositeComparator(Comparator[] cmp, boolean reverse) {
        this(cmp.length, reverse);
        System.arraycopy(cmp, 0, this.m_cmp, 0, cmp.length);
        this.m_size = cmp.length;
    }

    public void add(Comparator c) {
        if (c == null) {
            return;
        }
        if (this.m_cmp.length == this.m_size) {
            Comparator[] cmp = new Comparator[this.m_size + 2];
            System.arraycopy(this.m_cmp, 0, cmp, 0, this.m_size);
            this.m_cmp = cmp;
        }
        this.m_cmp[this.m_size++] = c;
    }

    public boolean remove(Comparator c) {
        int i = 0;
        while (i < this.m_size) {
            if (this.m_cmp[i].equals(c)) {
                System.arraycopy(this.m_cmp, i + 1, this.m_cmp, i, this.m_size - i);
                --this.m_size;
                return true;
            }
            ++i;
        }
        return false;
    }

    public int compare(Object o1, Object o2) {
        int i = 0;
        while (i < this.m_cmp.length) {
            int c = this.m_cmp[i].compare(o1, o2);
            if (c != 0) {
                return this.m_rev * c;
            }
            ++i;
        }
        return 0;
    }
}

