/**
 *   Copyright (c) 2010 Mia-Software.
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *   
 *   Contributors:
 *   
 *       Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.modisco.jee.webapp.webapp25;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.modisco.jee.webapp.webapp25.Webapp25Package
 * @generated
 */
public interface Webapp25Factory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	Webapp25Factory eINSTANCE = org.eclipse.modisco.jee.webapp.webapp25.impl.Webapp25FactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Auth Constraint Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Auth Constraint Type</em>'.
	 * @generated
	 */
	AuthConstraintType createAuthConstraintType();

	/**
	 * Returns a new object of class '<em>Auth Method Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Auth Method Type</em>'.
	 * @generated
	 */
	AuthMethodType createAuthMethodType();

	/**
	 * Returns a new object of class '<em>Description Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Description Type</em>'.
	 * @generated
	 */
	DescriptionType createDescriptionType();

	/**
	 * Returns a new object of class '<em>Dispatcher Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Dispatcher Type</em>'.
	 * @generated
	 */
	DispatcherType createDispatcherType();

	/**
	 * Returns a new object of class '<em>Display Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Display Name Type</em>'.
	 * @generated
	 */
	DisplayNameType createDisplayNameType();

	/**
	 * Returns a new object of class '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Document Root</em>'.
	 * @generated
	 */
	DocumentRoot createDocumentRoot();

	/**
	 * Returns a new object of class '<em>Ejb Link Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ejb Link Type</em>'.
	 * @generated
	 */
	EjbLinkType createEjbLinkType();

	/**
	 * Returns a new object of class '<em>Ejb Local Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ejb Local Ref Type</em>'.
	 * @generated
	 */
	EjbLocalRefType createEjbLocalRefType();

	/**
	 * Returns a new object of class '<em>Ejb Ref Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ejb Ref Name Type</em>'.
	 * @generated
	 */
	EjbRefNameType createEjbRefNameType();

	/**
	 * Returns a new object of class '<em>Ejb Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ejb Ref Type</em>'.
	 * @generated
	 */
	EjbRefType createEjbRefType();

	/**
	 * Returns a new object of class '<em>Ejb Ref Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ejb Ref Type Type</em>'.
	 * @generated
	 */
	EjbRefTypeType createEjbRefTypeType();

	/**
	 * Returns a new object of class '<em>Empty Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Empty Type</em>'.
	 * @generated
	 */
	EmptyType createEmptyType();

	/**
	 * Returns a new object of class '<em>Env Entry Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Env Entry Type</em>'.
	 * @generated
	 */
	EnvEntryType createEnvEntryType();

	/**
	 * Returns a new object of class '<em>Env Entry Type Values Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Env Entry Type Values Type</em>'.
	 * @generated
	 */
	EnvEntryTypeValuesType createEnvEntryTypeValuesType();

	/**
	 * Returns a new object of class '<em>Error Code Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Error Code Type</em>'.
	 * @generated
	 */
	ErrorCodeType createErrorCodeType();

	/**
	 * Returns a new object of class '<em>Error Page Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Error Page Type</em>'.
	 * @generated
	 */
	ErrorPageType createErrorPageType();

	/**
	 * Returns a new object of class '<em>Filter Mapping Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Filter Mapping Type</em>'.
	 * @generated
	 */
	FilterMappingType createFilterMappingType();

	/**
	 * Returns a new object of class '<em>Filter Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Filter Name Type</em>'.
	 * @generated
	 */
	FilterNameType createFilterNameType();

	/**
	 * Returns a new object of class '<em>Filter Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Filter Type</em>'.
	 * @generated
	 */
	FilterType createFilterType();

	/**
	 * Returns a new object of class '<em>Form Login Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Form Login Config Type</em>'.
	 * @generated
	 */
	FormLoginConfigType createFormLoginConfigType();

	/**
	 * Returns a new object of class '<em>Fully Qualified Class Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Fully Qualified Class Type</em>'.
	 * @generated
	 */
	FullyQualifiedClassType createFullyQualifiedClassType();

	/**
	 * Returns a new object of class '<em>Generic Boolean Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Generic Boolean Type</em>'.
	 * @generated
	 */
	GenericBooleanType createGenericBooleanType();

	/**
	 * Returns a new object of class '<em>Home Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Home Type</em>'.
	 * @generated
	 */
	HomeType createHomeType();

	/**
	 * Returns a new object of class '<em>Icon Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Icon Type</em>'.
	 * @generated
	 */
	IconType createIconType();

	/**
	 * Returns a new object of class '<em>Injection Target Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Injection Target Type</em>'.
	 * @generated
	 */
	InjectionTargetType createInjectionTargetType();

	/**
	 * Returns a new object of class '<em>Java Identifier Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Java Identifier Type</em>'.
	 * @generated
	 */
	JavaIdentifierType createJavaIdentifierType();

	/**
	 * Returns a new object of class '<em>Java Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Java Type Type</em>'.
	 * @generated
	 */
	JavaTypeType createJavaTypeType();

	/**
	 * Returns a new object of class '<em>Jndi Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Jndi Name Type</em>'.
	 * @generated
	 */
	JndiNameType createJndiNameType();

	/**
	 * Returns a new object of class '<em>Jsp Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Jsp Config Type</em>'.
	 * @generated
	 */
	JspConfigType createJspConfigType();

	/**
	 * Returns a new object of class '<em>Jsp File Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Jsp File Type</em>'.
	 * @generated
	 */
	JspFileType createJspFileType();

	/**
	 * Returns a new object of class '<em>Jsp Property Group Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Jsp Property Group Type</em>'.
	 * @generated
	 */
	JspPropertyGroupType createJspPropertyGroupType();

	/**
	 * Returns a new object of class '<em>Lifecycle Callback Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Lifecycle Callback Type</em>'.
	 * @generated
	 */
	LifecycleCallbackType createLifecycleCallbackType();

	/**
	 * Returns a new object of class '<em>Listener Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Listener Type</em>'.
	 * @generated
	 */
	ListenerType createListenerType();

	/**
	 * Returns a new object of class '<em>Locale Encoding Mapping List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Locale Encoding Mapping List Type</em>'.
	 * @generated
	 */
	LocaleEncodingMappingListType createLocaleEncodingMappingListType();

	/**
	 * Returns a new object of class '<em>Locale Encoding Mapping Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Locale Encoding Mapping Type</em>'.
	 * @generated
	 */
	LocaleEncodingMappingType createLocaleEncodingMappingType();

	/**
	 * Returns a new object of class '<em>Local Home Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Local Home Type</em>'.
	 * @generated
	 */
	LocalHomeType createLocalHomeType();

	/**
	 * Returns a new object of class '<em>Local Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Local Type</em>'.
	 * @generated
	 */
	LocalType createLocalType();

	/**
	 * Returns a new object of class '<em>Login Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Login Config Type</em>'.
	 * @generated
	 */
	LoginConfigType createLoginConfigType();

	/**
	 * Returns a new object of class '<em>Message Destination Link Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Message Destination Link Type</em>'.
	 * @generated
	 */
	MessageDestinationLinkType createMessageDestinationLinkType();

	/**
	 * Returns a new object of class '<em>Message Destination Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Message Destination Ref Type</em>'.
	 * @generated
	 */
	MessageDestinationRefType createMessageDestinationRefType();

	/**
	 * Returns a new object of class '<em>Message Destination Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Message Destination Type</em>'.
	 * @generated
	 */
	MessageDestinationType createMessageDestinationType();

	/**
	 * Returns a new object of class '<em>Message Destination Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Message Destination Type Type</em>'.
	 * @generated
	 */
	MessageDestinationTypeType createMessageDestinationTypeType();

	/**
	 * Returns a new object of class '<em>Message Destination Usage Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Message Destination Usage Type</em>'.
	 * @generated
	 */
	MessageDestinationUsageType createMessageDestinationUsageType();

	/**
	 * Returns a new object of class '<em>Mime Mapping Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mime Mapping Type</em>'.
	 * @generated
	 */
	MimeMappingType createMimeMappingType();

	/**
	 * Returns a new object of class '<em>Mime Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mime Type Type</em>'.
	 * @generated
	 */
	MimeTypeType createMimeTypeType();

	/**
	 * Returns a new object of class '<em>Non Empty String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Non Empty String Type</em>'.
	 * @generated
	 */
	NonEmptyStringType createNonEmptyStringType();

	/**
	 * Returns a new object of class '<em>Param Value Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Param Value Type</em>'.
	 * @generated
	 */
	ParamValueType createParamValueType();

	/**
	 * Returns a new object of class '<em>Path Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Path Type</em>'.
	 * @generated
	 */
	PathType createPathType();

	/**
	 * Returns a new object of class '<em>Persistence Context Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Persistence Context Ref Type</em>'.
	 * @generated
	 */
	PersistenceContextRefType createPersistenceContextRefType();

	/**
	 * Returns a new object of class '<em>Persistence Context Type Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Persistence Context Type Type</em>'.
	 * @generated
	 */
	PersistenceContextTypeType createPersistenceContextTypeType();

	/**
	 * Returns a new object of class '<em>Persistence Unit Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Persistence Unit Ref Type</em>'.
	 * @generated
	 */
	PersistenceUnitRefType createPersistenceUnitRefType();

	/**
	 * Returns a new object of class '<em>Port Component Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Port Component Ref Type</em>'.
	 * @generated
	 */
	PortComponentRefType createPortComponentRefType();

	/**
	 * Returns a new object of class '<em>Property Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Type</em>'.
	 * @generated
	 */
	PropertyType createPropertyType();

	/**
	 * Returns a new object of class '<em>Remote Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Remote Type</em>'.
	 * @generated
	 */
	RemoteType createRemoteType();

	/**
	 * Returns a new object of class '<em>Res Auth Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Res Auth Type</em>'.
	 * @generated
	 */
	ResAuthType createResAuthType();

	/**
	 * Returns a new object of class '<em>Resource Env Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Resource Env Ref Type</em>'.
	 * @generated
	 */
	ResourceEnvRefType createResourceEnvRefType();

	/**
	 * Returns a new object of class '<em>Resource Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Resource Ref Type</em>'.
	 * @generated
	 */
	ResourceRefType createResourceRefType();

	/**
	 * Returns a new object of class '<em>Res Sharing Scope Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Res Sharing Scope Type</em>'.
	 * @generated
	 */
	ResSharingScopeType createResSharingScopeType();

	/**
	 * Returns a new object of class '<em>Role Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Role Name Type</em>'.
	 * @generated
	 */
	RoleNameType createRoleNameType();

	/**
	 * Returns a new object of class '<em>Run As Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Run As Type</em>'.
	 * @generated
	 */
	RunAsType createRunAsType();

	/**
	 * Returns a new object of class '<em>Security Constraint Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Security Constraint Type</em>'.
	 * @generated
	 */
	SecurityConstraintType createSecurityConstraintType();

	/**
	 * Returns a new object of class '<em>Security Role Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Security Role Ref Type</em>'.
	 * @generated
	 */
	SecurityRoleRefType createSecurityRoleRefType();

	/**
	 * Returns a new object of class '<em>Security Role Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Security Role Type</em>'.
	 * @generated
	 */
	SecurityRoleType createSecurityRoleType();

	/**
	 * Returns a new object of class '<em>Service Ref Handler Chains Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service Ref Handler Chains Type</em>'.
	 * @generated
	 */
	ServiceRefHandlerChainsType createServiceRefHandlerChainsType();

	/**
	 * Returns a new object of class '<em>Service Ref Handler Chain Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service Ref Handler Chain Type</em>'.
	 * @generated
	 */
	ServiceRefHandlerChainType createServiceRefHandlerChainType();

	/**
	 * Returns a new object of class '<em>Service Ref Handler Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service Ref Handler Type</em>'.
	 * @generated
	 */
	ServiceRefHandlerType createServiceRefHandlerType();

	/**
	 * Returns a new object of class '<em>Service Ref Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Service Ref Type</em>'.
	 * @generated
	 */
	ServiceRefType createServiceRefType();

	/**
	 * Returns a new object of class '<em>Servlet Mapping Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Servlet Mapping Type</em>'.
	 * @generated
	 */
	ServletMappingType createServletMappingType();

	/**
	 * Returns a new object of class '<em>Servlet Name Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Servlet Name Type</em>'.
	 * @generated
	 */
	ServletNameType createServletNameType();

	/**
	 * Returns a new object of class '<em>Servlet Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Servlet Type</em>'.
	 * @generated
	 */
	ServletType createServletType();

	/**
	 * Returns a new object of class '<em>Session Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Session Config Type</em>'.
	 * @generated
	 */
	SessionConfigType createSessionConfigType();

	/**
	 * Returns a new object of class '<em>String</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String</em>'.
	 * @generated
	 */
	String createString();

	/**
	 * Returns a new object of class '<em>Taglib Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Taglib Type</em>'.
	 * @generated
	 */
	TaglibType createTaglibType();

	/**
	 * Returns a new object of class '<em>Transport Guarantee Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transport Guarantee Type</em>'.
	 * @generated
	 */
	TransportGuaranteeType createTransportGuaranteeType();

	/**
	 * Returns a new object of class '<em>True False Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>True False Type</em>'.
	 * @generated
	 */
	TrueFalseType createTrueFalseType();

	/**
	 * Returns a new object of class '<em>Url Pattern Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Url Pattern Type</em>'.
	 * @generated
	 */
	UrlPatternType createUrlPatternType();

	/**
	 * Returns a new object of class '<em>User Data Constraint Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Data Constraint Type</em>'.
	 * @generated
	 */
	UserDataConstraintType createUserDataConstraintType();

	/**
	 * Returns a new object of class '<em>War Path Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>War Path Type</em>'.
	 * @generated
	 */
	WarPathType createWarPathType();

	/**
	 * Returns a new object of class '<em>Web App Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Web App Type</em>'.
	 * @generated
	 */
	WebAppType createWebAppType();

	/**
	 * Returns a new object of class '<em>Web Resource Collection Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Web Resource Collection Type</em>'.
	 * @generated
	 */
	WebResourceCollectionType createWebResourceCollectionType();

	/**
	 * Returns a new object of class '<em>Welcome File List Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Welcome File List Type</em>'.
	 * @generated
	 */
	WelcomeFileListType createWelcomeFileListType();

	/**
	 * Returns a new object of class '<em>Xsd Any URI Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd Any URI Type</em>'.
	 * @generated
	 */
	XsdAnyURIType createXsdAnyURIType();

	/**
	 * Returns a new object of class '<em>Xsd Boolean Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd Boolean Type</em>'.
	 * @generated
	 */
	XsdBooleanType createXsdBooleanType();

	/**
	 * Returns a new object of class '<em>Xsd Integer Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd Integer Type</em>'.
	 * @generated
	 */
	XsdIntegerType createXsdIntegerType();

	/**
	 * Returns a new object of class '<em>Xsd NMTOKEN Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd NMTOKEN Type</em>'.
	 * @generated
	 */
	XsdNMTOKENType createXsdNMTOKENType();

	/**
	 * Returns a new object of class '<em>Xsd Non Negative Integer Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd Non Negative Integer Type</em>'.
	 * @generated
	 */
	XsdNonNegativeIntegerType createXsdNonNegativeIntegerType();

	/**
	 * Returns a new object of class '<em>Xsd Positive Integer Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd Positive Integer Type</em>'.
	 * @generated
	 */
	XsdPositiveIntegerType createXsdPositiveIntegerType();

	/**
	 * Returns a new object of class '<em>Xsd QName Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd QName Type</em>'.
	 * @generated
	 */
	XsdQNameType createXsdQNameType();

	/**
	 * Returns a new object of class '<em>Xsd String Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Xsd String Type</em>'.
	 * @generated
	 */
	XsdStringType createXsdStringType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	Webapp25Package getWebapp25Package();

} //Webapp25Factory
