/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import prefuse.render.Renderer;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public abstract class AbstractShapeRenderer
implements Renderer {
    public static final int RENDER_TYPE_NONE = 0;
    public static final int RENDER_TYPE_DRAW = 1;
    public static final int RENDER_TYPE_FILL = 2;
    public static final int RENDER_TYPE_DRAW_AND_FILL = 3;
    private int m_renderType = 3;
    protected AffineTransform m_transform = new AffineTransform();
    protected boolean m_manageBounds = true;

    public void setManageBounds(boolean b) {
        this.m_manageBounds = b;
    }

    public void render(Graphics2D g, VisualItem item) {
        Shape shape = this.getShape(item);
        if (shape != null) {
            this.drawShape(g, item, shape);
        }
    }

    protected void drawShape(Graphics2D g, VisualItem item, Shape shape) {
        GraphicsLib.paint(g, item, shape, this.getStroke(item), this.getRenderType(item));
    }

    public Shape getShape(VisualItem item) {
        AffineTransform at = this.getTransform(item);
        Shape rawShape = this.getRawShape(item);
        return at == null || rawShape == null ? rawShape : at.createTransformedShape(rawShape);
    }

    protected BasicStroke getStroke(VisualItem item) {
        return item.getStroke();
    }

    protected abstract Shape getRawShape(VisualItem var1);

    protected AffineTransform getTransform(VisualItem item) {
        return null;
    }

    public int getRenderType(VisualItem item) {
        return this.m_renderType;
    }

    public void setRenderType(int type) {
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Unrecognized render type.");
        }
        this.m_renderType = type;
    }

    public boolean locatePoint(Point2D p, VisualItem item) {
        if (item.getBounds().contains(p)) {
            Shape s = this.getShape(item);
            return s != null ? s.contains(p) : false;
        }
        return false;
    }

    public void setBounds(VisualItem item) {
        if (!this.m_manageBounds) {
            return;
        }
        Shape shape = this.getShape(item);
        if (shape == null) {
            item.setBounds(item.getX(), item.getY(), 0.0, 0.0);
        } else {
            GraphicsLib.setBounds(item, shape, this.getStroke(item));
        }
    }
}

