/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanFilter
extends Filter
implements Iterable<FilterClause> {
    private final List<FilterClause> clauses = new ArrayList<FilterClause>();

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSetIterator disi;
        DocIdSet res = null;
        for (FilterClause fc : this.clauses) {
            if (fc.getOccur() != BooleanClause.Occur.SHOULD || (disi = BooleanFilter.getDISI(fc.getFilter(), reader)) == null) continue;
            if (res == null) {
                res = new FixedBitSet(reader.maxDoc());
            }
            res.or(disi);
        }
        for (FilterClause fc : this.clauses) {
            if (fc.getOccur() != BooleanClause.Occur.MUST_NOT) continue;
            if (res == null) {
                res = new FixedBitSet(reader.maxDoc());
                res.set(0, reader.maxDoc());
            }
            if ((disi = BooleanFilter.getDISI(fc.getFilter(), reader)) == null) continue;
            res.andNot(disi);
        }
        for (FilterClause fc : this.clauses) {
            if (fc.getOccur() != BooleanClause.Occur.MUST) continue;
            disi = BooleanFilter.getDISI(fc.getFilter(), reader);
            if (disi == null) {
                return DocIdSet.EMPTY_DOCIDSET;
            }
            if (res == null) {
                res = new FixedBitSet(reader.maxDoc());
                res.or(disi);
                continue;
            }
            res.and(disi);
        }
        return res != null ? res : DocIdSet.EMPTY_DOCIDSET;
    }

    private static DocIdSetIterator getDISI(Filter filter, IndexReader reader) throws IOException {
        DocIdSet set = filter.getDocIdSet(reader);
        return set == null || set == DocIdSet.EMPTY_DOCIDSET ? null : set.iterator();
    }

    public void add(FilterClause filterClause) {
        this.clauses.add(filterClause);
    }

    public final void add(Filter filter, BooleanClause.Occur occur) {
        this.add(new FilterClause(filter, occur));
    }

    public List<FilterClause> clauses() {
        return this.clauses;
    }

    @Override
    public final Iterator<FilterClause> iterator() {
        return this.clauses().iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BooleanFilter other = (BooleanFilter)obj;
        return ((Object)this.clauses).equals(other.clauses);
    }

    public int hashCode() {
        return 0x272B5EB6 ^ ((Object)this.clauses).hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("BooleanFilter(");
        int minLen = buffer.length();
        for (FilterClause c : this.clauses) {
            if (buffer.length() > minLen) {
                buffer.append(' ');
            }
            buffer.append(c);
        }
        return buffer.append(')').toString();
    }
}

