/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.internal.xtend.type.baseimpl.BuiltinMetaModel;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.internal.xtend.xtend.types.XtendMetaModel;
import org.eclipse.xtend.expression.TypeNameUtil;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSystemImpl
implements TypeSystem {
    private final Map<String, Map<List<String>, Type>> TYPE_CACHE = new HashMap<String, Map<List<String>, Type>>();
    protected BuiltinMetaModel builtin;
    protected final List<MetaModel> metaModels = new ArrayList<MetaModel>();
    private final Cache<Object, Type> typeCache = new Cache<Object, Type>(){

        @Override
        protected Type createNew(Object obj) {
            Type bestMatch = null;
            int i = 0;
            while (i < TypeSystemImpl.this.metaModels.size()) {
                MetaModel curMeta = TypeSystemImpl.this.metaModels.get(i);
                Type t = curMeta.getType(obj);
                if (t != null && (bestMatch == null || bestMatch.isAssignableFrom(t))) {
                    bestMatch = t;
                }
                ++i;
            }
            return bestMatch;
        }
    };

    public TypeSystemImpl() {
        this.setBuiltinMetamodel(new BuiltinMetaModel(this));
        this.registerMetaModel(new XtendMetaModel(this));
    }

    public void setBuiltinMetamodel(BuiltinMetaModel builtinMetaModel) {
        this.builtin = builtinMetaModel;
        this.registerMetaModel(this.builtin);
    }

    public final void registerMetaModel(MetaModel metaModel) {
        if (this.metaModels.contains(metaModel)) {
            return;
        }
        metaModel.setTypeSystem(this);
        this.metaModels.add(metaModel);
    }

    private Type[] toTypes(Object[] params) {
        Type[] types = new Type[params.length];
        int i = 0;
        while (i < types.length) {
            types[i] = this.getType(params[i]);
            ++i;
        }
        return types;
    }

    @Override
    public Operation findOperation(String name, Object target, Object[] params) {
        Type t = this.getType(target);
        Operation op = t.getOperation(name, this.toTypes(params));
        return op;
    }

    @Override
    public Property findProperty(String name, Object target) {
        Type t = this.getType(target);
        Property prop = t.getProperty(name);
        return prop;
    }

    @Override
    public Type getObjectType() {
        return this.builtin.getObjectType();
    }

    @Override
    public Type getVoidType() {
        return this.builtin.getVoidType();
    }

    @Override
    public Type getBooleanType() {
        return this.builtin.getBooleanType();
    }

    @Override
    public Type getIntegerType() {
        return this.builtin.getIntegerType();
    }

    @Override
    public Type getRealType() {
        return this.builtin.getRealType();
    }

    @Override
    public Type getStringType() {
        return this.builtin.getStringType();
    }

    @Override
    public Type getTypeType() {
        return this.builtin.getTypeType();
    }

    @Override
    public Type getCollectionType(Type innerType) {
        if (innerType == null) {
            innerType = this.getObjectType();
        }
        return this.builtin.getCollectionType(innerType);
    }

    @Override
    public Type getListType(Type innerType) {
        if (innerType == null) {
            innerType = this.getObjectType();
        }
        return this.builtin.getListType(innerType);
    }

    @Override
    public Type getSetType(Type innerType) {
        if (innerType == null) {
            innerType = this.getObjectType();
        }
        return this.builtin.getSetType(innerType);
    }

    @Override
    public Type getType(Object obj) {
        return this.typeCache.get(obj);
    }

    private Type internalGetTypeForName(String name) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        String typeName = TypeNameUtil.getTypeName(name);
        if (typeName == null || name.trim().equals("")) {
            return null;
        }
        String collectionTypeName = TypeNameUtil.getCollectionTypeName(name);
        ParameterizedType t = null;
        if (collectionTypeName != null && (t = (ParameterizedType)this.builtin.getTypeForName(collectionTypeName)) == null) {
            return null;
        }
        Type r = null;
        int i = 0;
        while (i < this.metaModels.size() && r == null) {
            MetaModel curMeta = this.metaModels.get(i);
            r = curMeta.getTypeForName(typeName);
            ++i;
        }
        if (r == null) {
            return null;
        }
        if (t == null) {
            return r;
        }
        return t.cloneWithInnerType(r);
    }

    @Override
    public Type getFeatureType() {
        return this.builtin.getFeatureType();
    }

    @Override
    public Type getPropertyType() {
        return this.builtin.getPropertyType();
    }

    @Override
    public Type getOperationType() {
        return this.builtin.getOperationType();
    }

    @Override
    public Type getTypeForName(String typeName) {
        if (typeName == null) {
            return null;
        }
        return this.getTypeForName(typeName, new String[0]);
    }

    public Type getTypeForName(String typeName, String[] importedNamespaces) {
        List<String> importedNamespacesList;
        Type type;
        if (typeName == null || "".equals(typeName.trim())) {
            return null;
        }
        Map<List<String>, Type> cacheMap = this.TYPE_CACHE.get(typeName);
        if (cacheMap == null) {
            cacheMap = new HashMap<List<String>, Type>();
            this.TYPE_CACHE.put(typeName, cacheMap);
        }
        if ((type = cacheMap.get(importedNamespacesList = Arrays.asList(importedNamespaces))) == null) {
            if (cacheMap.containsKey(importedNamespacesList)) {
                return null;
            }
            if (typeName.indexOf("::") >= 0) {
                type = this.internalGetTypeForName(typeName);
            } else {
                List<String> possibleNames = this.getPossibleNames(typeName, importedNamespaces);
                for (String name : possibleNames) {
                    type = this.internalGetTypeForName(name);
                    if (type != null) break;
                }
            }
            if (type != null) {
                cacheMap.put(importedNamespacesList, type);
            }
        }
        return type;
    }

    @Override
    public Type[] findTypesForPrefix(String prefix) {
        return this.findTypesForPrefix(prefix, new String[0]);
    }

    public Type[] findTypesForPrefix(String prefix, String[] importedNamespaces) {
        List<Object> possibleNames = null;
        if (prefix.indexOf("::") >= 0) {
            possibleNames = new ArrayList<String>();
            possibleNames.add(prefix);
        } else {
            possibleNames = this.getPossibleNames(prefix, importedNamespaces);
        }
        HashSet<Type> result = new HashSet<Type>();
        for (String string : possibleNames) {
            String typeName = TypeNameUtil.getTypeName(string);
            if (typeName == null) {
                return new Type[0];
            }
            String colTypeName = TypeNameUtil.getCollectionTypeName(string);
            ParameterizedType colType = null;
            if (colTypeName != null && (colType = (ParameterizedType)this.builtin.getTypeForName(colTypeName)) == null) {
                return new Type[0];
            }
            int i = 0;
            while (i < this.metaModels.size()) {
                MetaModel curMeta = this.metaModels.get(i);
                result.addAll(this.filterTypes(typeName, curMeta.getKnownTypes(), colType));
                ++i;
            }
        }
        return result.toArray(new Type[result.size()]);
    }

    @Override
    public Type[] getAllTypes() {
        ArrayList<? extends Type> result = new ArrayList<Type>();
        int i = 0;
        while (i < this.metaModels.size()) {
            MetaModel curMeta = this.metaModels.get(i);
            result.addAll(curMeta.getKnownTypes());
            ++i;
        }
        return result.toArray(new Type[result.size()]);
    }

    @Override
    public Set<String> getNamespaces() {
        HashSet<String> result = new HashSet<String>();
        for (MetaModel metaModel : this.metaModels) {
            result.addAll(metaModel.getNamespaces());
        }
        return result;
    }

    public List<String> getPossibleNames(String name, String[] importedNs) {
        String typeName = TypeNameUtil.getTypeName(name);
        String collectionTypeName = TypeNameUtil.getCollectionTypeName(name);
        ArrayList<String> result = new ArrayList<String>();
        result.add(name);
        String[] stringArray = importedNs;
        int n = importedNs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            StringBuffer s = new StringBuffer();
            if (collectionTypeName != null) {
                s.append(collectionTypeName).append("[");
            }
            s.append(string).append("::").append(typeName);
            if (collectionTypeName != null) {
                s.append("]");
            }
            result.add(s.toString());
            ++n2;
        }
        return result;
    }

    private Set<Type> filterTypes(String prefix, Set<? extends Type> knownTypes, ParameterizedType colType) {
        HashSet<Type> result = new HashSet<Type>();
        for (Type type : knownTypes) {
            if (!prefix.equals("") && !type.getName().startsWith(prefix)) continue;
            if (colType != null) {
                colType = (ParameterizedType)this.builtin.getTypeForName(colType.getName());
                colType = colType.cloneWithInnerType(type);
                result.add(colType);
                continue;
            }
            result.add(type);
        }
        return result;
    }

    @Override
    public Type getStaticPropertyType() {
        return this.builtin.getStaticPropertyType();
    }

    @Override
    public void release() {
        this.TYPE_CACHE.clear();
    }
}

