/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.FileHandleImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xpand2.output.VetoStrategy;

public class Outlet {
    private boolean append = false;
    private boolean overwrite = true;
    private String path = null;
    private String name = null;
    private String fileEncoding = System.getProperty("file.encoding");
    private boolean hasDefaultEncoding = true;
    public List<PostProcessor> postprocessors = new ArrayList<PostProcessor>();
    public List<VetoStrategy> vetoStartegies = new ArrayList<VetoStrategy>();
    private int filesCreated = 0;
    private int filesWrittenAndClosed = 0;

    public boolean hasDefaultEncoding() {
        return this.hasDefaultEncoding;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileHandleImpl createFileHandle(String filePath) {
        ++this.filesCreated;
        File f = new File(this.path, filePath);
        return new FileHandleImpl(this, f);
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
        this.hasDefaultEncoding = false;
    }

    public void addPostprocessor(PostProcessor b) {
        this.postprocessors.add(b);
    }

    public void addVetoStrategy(VetoStrategy b) {
        this.vetoStartegies.add(b);
    }

    public void beforeWriteAndClose(FileHandle impl) {
        ++this.filesWrittenAndClosed;
        for (PostProcessor b : this.postprocessors) {
            b.beforeWriteAndClose(impl);
        }
    }

    public void afterClose(FileHandle impl) {
        for (PostProcessor b : this.postprocessors) {
            b.afterClose(impl);
        }
    }

    public int getFilesCreated() {
        return this.filesCreated;
    }

    public int getFilesWrittenAndClosed() {
        return this.filesWrittenAndClosed;
    }

    public Outlet(String path) {
        this.path = path;
    }

    public Outlet() {
    }

    public boolean shouldWrite(FileHandleImpl fileHandleImpl) {
        for (VetoStrategy vs : this.vetoStartegies) {
            if (!vs.hasVeto(fileHandleImpl)) continue;
            return false;
        }
        return true;
    }
}

