/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.Set;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.StatementWithBody;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatement
extends StatementWithBody {
    private Expression fileNameExpression;
    private Identifier outletNameIdentifier;

    public FileStatement(Expression fileName, Statement[] body, Identifier mode) {
        super(body);
        this.fileNameExpression = fileName;
        this.outletNameIdentifier = mode;
    }

    public Expression getTargetFileName() {
        return this.fileNameExpression;
    }

    public Identifier getMode() {
        return this.outletNameIdentifier;
    }

    public String getOutletName() {
        if (this.outletNameIdentifier == null) {
            return null;
        }
        return this.outletNameIdentifier.getValue();
    }

    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type result = this.getTargetFileName().analyze((ExecutionContext)ctx, issues);
        if (!ctx.getStringType().isAssignableFrom(result)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "String expected!", (SyntaxElement)this.getTargetFileName()));
        }
        int i = 0;
        while (i < this.body.length) {
            this.body[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        Object result = this.getTargetFileName().evaluate((ExecutionContext)ctx);
        if (result == null) {
            throw new EvaluationException("Nullevaluation", (SyntaxElement)this.getTargetFileName(), (ExecutionContext)ctx);
        }
        String fileName = result.toString();
        String outletName = this.getOutletName();
        ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("FILENAME", (Object)fileName));
        ctx.getOutput().openFile(fileName, outletName);
        int i = 0;
        while (i < this.body.length) {
            this.body[i].evaluate(ctx);
            ++i;
        }
        ctx.getOutput().closeFile();
    }

    public String getNameString(ExecutionContext context) {
        return "FILE";
    }
}

