/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.xpath;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jet.xpath.XPathFunctionResolver;

public class DefaultXPathFunctionResolver
implements XPathFunctionResolver {
    private final Map functionMap = new HashMap();
    private final XPathFunctionResolver delegateResolver;

    public DefaultXPathFunctionResolver() {
        this.delegateResolver = null;
    }

    public DefaultXPathFunctionResolver(XPathFunctionResolver delegateResolver) {
        this.delegateResolver = delegateResolver;
    }

    public XPathFunction resolveFunction(String functionName, int arity) {
        XPathFunctionMetaData data;
        XPathFunction result = null;
        if (this.delegateResolver != null) {
            result = this.delegateResolver.resolveFunction(functionName, arity);
        }
        if (result == null && (data = (XPathFunctionMetaData)this.functionMap.get(functionName)) != null && data.getMinArgs() <= arity && (arity <= data.getMaxArgs() || data.getMaxArgs() == -1)) {
            result = data.getFunction();
        }
        return result;
    }

    public void addFunction(XPathFunctionMetaData functionData) {
        this.functionMap.put(functionData.getName(), functionData);
    }
}

