/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.editor.extxpt.ExtXptFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProposalCreator {
    private EditingDomain domain;
    private final ExtXptFacade facade;

    public ProposalCreator(EditingDomain domain, ExtXptFacade facade) {
        this.domain = domain;
        this.facade = facade;
    }

    public List<?> proposals(EObject source, EStructuralFeature feature) {
        List<Object> retVal = null;
        if (feature instanceof EReference) {
            retVal = this.findAllInstances(feature.getEType());
        } else if (feature.getEType() instanceof EEnumImpl) {
            EEnum eEnum = (EEnum)feature.getEType();
            ArrayList<Object> enumerators = new ArrayList<Object>();
            Iterator iter = eEnum.getELiterals().iterator();
            while (iter.hasNext()) {
                Enumerator instance = ((EEnumLiteral)iter.next()).getInstance();
                enumerators.add(instance);
            }
            retVal = enumerators;
        }
        return this.facade.proposals(feature, source, retVal);
    }

    private List<Object> findAllInstances(EClassifier type) {
        ArrayList<Object> objects = new ArrayList<Object>();
        TreeIterator allContents = EcoreUtil.getAllContents((Collection)this.domain.getResourceSet().getResources(), (boolean)true);
        while (allContents.hasNext()) {
            Object o = allContents.next();
            if (!type.isInstance(o)) continue;
            objects.add(o);
        }
        TreeIterator iter = EcoreUtil.getAllContents((EObject)EcoreUtil.getRootContainer((EObject)EcorePackage.eINSTANCE, (boolean)true), (boolean)false);
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!type.isInstance(next) || objects.contains(next)) continue;
            objects.add(next);
        }
        return objects;
    }
}

