/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile.example;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.acceleo.ide.ui.wizards.newfile.example.IAcceleoExampleStrategy;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.core.resources.IFile;

public abstract class AbstractM2TContentStrategy
implements IAcceleoExampleStrategy {
    protected static final String VAR_ALL = "*";
    protected static final String VAR = "$";
    protected static final String END_LINE = "\\n";

    public boolean forceMetamodelURI() {
        return true;
    }

    public String getContent(IFile exampleFile, String moduleName, boolean templateHasFileBlock, boolean templateIsMain, String metamodelURI, String metamodelFileType) {
        StringBuffer buffer = new StringBuffer("");
        if (exampleFile != null && exampleFile.exists()) {
            StringBuffer text = this.readExampleContent(exampleFile);
            this.modifyM2TContent(text, moduleName, templateIsMain);
            buffer.append(text);
        }
        return buffer.toString();
    }

    protected StringBuffer readExampleContent(IFile exampleFile) {
        StringBuffer text = FileContent.getFileContent((File)exampleFile.getLocation().toFile());
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        text = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '[') {
                text.append("['['/]");
            } else if (c == ']') {
                text.append("[']'/]");
            } else {
                text.append(c);
            }
            ++i;
        }
        return text;
    }

    protected abstract void modifyM2TContent(StringBuffer var1, String var2, boolean var3);

    protected void replaceAll(StringBuffer text, String initialString, String replacingString) {
        int offset = 0;
        while (offset > -1) {
            offset = this.replaceNext(text, initialString, offset, replacingString);
        }
    }

    protected int replaceNext(StringBuffer text, String initialString, int offset, String replacingString) {
        if (offset == -1) {
            return -1;
        }
        int result = -1;
        String stringToSearch = initialString;
        int replaceStart = -1;
        int replaceEnd = -1;
        int globalSearch = offset;
        boolean endsWithNewLine = stringToSearch.endsWith(END_LINE);
        if (endsWithNewLine) {
            stringToSearch = stringToSearch.substring(0, stringToSearch.length() - END_LINE.length());
        }
        String[] initialStrings = this.tokenize(stringToSearch, "*$", true, true);
        boolean jumpIdentifierOnly = false;
        while (result == -1 && globalSearch > -1 && globalSearch < text.length()) {
            int e = globalSearch;
            ArrayList<String> vars = new ArrayList<String>();
            int i = 0;
            while (i < initialStrings.length && e < text.length()) {
                if (VAR_ALL.equals(initialStrings[i])) {
                    jumpIdentifierOnly = false;
                } else if (VAR.equals(initialStrings[i])) {
                    jumpIdentifierOnly = true;
                } else {
                    int[] pos = this.indexOf(text, this.tokenize(initialStrings[i], " \t\r\n", false, false), e, endsWithNewLine, jumpIdentifierOnly);
                    if (pos != null) {
                        int b = pos[0];
                        if (replaceStart == -1) {
                            replaceStart = b;
                        }
                        if (e > globalSearch) {
                            vars.add(text.substring(e, b));
                        }
                        e = pos[1];
                        if (i + 1 < initialStrings.length) {
                            while (e < text.length() && Character.isWhitespace(text.charAt(e))) {
                                ++e;
                            }
                        } else {
                            replaceEnd = e;
                        }
                    } else {
                        globalSearch = replaceStart > -1 ? replaceStart + 1 : -1;
                        replaceStart = -1;
                        replaceEnd = -1;
                        vars.clear();
                        break;
                    }
                }
                ++i;
            }
            if (replaceStart <= -1 || replaceEnd <= -1) continue;
            String newString = replacingString;
            int i2 = 1;
            for (String var : vars) {
                newString = newString.replace(VAR + i2, var);
                ++i2;
            }
            text.replace(replaceStart, replaceEnd, newString);
            result = replaceStart + newString.length();
        }
        return result;
    }

    private String[] tokenize(String str, String delim, boolean trim, boolean returnDelims) {
        StringTokenizer st = new StringTokenizer(str, delim, returnDelims);
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = trim ? st.nextToken().trim() : st.nextToken();
            ++i;
        }
        return result;
    }

    private int[] indexOf(StringBuffer text, String[] sequence, int offset, boolean endsWithNewLine, boolean jumpIdentifierOnly) {
        if (offset > -1 && sequence.length > 0) {
            int searchStart = -1;
            int searchEnd = -1;
            int globalSearch = offset;
            while (globalSearch > -1 && globalSearch < text.length()) {
                int e = globalSearch;
                int i = 0;
                while (i < sequence.length && e < text.length()) {
                    String token = sequence[i];
                    if (searchStart != -1 && endsWithNewLine && text.charAt(e) == '\n') {
                        globalSearch = e + 1;
                        searchStart = -1;
                        searchEnd = -1;
                        break;
                    }
                    if (token.length() > 0 && e + token.length() <= text.length() && token.equals(text.substring(e, e + token.length()))) {
                        int b = e;
                        if (searchStart == -1) {
                            searchStart = b;
                        }
                        e = b + token.length();
                        if (i + 1 < sequence.length) {
                            while (e < text.length() && Character.isWhitespace(text.charAt(e)) && (!endsWithNewLine || text.charAt(e) != '\n')) {
                                ++e;
                            }
                        } else {
                            searchEnd = e;
                        }
                    } else {
                        globalSearch = searchStart > -1 && "\"".equals(sequence[0]) ? -1 : (searchStart > -1 ? searchStart + 1 : (jumpIdentifierOnly && !Character.isJavaIdentifierPart(text.charAt(e)) && text.charAt(e) != '.' ? -1 : ++globalSearch));
                        searchStart = -1;
                        searchEnd = -1;
                        break;
                    }
                    ++i;
                }
                if (searchStart <= -1 || searchEnd <= -1) continue;
                return new int[]{searchStart, searchEnd};
            }
        }
        return null;
    }
}

