/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jet.runtime.model.IModelLoader;

public class ResourceLoader
implements IModelLoader {
    public boolean canLoad(String kind) {
        return true;
    }

    public Object load(URL modelUrl) throws IOException {
        if (!"platform".equals(modelUrl.getProtocol()) || !modelUrl.getPath().startsWith("/resource/")) {
            throw new IOException("Resource loader requires platform:/resource/ URL format");
        }
        Path path = new Path(modelUrl.getPath());
        path = path.removeFirstSegments(1);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (resource == null) {
            throw new FileNotFoundException(path.toString());
        }
        return resource;
    }

    public Object load(URL modelUrl, String kind) throws IOException {
        return this.load(modelUrl);
    }

    public Object loadFromString(String serializedModel, String kind) throws IOException {
        throw new UnsupportedOperationException();
    }
}

