/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser.jasper;

import java.util.Stack;
import org.eclipse.jet.internal.core.parser.LineInfo;
import org.eclipse.jet.internal.core.parser.jasper.JETReader;
import org.eclipse.jet.internal.core.parser.jasper.MessagesUtil;

public final class JETMark {
    protected int cursor;
    protected int fileid;
    protected String baseDir;
    protected char[] stream = null;
    protected LineInfo[] lineInfo = null;
    protected Stack includeStack = null;
    protected JETReader reader;

    JETMark(JETReader reader, char[] inStream, int fileid, String inBaseDir) {
        this.reader = reader;
        this.stream = inStream;
        this.cursor = 0;
        this.lineInfo = LineInfo.calculateLines(inStream);
        this.fileid = fileid;
        this.baseDir = inBaseDir;
        this.includeStack = new Stack();
    }

    JETMark(JETMark other) {
        this.reader = other.reader;
        this.stream = other.stream;
        this.fileid = other.fileid;
        this.cursor = other.cursor;
        this.lineInfo = other.lineInfo;
        this.baseDir = other.baseDir;
        this.includeStack = new Stack();
        int i = 0;
        while (i < other.includeStack.size()) {
            this.includeStack.addElement(other.includeStack.elementAt(i));
            ++i;
        }
    }

    public void pushStream(char[] inStream, int inFileid, String inBaseDir) {
        this.includeStack.push(new IncludeState(this.cursor, this.lineInfo, this.fileid, this.baseDir, this.stream));
        this.cursor = 0;
        this.fileid = inFileid;
        this.baseDir = inBaseDir;
        this.stream = inStream;
        this.lineInfo = LineInfo.calculateLines(inStream);
    }

    public boolean popStream() {
        if (this.includeStack.size() <= 0) {
            return false;
        }
        IncludeState state = (IncludeState)this.includeStack.pop();
        this.cursor = state.cursor;
        this.lineInfo = state.lineInfo;
        this.fileid = state.fileid;
        this.baseDir = state.baseDir;
        this.stream = state.stream;
        return true;
    }

    public String getFile() {
        return this.reader.getFile(this.fileid);
    }

    public String getBaseURI() {
        return this.reader.getBaseURI(this.fileid);
    }

    public String getLocalFile() {
        String file = this.reader.getFile(this.fileid);
        if (file.startsWith("platform:/resource/")) {
            file = file.substring("platform:/resource".length());
        } else {
            file.startsWith("file:/");
        }
        return file;
    }

    public int getFileId() {
        return this.fileid;
    }

    public int getCursor() {
        return this.cursor;
    }

    public String toShortString() {
        return "(" + this.getLine() + "," + this.getCol() + ")";
    }

    public String toString() {
        return String.valueOf(this.getLocalFile()) + "(" + this.getLine() + "," + this.getCol() + ")";
    }

    public String format(String key) {
        return MessagesUtil.getString(key, new Object[]{this.getLocalFile(), new Integer(this.getLine() + 1), new Integer(this.getCol() + 1), new Integer(this.cursor)});
    }

    public boolean equals(Object other) {
        if (other instanceof JETMark) {
            JETMark m = (JETMark)other;
            return this.reader == m.reader && this.fileid == m.fileid && this.cursor == m.cursor && this.getLine() == m.getLine() && this.getCol() == m.getCol();
        }
        return false;
    }

    public int getLine() {
        return LineInfo.getLineNo(this.lineInfo, this.cursor);
    }

    public int getCol() {
        int lineIndex = this.getLine() - 1;
        if (lineIndex < this.lineInfo.length) {
            return this.cursor - this.lineInfo[lineIndex].getStart() + 1;
        }
        return this.cursor - (this.lineInfo[this.lineInfo.length - 1].getEnd() + this.lineInfo[this.lineInfo.length - 1].getDelimiter().length()) + 1;
    }

    class IncludeState {
        int cursor;
        int fileid;
        String baseDir;
        String encoding;
        char[] stream = null;
        private final LineInfo[] lineInfo;

        IncludeState(int inCursor, LineInfo[] inLineInfo, int inFileid, String inBaseDir, char[] inStream) {
            this.cursor = inCursor;
            this.lineInfo = inLineInfo;
            this.fileid = inFileid;
            this.baseDir = inBaseDir;
            this.stream = inStream;
        }
    }
}

