/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.BodyElements;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;

public final class IncludedContent
extends BodyElement {
    private final URI baseLocationURI;
    private BodyElements bodyElements = null;
    private final String templatePath;

    IncludedContent(JETAST ast, String templatePath, URI baseLocationURI, int line, int column, int start, int end) {
        super(ast, line, column, start, end);
        this.templatePath = templatePath;
        this.baseLocationURI = baseLocationURI;
    }

    protected final void accept0(JETASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            Iterator i = this.getBodyElements().iterator();
            while (i.hasNext()) {
                JETASTElement element = (JETASTElement)i.next();
                element.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public URI getBaseLocationURI() {
        return this.baseLocationURI;
    }

    public final List getBodyElements() {
        if (this.bodyElements == null) {
            return Collections.EMPTY_LIST;
        }
        return this.bodyElements.getBodyElements();
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public boolean removeLineWhenOtherwiseEmpty() {
        return false;
    }

    public void addBodyElement(BodyElement bodyElement) {
        this.getInternalBodyElements().addBodyElement(bodyElement);
    }

    public BodyElement elementAfter(JETASTElement element) {
        return this.bodyElements.elementAfter(element);
    }

    public BodyElement elementBefore(JETASTElement element) {
        return this.bodyElements.elementBefore(element);
    }

    BodyElements getInternalBodyElements() {
        if (this.bodyElements == null) {
            this.bodyElements = new BodyElements(this);
        }
        return this.bodyElements;
    }

    public JETASTElement getNextElement() {
        if (this.getBodyElements().size() > 0) {
            return (JETASTElement)this.getBodyElements().get(0);
        }
        return super.getNextElement();
    }
}

