/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.core.parser.AbstractTemplateResolver;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ITemplateResolverHelper;
import org.eclipse.jet.core.parser.ITemplateResolverHelperFactory;
import org.eclipse.jet.internal.core.parser.DefaultTemplateResolverHelper;

public final class DefaultTemplateResolver
extends AbstractTemplateResolver
implements ITemplateResolver {
    private static final String SLASH = "/";
    private static final ITemplateResolverHelperFactory defaultFactory = new ITemplateResolverHelperFactory(){

        public ITemplateResolverHelper getTemplateResolverHelper(URI baseLocation) {
            return new DefaultTemplateResolverHelper(baseLocation);
        }
    };
    private final Map delegateByURI = new HashMap();

    private DefaultTemplateResolver(Builder builder) {
        super(builder.baseLocations);
        URI[] uris = this.getBaseLocations();
        int i = 0;
        while (i < uris.length) {
            URI baseLocation = uris[i];
            ITemplateResolverHelper helper = this.getTemplateResolverHelper(builder.helper, baseLocation);
            this.delegateByURI.put(baseLocation, helper);
            ++i;
        }
    }

    private ITemplateResolverHelper getTemplateResolverHelper(ITemplateResolverHelperFactory helperFactory, URI baseLocation) {
        ITemplateResolverHelper helper;
        ITemplateResolverHelper iTemplateResolverHelper = helper = helperFactory == null ? null : helperFactory.getTemplateResolverHelper(baseLocation);
        if (helper == null) {
            helper = defaultFactory.getTemplateResolverHelper(baseLocation);
        }
        return helper;
    }

    protected ITemplateInput createTemplateInput(URI baseLocation, String templatePath) {
        ITemplateResolverHelper helper = (ITemplateResolverHelper)this.delegateByURI.get(baseLocation);
        return helper.createTemplateInput(templatePath);
    }

    protected boolean inputExists(URI baseLocation, String templatePath) {
        ITemplateResolverHelper helper = (ITemplateResolverHelper)this.delegateByURI.get(baseLocation);
        return helper.inputExists(templatePath);
    }

    /* synthetic */ DefaultTemplateResolver(Builder builder, DefaultTemplateResolver defaultTemplateResolver) {
        this(builder);
    }

    public static final class Builder {
        private final URI[] baseLocations;
        private ITemplateResolverHelperFactory helper;

        public Builder(URI[] baseLocations) {
            if (baseLocations == null) {
                throw new NullPointerException();
            }
            int i = 0;
            while (i < baseLocations.length) {
                if (baseLocations[i] == null) {
                    throw new NullPointerException();
                }
                if (!baseLocations[i].getPath().endsWith(DefaultTemplateResolver.SLASH)) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            this.baseLocations = baseLocations;
        }

        public Builder(URI baseLocation) {
            this(new URI[]{baseLocation});
        }

        public Builder templateResolverHelperFactory(ITemplateResolverHelperFactory helper) {
            this.helper = helper;
            return this;
        }

        public ITemplateResolver build() {
            return new DefaultTemplateResolver(this, null);
        }
    }
}

