/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jet.ContextLogEntry;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagFactory;
import org.eclipse.jet.taglib.TagInfo;

public final class JET2Context {
    private Object source;
    private final List logEntries = new ArrayList();
    private final Set logListeners = new LinkedHashSet();
    private final Map extendedContextData = new HashMap();
    private TagFactory tagFactory = null;
    private final Map globalVariables = new HashMap();
    private String templatePath = "";
    private String jetBundleId;
    private static final Pattern validVariableNamePattern = Pattern.compile("(?:_|\\p{L})(?:_|-|\\.|\\p{L}|\\d)*");

    public JET2Context(Object source, Map variables) {
        this.source = source;
        this.globalVariables.putAll(variables);
    }

    public JET2Context(Object source) {
        this(source, Collections.EMPTY_MAP);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    private void log(int severity, String templatePath, TagInfo tagInfo, String message, Throwable throwable) {
        ContextLogEntry.Builder builder = new ContextLogEntry.Builder(severity);
        if (templatePath != null) {
            builder.templatePath(templatePath);
        }
        if (tagInfo != null) {
            builder.tagInfo(tagInfo);
        }
        if (message != null) {
            builder.message(message);
        }
        if (throwable != null) {
            builder.exception(throwable);
        }
        ContextLogEntry logEntry = builder.build();
        this.logEntries.add(logEntry);
        Iterator i = this.logListeners.iterator();
        while (i.hasNext()) {
            LogListener listener = (LogListener)i.next();
            listener.log(logEntry);
        }
    }

    public void addLogListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.logListeners.remove(listener);
    }

    public String getJETBundleId() {
        return this.jetBundleId;
    }

    public void setJETBundleId(String jetBundleId) {
        this.jetBundleId = jetBundleId;
    }

    public void logInfo(String message) {
        this.log(1, this.getTemplatePath(), null, message, null);
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void logWarning(String message) {
        this.log(2, this.getTemplatePath(), null, message, null);
    }

    public void logError(String message) {
        this.log(4, this.getTemplatePath(), null, message, null);
    }

    public void logError(Throwable e) {
        this.log(4, this.getTemplatePath(), null, null, e);
    }

    public void logError(String message, Throwable e) {
        this.log(4, this.getTemplatePath(), null, message, e);
    }

    public ContextLogEntry getLogEntries() {
        ContextLogEntry[] entries = this.logEntries.toArray(new ContextLogEntry[0]);
        ContextLogEntry.Builder builder = new ContextLogEntry.Builder(entries);
        switch (builder.getSeverity()) {
            case 0: {
                builder.message(JET2Messages.JET2Context_SuccessfulExecution);
                break;
            }
            case 1: {
                builder.message(JET2Messages.JET2Context_SuccessfulWithMessages);
                break;
            }
            case 2: {
                builder.message(JET2Messages.JET2Context_SuccessfulWithWarnings);
                break;
            }
            case 4: {
                builder.message(JET2Messages.JET2Context_ErrorsInExecution);
                break;
            }
            case 8: {
                builder.message(JET2Messages.JET2Context_ExecutionCancelled);
            }
        }
        return builder.build();
    }

    public void logError(TagInfo tagInfo, String message, Throwable exception) {
        this.log(4, this.getTemplatePath(), tagInfo, message, exception);
    }

    private String getContextExtenderId(Class clazz) {
        return clazz.getName();
    }

    public boolean hasContextExtender(Class extenderClass) {
        return this.extendedContextData.containsKey(this.getContextExtenderId(extenderClass));
    }

    void registerContextExtender(Class extenderClass, Object extenderData) {
        String extenderId = this.getContextExtenderId(extenderClass);
        if (this.extendedContextData.containsKey(extenderClass)) {
            throw new IllegalStateException(String.valueOf(extenderId) + "already registered");
        }
        this.extendedContextData.put(extenderId, extenderData);
    }

    Object getContextExtenderData(Class extenderClass) {
        return this.extendedContextData.get(this.getContextExtenderId(extenderClass));
    }

    public void logError(String templatePath, TagInfo tagInfo, String message, Throwable e) {
        this.log(4, templatePath, tagInfo, message, e);
    }

    public void setVariable(String var, Object value) throws JET2TagException {
        if (!validVariableNamePattern.matcher(var).matches()) {
            throw new JET2TagException(MessageFormat.format(JET2Messages.JET2Context_InvalidVariableName, var));
        }
        this.globalVariables.put(var, value);
    }

    public Object getVariable(String var) throws JET2TagException {
        if (!this.hasVariable(var)) {
            String msg = JET2Messages.JET2Context_VariableNotFound;
            throw new JET2TagException(MessageFormat.format(msg, var));
        }
        return this.globalVariables.get(var);
    }

    public Map getVariables() {
        return new HashMap(this.globalVariables);
    }

    public void removeVariable(String var) throws JET2TagException {
        this.globalVariables.remove(var);
    }

    public boolean hasVariable(String var) {
        return this.globalVariables.containsKey(var);
    }

    public final TagFactory getTagFactory() {
        return this.tagFactory;
    }

    public final void setTagFactory(TagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public Map extractVariables(String variableNames) throws JET2TagException {
        HashMap<String, Object> savedVariableValues = null;
        if (variableNames != null) {
            savedVariableValues = new HashMap<String, Object>();
            StringTokenizer tokenizer = new StringTokenizer(variableNames, ",");
            while (tokenizer.hasMoreTokens()) {
                String varName = tokenizer.nextToken();
                varName = varName.trim();
                savedVariableValues.put(varName, this.getVariable(varName));
            }
        }
        return savedVariableValues;
    }

    public void restoreVariables(Map savedVariableValues) throws JET2TagException {
        if (savedVariableValues != null) {
            Iterator i = savedVariableValues.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void setVariables(Map variablesToPass) throws JET2TagException {
        this.globalVariables.clear();
        Iterator i = variablesToPass.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String varName = (String)entry.getKey();
            this.setVariable(varName, entry.getValue());
        }
    }

    public static interface LogListener {
        public void log(ContextLogEntry var1);
    }
}

