/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.ui.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleFeatureControl
extends Composite {
    private FeatureEditorDialog dialog;
    private Collection<?> currentValue;
    private final ILabelProvider labelProvider;
    private ISelectionProvider inernalProvider = new InternalSelectionProvider();
    private Label label;
    private Button button;
    private boolean beQueit;

    public MultipleFeatureControl(final Composite parent, FormToolkit toolkit, final ILabelProvider labelProvider, final Object object, final EStructuralFeature feature, final List<? extends Object> choiceOfValues) {
        super(parent, 0);
        this.labelProvider = labelProvider;
        toolkit.adapt((Composite)this);
        this.setLayout((Layout)new GridLayout(2, false));
        this.label = toolkit.createLabel((Composite)this, new String());
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MultipleFeatureControl.this.setFocus();
            }
        });
        this.label.setLayoutData((Object)new GridData(768));
        this.button = toolkit.createButton((Composite)this, "...", 8);
        this.button.setLayoutData((Object)new GridData());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List oldValue = MultipleFeatureControl.this.unwrapSelection();
                MultipleFeatureControl.this.dialog = new FeatureEditorDialog(parent.getShell(), labelProvider, object, feature.getEType(), oldValue, "Display Name", choiceOfValues, false, feature.isOrdered());
                MultipleFeatureControl.this.dialog.setBlockOnOpen(true);
                if (MultipleFeatureControl.this.dialog.open() == 0) {
                    MultipleFeatureControl.this.setSelection((ISelection)new StructuredSelection(MultipleFeatureControl.this.dialog.getResult().toArray()));
                }
            }
        });
    }

    protected void setSelection(ISelection structuredSelection) {
        this.inernalProvider.setSelection(structuredSelection);
    }

    private List<?> unwrapSelection() {
        ArrayList l = new ArrayList();
        if (this.getSelection() != null && !this.getSelection().isEmpty() && this.getSelection() instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)this.getSelection()) {
                l.add(object);
            }
        }
        return l;
    }

    private ISelection getSelection() {
        return this.inernalProvider.getSelection();
    }

    public void setMenu(Menu menu) {
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setMenu(menu);
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setMenu(menu);
        }
    }

    public boolean setFocus() {
        if (this.button != null) {
            return this.button.setFocus();
        }
        return super.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.button.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.button.removeFocusListener(listener);
    }

    private void recalculateLabelText() {
        StringBuffer buffy = new StringBuffer();
        List<?> currSelection = this.unwrapSelection();
        if (currSelection != null && !currSelection.isEmpty()) {
            Iterator<?> iterator = currSelection.iterator();
            while (iterator.hasNext()) {
                Object sel = iterator.next();
                buffy.append(this.labelProvider.getText(sel));
                if (!iterator.hasNext()) continue;
                buffy.append(", ");
            }
        }
        this.label.setText(buffy.toString());
    }

    public Collection<?> getCurrentValue() {
        return this.currentValue;
    }

    public ISelectionProvider getInternalSelectionProvider() {
        return this.inernalProvider;
    }

    public void quietClearSelection() {
        this.beQueit = true;
        try {
            this.setSelection((ISelection)new StructuredSelection());
        }
        finally {
            this.beQueit = false;
        }
    }

    class InternalSelectionProvider
    implements ISelectionProvider {
        private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        private ISelection selection;

        InternalSelectionProvider() {
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
            MultipleFeatureControl.this.recalculateLabelText();
            if (!MultipleFeatureControl.this.beQueit) {
                for (ISelectionChangedListener currListener : this.listeners) {
                    currListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.selection));
                }
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }
    }
}

