/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.debug;

import java.util.Set;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.ISyntaxElement;
import org.eclipse.internal.xtend.expression.debug.BaseSpecialTreatment;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExpressionFacade;
import org.eclipse.xtend.expression.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionModelPresentation {
    protected Set<BaseSpecialTreatment> specials;

    public ExpressionModelPresentation(Set<BaseSpecialTreatment> specials) {
        this.specials = specials;
    }

    public SyntaxElement getStartPresentation(ISyntaxElement se, ExecutionContext context) {
        SyntaxElement to = new SyntaxElement();
        to.containerName = this.getContainerName(se);
        to.elementName = se.getNameString(context);
        to.resource = this.getResource(se);
        to.start = this.getStart(se);
        to.end = se.getEnd();
        to.line = se.getLine();
        return to;
    }

    public SyntaxElement getEndPresentation(ISyntaxElement se, ExecutionContext context) {
        return this.getStartPresentation(se, context);
    }

    public String getVariableSimpleRep(Object element, ExecutionContext context) {
        if (element == null) {
            return "null";
        }
        if (element instanceof String) {
            return (String)element;
        }
        return (String)new ExpressionFacade(context.cloneWithVariable(new Variable("this", element))).evaluate("metaType.name");
    }

    public int getStart(ISyntaxElement se) {
        if (se instanceof FeatureCall) {
            return ((FeatureCall)se).getName().getStart();
        }
        return se.getStart();
    }

    public int getStartingEndPosition(ISyntaxElement se) {
        return se.getEnd();
    }

    protected String getContainerName(ISyntaxElement se) {
        return this.getTemplateName(se);
    }

    protected String getTemplateName(ISyntaxElement se) {
        String fileName = se.getFileName();
        if (fileName == null) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf(47) + 1, fileName.length() - 4);
    }

    protected String getResource(ISyntaxElement se) {
        if (se.getFileName() == null) {
            return "";
        }
        return se.getFileName();
    }

    public String getStringRep(Object element) {
        if (element == null) {
            return "null";
        }
        return element.toString();
    }
}

