/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jet.CoreJETException;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.model.ModelLoaderDescription;
import org.eclipse.jet.runtime.model.ILoaderFactory;
import org.eclipse.jet.runtime.model.ILoaderManager;
import org.eclipse.jet.runtime.model.IModelLoader;
import org.eclipse.jet.runtime.model.IModelLoaderDescription;

public class LoaderManager
implements ILoaderManager {
    private final Map loaders = new HashMap();
    private final Map defaultLoaders = new HashMap();
    private final Map modelLoadersByType = new HashMap();

    public void addLoader(String id, String name, ILoaderFactory factory, boolean dynamic) {
        this.loaders.put(id, new LoaderData(name, factory, dynamic));
    }

    public void removeLoader(String id) {
        this.loaders.remove(id);
    }

    public IModelLoader getModelLoader(String id) {
        LoaderData data = (LoaderData)this.loaders.get(id);
        return data != null ? data.getLoader() : null;
    }

    public IModelLoader getDefaultModelLoader(String fileType) {
        String id = (String)this.defaultLoaders.get(fileType);
        return id != null ? this.getModelLoader(id) : null;
    }

    public IModelLoaderDescription[] findCompatibleModelLoaders(String fileType) {
        ArrayList<ModelLoaderDescription> result = new ArrayList<ModelLoaderDescription>();
        Iterator i = this.loaders.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            LoaderData data = (LoaderData)entry.getValue();
            if (!data.canHandle(fileType)) continue;
            result.add(new ModelLoaderDescription((String)entry.getKey(), data.getName()));
        }
        Set staticLoaderIds = (Set)this.modelLoadersByType.get(fileType);
        if (staticLoaderIds != null) {
            ArrayList<ModelLoaderDescription> staticLoaders = new ArrayList<ModelLoaderDescription>(staticLoaderIds.size());
            Iterator i2 = staticLoaderIds.iterator();
            while (i2.hasNext()) {
                String id = (String)i2.next();
                LoaderData loaderData = (LoaderData)this.loaders.get(id);
                if (loaderData == null) continue;
                staticLoaders.add(new ModelLoaderDescription(id, loaderData.getName()));
            }
            result.addAll(staticLoaders);
        }
        return result.toArray(new IModelLoaderDescription[result.size()]);
    }

    public void setDefaultLoader(String fileType, String id) {
        if (this.defaultLoaders.containsKey(fileType)) {
            throw new IllegalStateException();
        }
        this.defaultLoaders.put(fileType, id);
    }

    public void clearDefaultLoader(String fileType) {
        this.defaultLoaders.remove(fileType);
    }

    public String getDefaultModelLoaderId(String fileType) {
        return (String)this.defaultLoaders.get(fileType);
    }

    public void addLoaderForType(String id, String fileType) {
        HashSet<String> loaderSet = (HashSet<String>)this.modelLoadersByType.get(fileType);
        if (loaderSet == null) {
            loaderSet = new HashSet<String>();
            this.modelLoadersByType.put(fileType, loaderSet);
        }
        loaderSet.add(id);
    }

    public void removeLoaderForType(String id, String fileType) {
        Set loaderSet = (Set)this.modelLoadersByType.get(fileType);
        if (loaderSet != null) {
            loaderSet.remove(id);
        }
    }

    public IModelLoader getLoader(String url, String loaderId, String type) throws CoreJETException {
        IModelLoader loader = null;
        if (loaderId == null) {
            int index;
            if (type == null && url != null && (index = url.lastIndexOf(46)) != -1) {
                type = url.substring(index + 1);
            }
            loaderId = this.getDefaultModelLoaderId(type);
        }
        if (loaderId == null) {
            IModelLoaderDescription[] candidateLoaders = this.findCompatibleModelLoaders(type);
            if (candidateLoaders.length == 1) {
                loaderId = candidateLoaders[0].getId();
            } else if (candidateLoaders.length == 0) {
                loaderId = "org.eclipse.jet.emfxml";
            } else {
                String msg = MessageFormat.format(JET2Messages.LoaderManager_MultipleLoaders, url, candidateLoaders.toString());
                throw new CoreJETException(msg);
            }
        }
        if ((loader = this.getModelLoader(loaderId)) == null) {
            String msg = MessageFormat.format(JET2Messages.LoaderManager_CouldNotFindLoader, url);
            throw new CoreJETException(msg);
        }
        return loader;
    }

    private static class LoaderData {
        private final String name;
        private final ILoaderFactory factory;
        private IModelLoader loader = null;
        private final boolean dynamic;

        public final ILoaderFactory getFactory() {
            return this.factory;
        }

        public final String getName() {
            return this.name;
        }

        public LoaderData(String name, ILoaderFactory factory, boolean dynamic) {
            this.name = name;
            this.factory = factory;
            this.dynamic = dynamic;
        }

        public IModelLoader getLoader() {
            if (this.loader == null) {
                this.loader = this.factory.create();
            }
            return this.loader;
        }

        public boolean canHandle(String fileType) {
            if (this.dynamic) {
                IModelLoader theLoader = this.getLoader();
                return theLoader != null ? theLoader.canLoad(fileType) : false;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.name) + " (dynamic=" + this.dynamic + ")";
        }
    }
}

