/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.configuration;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.internal.editor.JETEditorHelper;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.annotations.JETAnnotationModel;
import org.eclipse.jet.internal.editor.annotations.JETProblemAnnotation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class JETReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private JETTextEditor jetEditor;
    private ISourceViewer sourceViewer;

    public JETReconcilingStrategy(ISourceViewer sourceViewer, JETTextEditor jetEditor) {
        this.jetEditor = jetEditor;
        this.sourceViewer = sourceViewer;
    }

    private void internalReconcile() {
        JETCompilationUnit cUnit = this.jetEditor.requestCompilationUnit();
        List cUnitProblems = cUnit.getProblems();
        List javaContentProblems = JETEditorHelper.evaluateProblems(this.jetEditor, this.sourceViewer.getDocument());
        JETAnnotationModel annotationModel = (JETAnnotationModel)this.sourceViewer.getAnnotationModel();
        if (annotationModel != null) {
            Position position;
            JETProblemAnnotation annotation;
            Problem problem;
            annotationModel.setFireChanges(false);
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation2 = (Annotation)it.next();
                if (!(annotation2 instanceof JETProblemAnnotation) && !(annotation2 instanceof MarkerAnnotation)) continue;
                annotationModel.removeAnnotation(annotation2);
            }
            Iterator iterator = cUnitProblems.iterator();
            while (iterator.hasNext()) {
                problem = (Problem)iterator.next();
                annotation = new JETProblemAnnotation(problem);
                position = new Position(problem.getStart(), problem.getEnd() - problem.getStart());
                annotationModel.addAnnotation(annotation, position);
            }
            iterator = javaContentProblems.iterator();
            while (iterator.hasNext()) {
                problem = (Problem)iterator.next();
                annotation = new JETProblemAnnotation(problem);
                position = new Position(problem.getStart(), problem.getEnd() - problem.getStart());
                annotationModel.addAnnotation(annotation, position);
            }
            annotationModel.setFireChanges(true);
            annotationModel.fireAnnotationModelChanged();
        }
    }

    public void setDocument(IDocument idocument) {
    }

    public void initialReconcile() {
        this.internalReconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.internalReconcile();
    }

    public void reconcile(IRegion partition) {
        this.internalReconcile();
    }

    public void setProgressMonitor(IProgressMonitor iprogressmonitor) {
    }
}

