/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.parser;

import java.util.Stack;

public class IncludeAlternativesTracker {
    private final Stack stack = new Stack();

    public boolean isCompileEnabled() {
        return this.stack.isEmpty() || ((IncludeWithAlternative)this.stack.peek()).isCompileEnabled();
    }

    public void addIncludeWithAlternative(Object directive, boolean processAlternative) {
        this.stack.push(new IncludeWithAlternative(directive, processAlternative, this.isCompileEnabled()));
    }

    public void startAlternative(Object directive) throws IllegalStateException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException();
        }
        IncludeWithAlternative include = (IncludeWithAlternative)this.stack.peek();
        include.doStart(directive);
    }

    public void endAlternative(Object directive) throws IllegalStateException {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException();
        }
        IncludeWithAlternative include = (IncludeWithAlternative)this.stack.peek();
        include.doEnd(directive);
        this.stack.pop();
    }

    public void validateStackIsEmpty(ValidationProblemReporter reporter) {
        while (!this.stack.isEmpty()) {
            IncludeWithAlternative include = (IncludeWithAlternative)this.stack.pop();
            if (include.isStateInitial()) {
                reporter.reportMissingStart(include.getIncludeDirective());
                continue;
            }
            if (!include.isStateStart()) continue;
            reporter.reportMissingEnd(include.getStartDirective());
        }
    }

    private static final class IncludeWithAlternative {
        private State state;
        private final boolean processAlternative;
        private final boolean parentCompileEnabled;
        private final Object includeDirective;
        private Object startDirective;

        public IncludeWithAlternative(Object includeDirective, boolean processAlternative, boolean parentCompileEnabled) {
            this.includeDirective = includeDirective;
            this.processAlternative = processAlternative;
            this.parentCompileEnabled = parentCompileEnabled;
            this.state = State.INITIAL;
        }

        public void doStart(Object startDirective) throws IllegalStateException {
            this.startDirective = startDirective;
            if (this.state != State.INITIAL) {
                throw new IllegalStateException();
            }
            this.state = State.START;
        }

        public void doEnd(Object startDirective) throws IllegalStateException {
            if (this.state != State.START) {
                throw new IllegalStateException();
            }
            this.state = State.END;
        }

        public boolean isProcessAlternative() {
            return this.processAlternative;
        }

        public boolean isCompileEnabled() throws IllegalStateException {
            if (this.state == State.END) {
                throw new IllegalStateException();
            }
            return this.parentCompileEnabled && (this.state != State.START || this.isProcessAlternative());
        }

        public boolean isStateInitial() {
            return this.state == State.INITIAL;
        }

        public boolean isStateStart() {
            return this.state == State.START;
        }

        public Object getIncludeDirective() {
            return this.includeDirective;
        }

        public Object getStartDirective() {
            return this.startDirective;
        }
    }

    private static final class State {
        public static final State INITIAL = new State("INITIAL");
        public static final State START = new State("START");
        public static final State END = new State("END");
        private final String display;

        private State(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }
    }

    public static interface ValidationProblemReporter {
        public void reportMissingStart(Object var1);

        public void reportMissingEnd(Object var1);
    }
}

