/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoPositionedVariable {
    private Variable fVariable;
    private List<Match> fMatches;
    private Match fDefinitionMatch;

    public AcceleoPositionedVariable(Variable variable, AcceleoEditor editor) {
        this.fVariable = variable;
        this.fMatches = new ArrayList<Match>();
        this.findAllPositionedVariables(editor);
    }

    public AcceleoPositionedVariable(VariableExp variableExp, AcceleoEditor editor) {
        this.fVariable = (Variable)variableExp.getReferredVariable();
        this.fMatches = new ArrayList<Match>();
        this.findAllPositionedVariables(editor);
    }

    public Variable getVariable() {
        return this.fVariable;
    }

    public String getVariableName() {
        return this.fVariable.getName();
    }

    public void setVariableMatches(List<Match> matches) {
        this.fMatches = matches;
    }

    public List<Match> getVariableMatches() {
        return this.fMatches;
    }

    public void setVariableDefinitionMatch(Match match) {
        this.fDefinitionMatch = match;
    }

    public Match getVariableDefinitionMatch() {
        return this.fDefinitionMatch;
    }

    private void findAllPositionedVariables(AcceleoEditor editor) {
        List<Match> list = OpenDeclarationUtils.findOccurrences(editor, (EObject)this.fVariable);
        list = OpenDeclarationUtils.findOccurrencesInTemplate((EObject)this.fVariable, list, editor.getFile());
        this.setVariableMatches(list);
        for (Match match : list) {
            if (match.getLength() <= this.fVariable.getName().length()) continue;
            this.setVariableDefinitionMatch(match);
        }
    }
}

