/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newproject;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.wizards.newproject.AcceleoNewProjectUIWizard;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateModuleUIData {
    private String projectName;
    private String moduleName;
    private List<String> pluginDependencies;
    private List<String> moduleTemplates;
    private List<String> moduleTemplatesPlugins;
    private List<String> moduleJavaClasses;
    private String modelNameFilter;
    private String targetFolderAccess;

    public CreateModuleUIData(AcceleoNewProjectUIWizard wizard) {
        this.projectName = wizard.getNewProjectPage().getProjectName();
        this.moduleName = wizard.getConfigurationPage().getModuleName();
        this.pluginDependencies = new ArrayList<String>();
        this.moduleTemplates = new ArrayList<String>();
        this.moduleTemplatesPlugins = new ArrayList<String>();
        this.moduleJavaClasses = new ArrayList<String>();
        this.computeTemplatesConfiguration(wizard.getProjectReferencesPage());
        this.modelNameFilter = wizard.getConfigurationPage().getModelNameFilter();
        this.targetFolderAccess = wizard.getConfigurationPage().getTargetFolderAccess();
    }

    private void computeTemplatesConfiguration(WizardNewProjectReferencePage page) {
        if (page.getReferencedProjects() != null) {
            IProject[] projects = page.getReferencedProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                this.pluginDependencies.add(project.getName());
                AcceleoProject acceleoProject = new AcceleoProject(project);
                this.computeModuleJavaClasses(acceleoProject, (IContainer)project);
                ++i;
            }
        }
    }

    private void computeModuleJavaClasses(AcceleoProject acceleoProject, IContainer container) {
        if (container != null) {
            try {
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member instanceof IFile) {
                        IFile fileAcceleo = (IFile)member;
                        IPath javaFileName = new Path(String.valueOf(Character.toUpperCase(fileAcceleo.getName().charAt(0))) + fileAcceleo.getName().substring(1)).removeFileExtension().addFileExtension("java");
                        if ("mtl".equals(fileAcceleo.getFileExtension()) && fileAcceleo.getParent().getFile(javaFileName).exists()) {
                            String templatePath = String.valueOf('/') + acceleoProject.getPackageName(fileAcceleo).replaceAll("\\.", "/") + '/' + new Path(fileAcceleo.getName()).removeFileExtension().addFileExtension("emtl").lastSegment();
                            this.moduleTemplates.add(templatePath);
                            this.moduleTemplatesPlugins.add(container.getProject().getName());
                            String javaClassName = String.valueOf(acceleoProject.getPackageName(fileAcceleo)) + "." + javaFileName.removeFileExtension().lastSegment();
                            this.moduleJavaClasses.add(javaClassName);
                        }
                    } else if (member instanceof IContainer) {
                        this.computeModuleJavaClasses(acceleoProject, (IContainer)member);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getModuleNameWithSpaces() {
        return this.moduleName;
    }

    public String getModuleNameWithoutSpaces() {
        return this.moduleName.replaceAll(" ", "").replaceAll("\t", "");
    }

    public List<String> getPluginDependencies() {
        return this.pluginDependencies;
    }

    public List<String> getModuleTemplates() {
        return this.moduleTemplates;
    }

    public List<String> getModuleTemplatesPlugins() {
        return this.moduleTemplatesPlugins;
    }

    public List<String> getModuleJavaClasses() {
        return this.moduleJavaClasses;
    }

    public String getModelNameFilter() {
        return this.modelNameFilter;
    }

    public String getTargetFolderAccess() {
        return this.targetFolderAccess;
    }
}

