/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.common.utils.AcceleoASTNodeAdapter;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironment;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationContext;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitorDecorator;
import org.eclipse.acceleo.engine.internal.utils.AcceleoOverrideAdapter;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.InitSection;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.profiler.Profiler;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorDecorator;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.impl.OCLExpressionImpl;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends EvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static IDebugAST debug;
    private static final String ITERATION_COUNT_VARIABLE_NAME = "i";
    private static final Object NULL_QUERY_RESULT;
    private static Profiler profile;
    private static final String SELF_VARIABLE_NAME = "self";
    private static final String TEMPORARY_CONTEXT_VAR_PREFIX = "context$";
    private static final String TEMPORARY_INVOCATION_ARG_PREFIX = "temporaryInvocationVariable$";
    private static final String UNDEFINED_GUARD_MESSAGE_KEY = "AcceleoEvaluationVisitor.UndefinedGuard";
    private static final Object UNDEFINED_QUERY_RESULT;
    private final AcceleoEvaluationContext<C> context;
    private int currentContextIndex;
    private boolean evaluatingInitSection;
    private boolean fireGenerationEvent;
    private EObject lastEObjectSelfValue;
    private OCLExpression<C> lastSourceExpression;
    private Object lastSourceExpressionResult;
    private final Object invalid = this.getAcceleoEnvironment().getOCLStandardLibraryReflection().getInvalid();
    private final Map<Query, Map<List<Object>, Object>> queryResults = new HashMap<Query, Map<List<Object>, Object>>();
    private EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> visitor;

    static {
        NULL_QUERY_RESULT = new Object();
        UNDEFINED_QUERY_RESULT = new Object();
    }

    public AcceleoEvaluationVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratedVisitor, AcceleoEvaluationContext<C> context) {
        super(decoratedVisitor);
        this.context = context;
        this.visitor = this;
    }

    public static void setDebug(IDebugAST acceleoDebug) {
        debug = acceleoDebug;
    }

    public static void setProfile(Profiler acceleoProfile) {
        profile = acceleoProfile;
    }

    public void append(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        this.context.append(string, sourceBlock, source, fireEvent);
    }

    public void createFileWriter(File generatedFile, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        this.context.openNested(generatedFile, fileBlock, source, appendMode, charset);
    }

    public void visitAcceleoBlock(Block block) {
        for (org.eclipse.ocl.ecore.OCLExpression nested : block.getBody()) {
            this.getVisitor().visitExpression((OCLExpression)nested);
        }
    }

    public void visitAcceleoFileBlock(FileBlock fileBlock) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object fileURLResult = this.getVisitor().visitExpression((OCLExpression)fileBlock.getFileUrl());
        this.fireGenerationEvent = fireEvents;
        if (this.isUndefined(fileURLResult)) {
            AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.UndefinedFileURL", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
            throw exception;
        }
        if (fileURLResult instanceof Collection) {
            AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.CollectionFileURL", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
            throw exception;
        }
        if (!(fileURLResult instanceof String)) {
            AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.NotStringFileURL", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
            throw exception;
        }
        String filePath = String.valueOf(fileURLResult).trim();
        String fileCharset = null;
        if (fileBlock.getCharset() != null) {
            Object fileCharsetResult = this.visitExpression((OCLExpression<C>)fileBlock.getCharset());
            if (this.isUndefined(fileCharsetResult)) {
                AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)fileBlock, "AcceleoEvaluationVisitor.UndefinedFileCharset", this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME));
                AcceleoEnginePlugin.log(exception, false);
            }
            fileCharset = String.valueOf(fileCharsetResult);
        }
        boolean appendMode = fileBlock.getOpenMode().getValue() == 0;
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        EObject source = currentSelf instanceof EObject ? (EObject)currentSelf : this.lastEObjectSelfValue;
        if ("stdout".equals(filePath)) {
            this.context.openNested(System.out);
        } else {
            this.delegateCreateFileWriter(filePath, (Block)fileBlock, source, appendMode, fileCharset);
        }
        for (org.eclipse.ocl.ecore.OCLExpression nested : fileBlock.getBody()) {
            this.fireGenerationEvent = true;
            this.getVisitor().visitExpression((OCLExpression)nested);
            this.fireGenerationEvent = fireEvents;
        }
        this.context.closeContext((Block)fileBlock, source);
    }

    public void visitAcceleoForBlock(ForBlock forBlock) {
        ArrayList actualIteration;
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object iteration = this.visitExpression((OCLExpression<C>)forBlock.getIterSet());
        this.fireGenerationEvent = fireEvents;
        Variable loopVariable = forBlock.getLoopVariable();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(iteration)) {
            throw this.context.createAcceleoException((ASTNode)forBlock, "AcceleoEvaluationVisitor.InvalidForIteration", currentSelf);
        }
        if (iteration instanceof Collection) {
            actualIteration = (ArrayList)iteration;
        } else {
            actualIteration = new ArrayList();
            ((List)actualIteration).add(iteration);
        }
        if (actualIteration.size() > 0 && forBlock.getBefore() != null) {
            this.visitExpression((OCLExpression<C>)forBlock.getBefore());
        }
        Iterator contentIterator = actualIteration.iterator();
        boolean iterationCCE = false;
        boolean hasPrevious = false;
        String implicitContextVariableName = null;
        int count = 0;
        try {
            while (contentIterator.hasNext()) {
                Object guardValue;
                if (++count == 1) {
                    this.getEvaluationEnvironment().add(ITERATION_COUNT_VARIABLE_NAME, (Object)count);
                } else {
                    this.getEvaluationEnvironment().replace(ITERATION_COUNT_VARIABLE_NAME, (Object)count);
                }
                Object o = contentIterator.next();
                if (loopVariable != null && loopVariable.getType() != null && !((EClassifier)loopVariable.getType()).isInstance(o)) {
                    if (iterationCCE) continue;
                    int line = this.getLineOf((ASTNode)forBlock);
                    String message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.IterationClassCast", line, ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock.toString(), o.getClass().getName(), ((EClassifier)loopVariable.getType()).getName());
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(message);
                    exception.setStackTrace(this.context.createAcceleoStackTrace());
                    AcceleoEnginePlugin.log(exception, false);
                    iterationCCE = true;
                    continue;
                }
                if (loopVariable != null) {
                    if (count == 1) {
                        this.getEvaluationEnvironment().add(loopVariable.getName(), o);
                    } else {
                        this.getEvaluationEnvironment().replace(loopVariable.getName(), o);
                    }
                }
                if (implicitContextVariableName == null) {
                    implicitContextVariableName = this.addContextVariableFor(o);
                } else {
                    this.getEvaluationEnvironment().replace(implicitContextVariableName, o);
                }
                this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, o);
                if (forBlock.getGuard() == null) {
                    guardValue = Boolean.TRUE;
                } else {
                    this.fireGenerationEvent = false;
                    guardValue = this.visitExpression((OCLExpression<C>)forBlock.getGuard());
                    this.fireGenerationEvent = fireEvents;
                }
                if (this.isInvalid(guardValue)) {
                    AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)forBlock, (OCLExpression<C>)forBlock.getGuard(), UNDEFINED_GUARD_MESSAGE_KEY, o);
                    throw exception;
                }
                if (guardValue != null && ((Boolean)guardValue).booleanValue()) {
                    if (forBlock.getEach() != null && hasPrevious) {
                        this.visitExpression((OCLExpression<C>)forBlock.getEach());
                    }
                    for (org.eclipse.ocl.ecore.OCLExpression nested : forBlock.getBody()) {
                        this.getVisitor().visitExpression((OCLExpression)nested);
                    }
                    hasPrevious = true;
                }
                this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            }
        }
        finally {
            if (count > 0) {
                if (loopVariable != null) {
                    this.getEvaluationEnvironment().remove(loopVariable.getName());
                }
                this.getEvaluationEnvironment().remove(implicitContextVariableName);
                --this.currentContextIndex;
                this.getEvaluationEnvironment().remove(ITERATION_COUNT_VARIABLE_NAME);
            }
        }
        if (actualIteration.size() > 0 && forBlock.getAfter() != null) {
            this.visitExpression((OCLExpression<C>)forBlock.getAfter());
        }
    }

    public void visitAcceleoIfBlock(IfBlock ifBlock) {
        org.eclipse.ocl.ecore.OCLExpression condition = ifBlock.getIfExpr();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object conditionValue = this.getVisitor().visitExpression((OCLExpression)condition);
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(conditionValue)) {
            AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)ifBlock, "AcceleoEvaluationVisitor.UndefinedCondition", currentSelf);
            throw exception;
        }
        if (conditionValue != null && ((Boolean)conditionValue).booleanValue()) {
            for (org.eclipse.ocl.ecore.OCLExpression nested : ifBlock.getBody()) {
                this.visitExpression((OCLExpression<C>)nested);
            }
        } else if (ifBlock.getElseIf().size() > 0) {
            IfBlock temp = null;
            for (IfBlock elseif : ifBlock.getElseIf()) {
                this.fireGenerationEvent = false;
                Object elseValue = this.getVisitor().visitExpression((OCLExpression)elseif.getIfExpr());
                this.fireGenerationEvent = fireEvents;
                if (this.isInvalid(elseValue)) {
                    AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)elseif, "AcceleoEvaluationVisitor.UndefinedElseCondition", currentSelf);
                    throw exception;
                }
                if (elseValue == null || !((Boolean)elseValue).booleanValue()) continue;
                temp = elseif;
                break;
            }
            if (temp != null) {
                for (org.eclipse.ocl.ecore.OCLExpression nested : temp.getBody()) {
                    this.visitExpression((OCLExpression<C>)nested);
                }
            } else if (ifBlock.getElse() != null) {
                this.visitAcceleoBlock(ifBlock.getElse());
            }
        } else if (ifBlock.getElse() != null) {
            this.visitAcceleoBlock(ifBlock.getElse());
        }
    }

    public void visitAcceleoInitSection(InitSection init) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        this.evaluatingInitSection = true;
        for (Variable var : init.getVariable()) {
            this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
        }
        this.evaluatingInitSection = false;
        this.fireGenerationEvent = fireEvents;
    }

    public void visitAcceleoLetBlock(LetBlock letBlock) {
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        Variable var = letBlock.getLetVariable();
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object value = this.visitExpression(var.getInitExpression());
        this.fireGenerationEvent = fireEvents;
        if (this.isInvalid(value)) {
            AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)letBlock, "AcceleoEvaluationVisitor.UndefinedLetValue", currentSelf);
            throw exception;
        }
        String varName = null;
        try {
            if (((EClassifier)var.getType()).isInstance(value)) {
                varName = var.getName();
                this.getEvaluationEnvironment().add(varName, value);
                for (org.eclipse.ocl.ecore.OCLExpression nested : letBlock.getBody()) {
                    this.visitExpression((OCLExpression<C>)nested);
                }
            } else if (letBlock.getElseLet().size() > 0) {
                LetBlock temp = null;
                for (LetBlock elseLet : letBlock.getElseLet()) {
                    var = elseLet.getLetVariable();
                    this.fireGenerationEvent = false;
                    value = this.visitExpression(var.getInitExpression());
                    this.fireGenerationEvent = fireEvents;
                    if (this.isInvalid(value)) {
                        AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)elseLet, "AcceleoEvaluationVisitor.UndefinedElseLetValue", currentSelf);
                        throw exception;
                    }
                    if (!((EClassifier)var.getType()).isInstance(value)) continue;
                    varName = var.getName();
                    this.getEvaluationEnvironment().add(var.getName(), value);
                    temp = elseLet;
                    break;
                }
                if (temp != null) {
                    for (org.eclipse.ocl.ecore.OCLExpression nested : temp.getBody()) {
                        this.visitExpression((OCLExpression<C>)nested);
                    }
                } else if (letBlock.getElse() != null) {
                    this.visitAcceleoBlock(letBlock.getElse());
                }
            } else if (letBlock.getElse() != null) {
                this.visitAcceleoBlock(letBlock.getElse());
            }
        }
        catch (Throwable throwable) {
            if (varName != null) {
                this.getEvaluationEnvironment().remove(varName);
            }
            throw throwable;
        }
        if (varName != null) {
            this.getEvaluationEnvironment().remove(varName);
        }
    }

    public void visitAcceleoProtectedArea(ProtectedAreaBlock protectedArea) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        Object markerValue = this.getVisitor().visitExpression((OCLExpression)protectedArea.getMarker());
        this.fireGenerationEvent = fireEvents;
        Object source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(markerValue)) {
            AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)protectedArea, "AcceleoEvaluationVisitor.UndefinedAreaMarker", source);
            throw exception;
        }
        String marker = this.toString(markerValue).trim();
        String areaContent = this.context.getProtectedAreaContent(marker);
        if (source instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        if (areaContent != null) {
            this.delegateAppend(areaContent, (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
        } else {
            this.context.openNested();
            this.fireGenerationEvent = false;
            this.visitAcceleoBlock((Block)protectedArea);
            this.fireGenerationEvent = fireEvents;
            String blockContent = this.context.closeContext();
            StringBuilder buffer = new StringBuilder();
            buffer.append(AcceleoEngineMessages.getString("usercode.start"));
            buffer.append(' ');
            buffer.append(marker);
            buffer.append(blockContent);
            buffer.append(AcceleoEngineMessages.getString("usercode.end"));
            this.delegateAppend(buffer.toString(), (Block)protectedArea, this.lastEObjectSelfValue, this.fireGenerationEvent);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAcceleoQueryInvocation(QueryInvocation invocation) {
        query = invocation.getDefinition();
        implicitContextVariableName = null;
        arguments = new ArrayList<Object>();
        fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        i = 0;
        while (i < query.getParameter().size()) {
            var = (Variable)query.getParameter().get(i);
            var.setInitExpression((OCLExpression)new ParameterInitExpression((OCLExpression)invocation.getArgument().get(i)));
            this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
            argValue = this.getEvaluationEnvironment().getValueOf(var.getName());
            if (this.isInvalid(argValue)) {
                exception = this.context.createAcceleoException((ASTNode)invocation, (OCLExpression)invocation.getArgument().get(i), "AcceleoEvaluationVisitor.UndefinedArgument", this.getEvaluationEnvironment().getValueOf("self"));
                j = 0;
                while (j <= i) {
                    this.getEvaluationEnvironment().remove(((Variable)query.getParameter().get(j)).getName());
                    ++j;
                }
                throw exception;
            }
            arguments.add(argValue);
            var.setInitExpression(null);
            ++i;
        }
        this.fireGenerationEvent = fireEvents;
        if (this.queryResults.containsKey(query) && (result = (results = this.queryResults.get(query)).get(arguments)) != null) {
            for (Variable var : query.getParameter()) {
                this.getEvaluationEnvironment().remove(var.getName());
            }
            if (result == AcceleoEvaluationVisitor.UNDEFINED_QUERY_RESULT) {
                line = this.getLineOf((ASTNode)invocation);
                moduleName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
                message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", new Object[]{query.getExpression(), line, moduleName, query, this.getEvaluationEnvironment().getValueOf("self")});
                exception = new AcceleoEvaluationException(message);
                throw exception;
            }
            if (result == AcceleoEvaluationVisitor.NULL_QUERY_RESULT) {
                result = null;
            }
            return result;
        }
        if (arguments.size() > 0) {
            this.getEvaluationEnvironment().add("self", arguments.get(0));
            implicitContextVariableName = this.addContextVariableFor(arguments.get(0));
        }
        result = null;
        try {
            result = this.visitExpression((OCLExpression<C>)query.getExpression());
        }
        finally {
            ** for (var : query.getParameter())
        }
lbl-1000:
        // 1 sources

        {
            this.getEvaluationEnvironment().remove(var.getName());
            continue;
        }
lbl54:
        // 1 sources

        if (arguments.size() > 0) {
            this.getEvaluationEnvironment().remove("self");
            this.getEvaluationEnvironment().remove(implicitContextVariableName);
            --this.currentContextIndex;
        }
        if (this.queryResults.containsKey(query)) {
            results = this.queryResults.get(query);
            if (this.isInvalid(result)) {
                results.put(arguments, AcceleoEvaluationVisitor.UNDEFINED_QUERY_RESULT);
            } else if (result == null) {
                results.put(arguments, AcceleoEvaluationVisitor.NULL_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
        } else {
            results = new HashMap<K, V>(2);
            if (this.isInvalid(result)) {
                results.put(arguments, AcceleoEvaluationVisitor.UNDEFINED_QUERY_RESULT);
            } else if (result == null) {
                results.put(arguments, AcceleoEvaluationVisitor.NULL_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
            this.queryResults.put(query, results);
        }
        if (this.isInvalid(result)) {
            line = this.getLineOf((ASTNode)invocation);
            moduleName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
            message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", new Object[]{query.getExpression(), line, moduleName, query, this.getEvaluationEnvironment().getValueOf("self")});
            exception = new AcceleoEvaluationException(message);
            throw exception;
        }
        return result;
    }

    public String visitAcceleoTemplate(Template template) {
        this.context.openNested();
        for (org.eclipse.ocl.ecore.OCLExpression nested : template.getBody()) {
            this.getVisitor().visitExpression((OCLExpression)nested);
        }
        String result = this.context.closeContext();
        if (template.getPost() != null) {
            this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, (Object)result);
            Object postResult = this.getVisitor().visitExpression((OCLExpression)template.getPost());
            this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            if (this.isInvalid(postResult)) {
                int line = this.getLineOf((ASTNode)template);
                String moduleName = ((Module)EcoreUtil.getRootContainer((EObject)template)).getName();
                String message = AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedPost", template.getPost(), line, moduleName, template, result);
                AcceleoEvaluationException exception = new AcceleoEvaluationException(message);
                throw exception;
            }
            result = this.toString(postResult);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitAcceleoTemplateInvocation(TemplateInvocation invocation) {
        implicitContextVariableName = null;
        actualTemplate = this.prepareInvocation(invocation);
        if (actualTemplate.getParameter().size() > 0) {
            contextValue = this.getEvaluationEnvironment().getValueOf(((Variable)actualTemplate.getParameter().get(0)).getName());
            this.getEvaluationEnvironment().add("self", contextValue);
            implicitContextVariableName = this.addContextVariableFor(contextValue);
        }
        this.context.openNested();
        if (invocation.getBefore() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getBefore());
        }
        if ((source = this.getEvaluationEnvironment().getValueOf("self")) instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        try {
            result = this.getVisitor().visitExpression((OCLExpression)actualTemplate);
            this.delegateAppend(this.toString(result), (Block)actualTemplate, this.lastEObjectSelfValue, false);
        }
        finally {
            i = 0;
            ** while (i < actualTemplate.getParameter().size())
        }
lbl-1000:
        // 1 sources

        {
            param = (Variable)actualTemplate.getParameter().get(i);
            param.setInitExpression(null);
            this.getEvaluationEnvironment().remove(param.getName());
            this.getEvaluationEnvironment().remove("temporaryInvocationVariable$" + i);
            ++i;
            continue;
        }
lbl28:
        // 1 sources

        if (actualTemplate.getParameter().size() > 0) {
            this.getEvaluationEnvironment().remove("self");
            this.getEvaluationEnvironment().remove(implicitContextVariableName);
            --this.currentContextIndex;
        }
        if (invocation.getAfter() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getAfter());
        }
        ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).removeVariableScope();
        invocationResult = this.context.closeContext();
        if (this.evaluatingInitSection) {
            return invocationResult;
        }
        return this.delegateFitIndentation(invocationResult);
    }

    public Object visitExpression(OCLExpression<C> expression) {
        Object result;
        block31: {
            result = null;
            EObject debugInput = null;
            ASTFragment astFragment = null;
            this.context.addToStack((OCLExpression<C>)expression);
            if (this.context.getProgressMonitor().isCanceled()) {
                this.cancel(astFragment, debugInput, result);
            }
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                Object name;
                debugInput = this.lastEObjectSelfValue;
                astFragment = new ASTFragment((ASTNode)expression);
                if (debugInput != null && debugInput.eClass().getEStructuralFeature("name") != null && (name = debugInput.eGet(debugInput.eClass().getEStructuralFeature("name"))) instanceof String) {
                    astFragment.setEObjectNameFilter((String)name);
                }
                debug.startDebug(astFragment);
                Map<Object, Object> vars = this.getEvaluationEnvironment() instanceof AcceleoEvaluationEnvironment ? ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getCurrentVariables() : new HashMap();
                debug.stepDebugInput(astFragment, vars);
            }
            if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                profile.start(expression);
                profile.loop(this.lastEObjectSelfValue);
            }
            boolean hasInit = expression instanceof Block && ((Block)expression).getInit() != null;
            try {
                if (hasInit) {
                    this.visitAcceleoInitSection(((Block)expression).getInit());
                }
                boolean fireEvents = this.fireGenerationEvent;
                if (expression == this.lastSourceExpression) {
                    this.fireGenerationEvent = false;
                }
                result = this.switchExpression((OCLExpression<C>)expression);
                this.fireGenerationEvent = fireEvents;
                if (expression == this.lastSourceExpression) {
                    this.lastSourceExpressionResult = result;
                }
                if (this.shouldGenerateText((EReference)expression.eContainingFeature())) {
                    Object source = null;
                    EObject generatedBlock = expression;
                    while (!(generatedBlock instanceof Block)) {
                        generatedBlock = generatedBlock.eContainer();
                    }
                    if (this.lastSourceExpressionResult == null) {
                        source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    } else {
                        source = this.lastSourceExpressionResult;
                        this.lastSourceExpressionResult = null;
                    }
                    if (source instanceof EObject) {
                        this.lastEObjectSelfValue = (EObject)source;
                    }
                    if (result != null) {
                        boolean fireEvent = this.fireGenerationEvent && !(expression instanceof TemplateInvocation) && !(expression instanceof Template);
                        this.delegateAppend(this.toString(result), (Block)generatedBlock, this.lastEObjectSelfValue, fireEvent);
                    }
                }
            }
            catch (AcceleoEvaluationCancelledException e) {
                throw e;
            }
            catch (AcceleoEvaluationException e) {
                AcceleoEnginePlugin.log(e, false);
                if (debug != null && !(expression instanceof StringLiteralExp)) {
                    debug.stepDebugOutput(astFragment, debugInput, result);
                    debug.endDebug(astFragment);
                }
                if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                    profile.stop();
                }
                if (hasInit) {
                    this.restoreInitVariables(((Block)expression).getInit());
                }
                this.context.removeFromStack((OCLExpression<C>)expression);
                break block31;
            }
            catch (RuntimeException e) {
                try {
                    try {
                        this.context.dispose();
                    }
                    catch (AcceleoEvaluationException acceleoEvaluationException) {}
                    throw e;
                }
                catch (Throwable throwable) {
                    if (debug != null && !(expression instanceof StringLiteralExp)) {
                        debug.stepDebugOutput(astFragment, debugInput, result);
                        debug.endDebug(astFragment);
                    }
                    if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                        profile.stop();
                    }
                    if (hasInit) {
                        this.restoreInitVariables(((Block)expression).getInit());
                    }
                    this.context.removeFromStack((OCLExpression<C>)expression);
                    throw throwable;
                }
            }
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                debug.stepDebugOutput(astFragment, debugInput, result);
                debug.endDebug(astFragment);
            }
            if (profile != null && this.profileExpression((OCLExpression<C>)expression)) {
                profile.stop();
            }
            if (hasInit) {
                this.restoreInitVariables(((Block)expression).getInit());
            }
            this.context.removeFromStack((OCLExpression<C>)expression);
        }
        return result;
    }

    public Object visitOperationCallExp(OperationCallExp<C, O> callExp) {
        if (callExp.getOperationCode() == 1) {
            Object stringType = this.getEnvironment().getOCLStandardLibrary().getString();
            if (callExp.getSource().getType() == stringType || ((OCLExpression)callExp.getArgument().get(0)).getType() == stringType) {
                ((EObject)callExp.getReferredOperation()).eAdapters().add((Object)new AcceleoOverrideAdapter());
            }
        }
        this.lastSourceExpression = callExp.getSource();
        return this.getDelegate().visitOperationCallExp(callExp);
    }

    public Object visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return this.getDelegate().visitPropertyCallExp(callExp);
    }

    void setVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratingVisitor) {
        this.visitor = decoratingVisitor;
    }

    protected final AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getAcceleoVisitor() {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            return (AcceleoEvaluationVisitorDecorator)this.getVisitor();
        }
        return null;
    }

    protected final EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getVisitor() {
        return this.visitor;
    }

    private String addContextVariableFor(Object contextValue) {
        String variableName = TEMPORARY_CONTEXT_VAR_PREFIX + this.currentContextIndex++;
        while (this.getEvaluationEnvironment().getValueOf(variableName) != null) {
            variableName = TEMPORARY_CONTEXT_VAR_PREFIX + this.currentContextIndex++;
        }
        this.getEvaluationEnvironment().add(variableName, contextValue);
        return variableName;
    }

    private void cancel(ASTFragment astFragment, EObject debugInput, Object result) {
        if (debug != null) {
            debug.stepDebugOutput(astFragment, debugInput, result);
            debug.endDebug(astFragment);
            debug = null;
        }
        this.context.dispose();
        throw new AcceleoEvaluationCancelledException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.CancelException"));
    }

    private void delegateAppend(String string, Block sourceBlock, EObject source, boolean fireEvent) {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            this.getAcceleoVisitor().append(string, sourceBlock, source, fireEvent);
        } else {
            this.append(string, sourceBlock, source, fireEvent);
        }
    }

    private void delegateCreateFileWriter(String filePath, Block fileBlock, EObject source, boolean appendMode, String charset) throws AcceleoEvaluationException {
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            this.getAcceleoVisitor().createFileWriter(this.context.getFileFor(filePath), fileBlock, source, appendMode, charset);
        } else {
            this.createFileWriter(this.context.getFileFor(filePath), fileBlock, source, appendMode, charset);
        }
    }

    private void evaluateGuards(List<Template> candidates, List<Variable> arguments) {
        boolean fireEvents = this.fireGenerationEvent;
        this.fireGenerationEvent = false;
        AcceleoEvaluationException exception = null;
        for (Template candidate : new ArrayList<Template>(candidates)) {
            if (candidate.getGuard() == null) continue;
            int i = 0;
            while (i < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i);
                VariableExp init = EcoreFactory.eINSTANCE.createVariableExp();
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)arguments.get(i));
                param.setInitExpression((OCLExpression)init);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)param);
                if (i == 0) {
                    Object newContext = this.getEvaluationEnvironment().getValueOf(param.getName());
                    this.getEvaluationEnvironment().add(SELF_VARIABLE_NAME, newContext);
                }
                ++i;
            }
            Object guardValue = this.getVisitor().visitExpression((OCLExpression)candidate.getGuard());
            int i2 = 0;
            while (i2 < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i2);
                param.setInitExpression(null);
                this.getEvaluationEnvironment().remove(param.getName());
                ++i2;
            }
            if (candidate.getParameter().size() > 0) {
                this.getEvaluationEnvironment().remove(SELF_VARIABLE_NAME);
            }
            if (this.isInvalid(guardValue)) {
                if (exception == null) {
                    Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    exception = this.context.createAcceleoException((ASTNode)candidate, (OCLExpression<C>)candidate.getGuard(), UNDEFINED_GUARD_MESSAGE_KEY, currentSelf);
                }
                candidates.remove(candidate);
                continue;
            }
            if (guardValue != null && ((Boolean)guardValue).booleanValue()) continue;
            candidates.remove(candidate);
        }
        if (candidates.size() == 0 && exception != null) {
            throw exception;
        }
        this.fireGenerationEvent = fireEvents;
    }

    private AcceleoEnvironment getAcceleoEnvironment() {
        return (AcceleoEnvironment)this.getEnvironment();
    }

    private int getLineOf(ASTNode node) {
        Adapter adapter = EcoreUtil.getAdapter((List)node.eAdapters(), AcceleoASTNodeAdapter.class);
        int line = 0;
        if (adapter != null) {
            line = ((AcceleoASTNodeAdapter)adapter).getLine();
        }
        return line;
    }

    private boolean isInvalid(Object value) {
        return value == this.invalid;
    }

    private boolean isUndefined(Object value) {
        return value == null || value == this.invalid;
    }

    private Template prepareInvocation(TemplateInvocation invocation) {
        Template actualTemplate;
        Template template = invocation.getDefinition();
        ArrayList<Variable> temporaryArgVars = new ArrayList<Variable>(invocation.getArgument().size());
        if (invocation.isSuper()) {
            VariableExp init;
            Template containingTemplate = (Template)invocation.eContainer();
            actualTemplate = containingTemplate.eContainer() instanceof TemplateInvocation ? ((TemplateInvocation)containingTemplate.eContainer()).getDefinition() : (Template)template.getOverrides().get(0);
            boolean fireEvents = this.fireGenerationEvent;
            this.fireGenerationEvent = false;
            int i = 0;
            while (i < actualTemplate.getParameter().size()) {
                Variable tempVar = EcoreFactory.eINSTANCE.createVariable();
                tempVar.setName(TEMPORARY_INVOCATION_ARG_PREFIX + i);
                init = EcoreFactory.eINSTANCE.createVariableExp();
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)containingTemplate.getParameter().get(i));
                tempVar.setInitExpression((OCLExpression)init);
                temporaryArgVars.add(tempVar);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)tempVar);
                ++i;
            }
            ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).createVariableScope();
            i = 0;
            while (i < actualTemplate.getParameter().size()) {
                Variable var = (Variable)actualTemplate.getParameter().get(i);
                init = EcoreFactory.eINSTANCE.createVariableExp();
                init.setReferredVariable((org.eclipse.ocl.expressions.Variable)temporaryArgVars.get(i));
                var.setInitExpression((OCLExpression)init);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
                ++i;
            }
            this.fireGenerationEvent = fireEvents;
        } else {
            ArrayList<Object> argValues = new ArrayList<Object>();
            boolean fireEvents = this.fireGenerationEvent;
            this.fireGenerationEvent = false;
            int i = 0;
            while (i < invocation.getArgument().size()) {
                Variable tempVar = EcoreFactory.eINSTANCE.createVariable();
                tempVar.setName(TEMPORARY_INVOCATION_ARG_PREFIX + i);
                tempVar.setInitExpression((OCLExpression)new ParameterInitExpression((OCLExpression)invocation.getArgument().get(i)));
                temporaryArgVars.add(tempVar);
                this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)tempVar);
                Object argValue = this.getEvaluationEnvironment().getValueOf(tempVar.getName());
                if (this.isInvalid(argValue)) {
                    Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    AcceleoEvaluationException exception = this.context.createAcceleoException((ASTNode)invocation, (OCLExpression)invocation.getArgument().get(i), "AcceleoEvaluationVisitor.UndefinedArgument", currentSelf);
                    int j = 0;
                    while (j <= i) {
                        this.getEvaluationEnvironment().remove(((org.eclipse.ocl.ecore.OCLExpression)invocation.getArgument().get(j)).getName());
                        ++j;
                    }
                    throw exception;
                }
                argValues.add(this.getEvaluationEnvironment().getValueOf(tempVar.getName()));
                ++i;
            }
            this.fireGenerationEvent = fireEvents;
            List<Template> applicableCandidates = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getAllCandidates((Module)EcoreUtil.getRootContainer((EObject)invocation), template, argValues);
            this.evaluateGuards(applicableCandidates, temporaryArgVars);
            ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).createVariableScope();
            if (applicableCandidates.size() > 0) {
                actualTemplate = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getMostSpecificTemplate(applicableCandidates, argValues);
                int i2 = 0;
                while (i2 < actualTemplate.getParameter().size()) {
                    Variable var = (Variable)actualTemplate.getParameter().get(i2);
                    VariableExp init = EcoreFactory.eINSTANCE.createVariableExp();
                    init.setReferredVariable((org.eclipse.ocl.expressions.Variable)temporaryArgVars.get(i2));
                    var.setInitExpression((OCLExpression)init);
                    this.getVisitor().visitVariable((org.eclipse.ocl.expressions.Variable)var);
                    ++i2;
                }
            } else {
                actualTemplate = MtlFactory.eINSTANCE.createTemplate();
            }
        }
        return actualTemplate;
    }

    private boolean profileExpression(OCLExpression<C> expression) {
        return !(expression instanceof StringLiteralExp);
    }

    private void restoreInitVariables(InitSection init) {
        for (Variable var : init.getVariable()) {
            this.getEvaluationEnvironment().remove(var.getName());
        }
    }

    private boolean shouldGenerateText(EReference reference) {
        boolean generate = reference == MtlPackage.eINSTANCE.getBlock_Body();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_After();
        return generate;
    }

    private Object switchExpression(OCLExpression<C> expression) {
        Object result;
        if (expression == null) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UnresolvedCompilationError"));
        }
        AcceleoEvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> delegate = this.getAcceleoVisitor();
        if (expression instanceof Template) {
            result = delegate != null ? delegate.visitAcceleoTemplate((Template)expression) : this.visitAcceleoTemplate((Template)expression);
        } else if (expression instanceof IfBlock) {
            if (delegate != null) {
                delegate.visitAcceleoIfBlock((IfBlock)expression);
            } else {
                this.visitAcceleoIfBlock((IfBlock)expression);
            }
            result = "";
        } else if (expression instanceof ForBlock) {
            if (delegate != null) {
                delegate.visitAcceleoForBlock((ForBlock)expression);
            } else {
                this.visitAcceleoForBlock((ForBlock)expression);
            }
            result = "";
        } else if (expression instanceof FileBlock) {
            if (delegate != null) {
                delegate.visitAcceleoFileBlock((FileBlock)expression);
            } else {
                this.visitAcceleoFileBlock((FileBlock)expression);
            }
            result = "";
        } else if (expression instanceof TemplateInvocation) {
            result = delegate != null ? delegate.visitAcceleoTemplateInvocation((TemplateInvocation)expression) : this.visitAcceleoTemplateInvocation((TemplateInvocation)expression);
        } else if (expression instanceof QueryInvocation) {
            result = delegate != null ? delegate.visitAcceleoQueryInvocation((QueryInvocation)expression) : this.visitAcceleoQueryInvocation((QueryInvocation)expression);
        } else if (expression instanceof LetBlock) {
            if (delegate != null) {
                delegate.visitAcceleoLetBlock((LetBlock)expression);
            } else {
                this.visitAcceleoLetBlock((LetBlock)expression);
            }
            result = "";
        } else if (expression instanceof ProtectedAreaBlock) {
            if (delegate != null) {
                delegate.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
            } else {
                this.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
            }
            result = "";
        } else {
            result = super.visitExpression(expression);
        }
        return result;
    }

    public String fitIndentationTo(String source, String indentation) {
        String regex = "\r\n|\r|\n";
        String replacement = "$0" + indentation;
        Matcher sourceMatcher = Pattern.compile(regex).matcher(source);
        StringBuffer result = new StringBuffer();
        boolean hasMatch = sourceMatcher.find();
        while (hasMatch) {
            sourceMatcher.appendReplacement(result, replacement);
            hasMatch = sourceMatcher.find();
        }
        sourceMatcher.appendTail(result);
        return result.toString();
    }

    private String delegateFitIndentation(String source) {
        String currentIndent = this.context.getCurrentLineIndentation();
        if (this.getVisitor() instanceof AcceleoEvaluationVisitorDecorator) {
            return this.getAcceleoVisitor().fitIndentationTo(source, currentIndent);
        }
        return this.fitIndentationTo(source, currentIndent);
    }

    private String toString(Object object) {
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else if (object != null) {
            buffer.append(object.toString());
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterInitExpression
    extends OCLExpressionImpl {
        private final OCLExpression<C> referredExpression;

        public ParameterInitExpression(OCLExpression<C> expession) {
            this.referredExpression = expession;
        }

        public <T, U extends Visitor<T, ?, ?, ?, ?, ?, ?, ?, ?, ?>> T accept(U v) {
            return (T)this.referredExpression.accept(v);
        }
    }
}

