/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.engine.internal.debug.IDebugAST;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEvaluationEnvironment;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationContext;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.FileBlock;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.IfBlock;
import org.eclipse.acceleo.model.mtl.InitSection;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorDecorator;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends EvaluationVisitorDecorator<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private static IDebugAST debug;
    private static final Object UNDEFINED_QUERY_RESULT;
    private static final String SELF_VARIABLE_NAME = "self";
    private static final String UNDEFINED_GUARD_MESSAGE_KEY = "AcceleoEvaluationVisitor.UndefinedGuard";
    private final AcceleoEvaluationContext context;
    private EObject lastEObjectSelfValue;
    private OCLExpression<C> lastSourceExpression;
    private Object lastSourceExpressionResult;
    private final Object oclInvalid = this.getEnvironment().getOCLStandardLibrary().getOclInvalid();
    private final Map<Query, Map<List<Object>, Object>> queryResults = new HashMap<Query, Map<List<Object>, Object>>();

    static {
        UNDEFINED_QUERY_RESULT = new Object();
    }

    public AcceleoEvaluationVisitor(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> decoratedVisitor, AcceleoEvaluationContext context) {
        super(decoratedVisitor);
        this.context = context;
    }

    public static void setDebug(IDebugAST acceleoDebug) {
        debug = acceleoDebug;
    }

    public void visitAcceleoBlock(Block block) {
        for (OCLExpression nested : block.getBody()) {
            this.visitExpression(nested);
        }
    }

    public void visitAcceleoFileBlock(FileBlock fileBlock) {
        boolean appendMode;
        Object fileURLResult = this.visitExpression((OCLExpression<C>)fileBlock.getFileUrl());
        if (this.isUndefined(fileURLResult)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedFileURL", fileBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)fileBlock)).getName(), fileBlock.toString(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        if (fileURLResult instanceof Collection) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.CollectionFileURL", fileBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)fileBlock)).getName(), fileBlock.toString(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        String filePath = String.valueOf(fileURLResult);
        boolean bl = appendMode = fileBlock.getOpenMode().getValue() == 0;
        if ("stdout".equals(filePath)) {
            this.context.openNested(System.out);
        } else {
            Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
            EObject source = currentSelf instanceof EObject ? (EObject)currentSelf : this.lastEObjectSelfValue;
            this.context.openNested(filePath, (Block)fileBlock, source, appendMode);
        }
        for (OCLExpression nested : fileBlock.getBody()) {
            this.visitExpression(nested);
        }
        this.context.closeContext();
    }

    public void visitAcceleoForBlock(ForBlock forBlock) {
        Object iteration = this.visitExpression((OCLExpression<C>)forBlock.getIterSet());
        Variable loopVariable = forBlock.getLoopVariable();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(iteration)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.NullForIteration", forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock.toString(), currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (iteration instanceof Collection) {
            if (((Collection)iteration).size() > 0 && forBlock.getBefore() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getBefore());
            }
            Iterator contentIterator = ((Collection)iteration).iterator();
            while (contentIterator.hasNext()) {
                Object o = contentIterator.next();
                this.getEvaluationEnvironment().replace(loopVariable.getName(), o);
                this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, o);
                Object guardValue = forBlock.getGuard() == null ? Boolean.TRUE : this.visitExpression((OCLExpression<C>)forBlock.getGuard());
                if (this.isUndefined(guardValue)) {
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock, o, forBlock.getGuard()));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (!((Boolean)guardValue).booleanValue()) continue;
                for (OCLExpression nested : forBlock.getBody()) {
                    this.visitExpression(nested);
                }
                if (forBlock.getEach() == null || !contentIterator.hasNext()) continue;
                this.visitExpression((OCLExpression<C>)forBlock.getEach());
            }
            if (((Collection)iteration).size() > 0 && forBlock.getAfter() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getAfter());
            }
        } else {
            if (forBlock.getBefore() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getBefore());
            }
            this.getEvaluationEnvironment().replace(loopVariable.getName(), iteration);
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, iteration);
            Object guardValue = forBlock.getGuard() == null ? Boolean.TRUE : this.visitExpression((OCLExpression<C>)forBlock.getGuard());
            if (this.isUndefined(guardValue)) {
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, forBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)forBlock)).getName(), forBlock, iteration, forBlock.getGuard()));
                exception.fillInStackTrace();
                throw exception;
            }
            if (((Boolean)guardValue).booleanValue()) {
                for (OCLExpression nested : forBlock.getBody()) {
                    this.visitExpression(nested);
                }
            }
            if (forBlock.getAfter() != null) {
                this.visitExpression((OCLExpression<C>)forBlock.getAfter());
            }
        }
        this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, currentSelf);
    }

    public void visitAcceleoIfBlock(IfBlock ifBlock) {
        org.eclipse.ocl.ecore.OCLExpression condition = ifBlock.getIfExpr();
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        Object conditionValue = this.visitExpression((OCLExpression<C>)condition);
        if (this.isUndefined(conditionValue)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedCondition", ifBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)ifBlock)).getName(), ifBlock, currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (((Boolean)conditionValue).booleanValue()) {
            for (OCLExpression nested : ifBlock.getBody()) {
                this.visitExpression(nested);
            }
        } else if (ifBlock.getElseIf().size() > 0) {
            IfBlock temp = null;
            for (IfBlock elseif : ifBlock.getElseIf()) {
                Object elseValue = this.visitExpression((OCLExpression<C>)elseif.getIfExpr());
                if (this.isUndefined(elseValue)) {
                    String rootName = ((Module)EcoreUtil.getRootContainer((EObject)elseif)).getName();
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedElseCondition", elseif.getStartPosition(), rootName, elseif, currentSelf));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (!((Boolean)elseValue).booleanValue()) continue;
                temp = elseif;
                break;
            }
            if (temp != null) {
                for (OCLExpression nested : temp.getBody()) {
                    this.visitExpression(nested);
                }
            } else if (ifBlock.getElse() != null) {
                this.visitAcceleoBlock(ifBlock.getElse());
            }
        } else if (ifBlock.getElse() != null) {
            this.visitAcceleoBlock(ifBlock.getElse());
        }
    }

    public void visitAcceleoLetBlock(LetBlock letBlock) {
        Object currentSelf = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        Variable var = letBlock.getLetVariable();
        Object value = this.visitExpression(var.getInitExpression());
        if (this.isUndefined(value)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedLetValue", letBlock.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)letBlock)).getName(), letBlock, currentSelf));
            exception.fillInStackTrace();
            throw exception;
        }
        if (((EClassifier)var.getType()).isInstance(value)) {
            this.getEvaluationEnvironment().replace(var.getName(), value);
            for (OCLExpression nested : letBlock.getBody()) {
                this.visitExpression(nested);
            }
        } else if (letBlock.getElseLet().size() > 0) {
            LetBlock temp = null;
            for (LetBlock elseLet : letBlock.getElseLet()) {
                var = elseLet.getLetVariable();
                value = this.visitExpression(var.getInitExpression());
                if (this.isUndefined(value)) {
                    String rootName = ((Module)EcoreUtil.getRootContainer((EObject)elseLet)).getName();
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedElseLetValue", elseLet.getStartPosition(), rootName, elseLet, currentSelf));
                    exception.fillInStackTrace();
                    throw exception;
                }
                if (!((EClassifier)var.getType()).isInstance(value)) continue;
                this.getEvaluationEnvironment().replace(var.getName(), value);
                temp = elseLet;
                break;
            }
            if (temp != null) {
                for (OCLExpression nested : temp.getBody()) {
                    this.visitExpression(nested);
                }
            } else if (letBlock.getElse() != null) {
                this.visitAcceleoBlock(letBlock.getElse());
            }
        } else if (letBlock.getElse() != null) {
            this.visitAcceleoBlock(letBlock.getElse());
        }
    }

    public void visitAcceleoProtectedArea(ProtectedAreaBlock protectedArea) {
        Object markerValue = this.visitExpression((OCLExpression<C>)protectedArea.getMarker());
        Object source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
        if (this.isUndefined(markerValue)) {
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedAreaMarker", protectedArea.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)protectedArea)).getName(), protectedArea, source));
            exception.fillInStackTrace();
            throw exception;
        }
        String marker = markerValue.toString().trim();
        String areaContent = this.context.getProtectedAreaContent(marker);
        if (source instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        if (areaContent != null) {
            this.context.append(areaContent, (Block)protectedArea, this.lastEObjectSelfValue);
        } else {
            this.context.append(AcceleoEngineMessages.getString("usercode.start"), (Block)protectedArea, this.lastEObjectSelfValue);
            this.context.append(String.valueOf(' ') + marker, (Block)protectedArea, this.lastEObjectSelfValue);
            this.visitAcceleoBlock((Block)protectedArea);
            this.context.append(AcceleoEngineMessages.getString("usercode.end"), (Block)protectedArea, this.lastEObjectSelfValue);
        }
    }

    public Object visitAcceleoQueryInvocation(QueryInvocation invocation) {
        Map<Object, Object> results;
        Query query = invocation.getDefinition();
        ArrayList<Object> arguments = new ArrayList<Object>();
        int i = 0;
        while (i < query.getParameter().size()) {
            Object argValue = this.visitExpression((OCLExpression)invocation.getArgument().get(i));
            if (this.isUndefined(argValue)) {
                String rootName = ((Module)EcoreUtil.getRootContainer((EObject)invocation)).getName();
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedArgument", invocation.getStartPosition(), rootName, invocation, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), invocation.getArgument().get(i)));
                exception.fillInStackTrace();
                throw exception;
            }
            arguments.add(argValue);
            ++i;
        }
        if (this.queryResults.containsKey(query)) {
            Map<List<Object>, Object> results2 = this.queryResults.get(query);
            Object result = results2.get(arguments);
            if (result == UNDEFINED_QUERY_RESULT) {
                String rootName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", query.getExpression(), invocation.getStartPosition(), rootName, query, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
                exception.fillInStackTrace();
                throw exception;
            }
            if (result != null) {
                return result;
            }
        }
        Object[] oldArgs = new Object[invocation.getArgument().size() + 1];
        int i2 = 0;
        while (i2 < query.getParameter().size()) {
            Variable param = (Variable)query.getParameter().get(i2);
            oldArgs[i2] = this.getEvaluationEnvironment().getValueOf(param.getName());
            this.getEvaluationEnvironment().replace(param.getName(), arguments.get(i2));
            if (i2 == 0) {
                oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, arguments.get(i2));
            }
            ++i2;
        }
        Object result = this.visitExpression((OCLExpression<C>)query.getExpression());
        int i3 = 0;
        while (i3 < query.getParameter().size()) {
            Variable param = (Variable)query.getParameter().get(i3);
            if (oldArgs[i3] != null) {
                this.getEvaluationEnvironment().replace(param.getName(), oldArgs[i3]);
            } else {
                this.getEvaluationEnvironment().remove(param.getName());
            }
            ++i3;
        }
        if (query.getParameter().size() > 0) {
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, oldArgs[oldArgs.length - 1]);
        }
        if (this.queryResults.containsKey(query)) {
            results = this.queryResults.get(query);
            if (this.isUndefined(result)) {
                results.put(arguments, UNDEFINED_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
        } else {
            results = new HashMap(2);
            if (this.isUndefined(result)) {
                results.put(arguments, UNDEFINED_QUERY_RESULT);
            } else {
                results.put(arguments, result);
            }
            this.queryResults.put(query, results);
        }
        if (this.isUndefined(result)) {
            String rootName = ((Module)EcoreUtil.getRootContainer((EObject)query)).getName();
            AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedQuery", query.getExpression(), invocation.getStartPosition(), rootName, query, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)));
            exception.fillInStackTrace();
            throw exception;
        }
        return result;
    }

    public String visitAcceleoTemplate(Template template) {
        this.context.openNested();
        for (OCLExpression nested : template.getBody()) {
            this.visitExpression(nested);
        }
        return this.context.closeContext();
    }

    public Object visitAcceleoTemplateInvocation(TemplateInvocation invocation) {
        Object source;
        Variable param;
        Object[] oldArgs;
        Template actualTemplate;
        this.context.openNested();
        Template template = invocation.getDefinition();
        ArrayList<Object> newArguments = new ArrayList<Object>();
        if (invocation.isSuper()) {
            Template containingTemplate = (Template)invocation.eContainer();
            actualTemplate = containingTemplate.eContainer() instanceof TemplateInvocation ? ((TemplateInvocation)containingTemplate.eContainer()).getDefinition() : (Template)template.getOverrides().get(0);
            oldArgs = new Object[containingTemplate.getParameter().size() + 1];
            int i = 0;
            while (i < actualTemplate.getParameter().size()) {
                param = (Variable)actualTemplate.getParameter().get(i);
                oldArgs[i] = this.getEvaluationEnvironment().getValueOf(param.getName());
                Object newArg = this.getEvaluationEnvironment().getValueOf(((Variable)containingTemplate.getParameter().get(i)).getName());
                this.getEvaluationEnvironment().replace(param.getName(), newArg);
                newArguments.add(newArg);
                if (i == 0) {
                    oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, newArg);
                }
                ++i;
            }
        } else {
            oldArgs = new Object[invocation.getArgument().size() + 1];
            for (OCLExpression expression : invocation.getArgument()) {
                Object argValue = this.visitExpression(expression);
                if (this.isUndefined(argValue)) {
                    AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedArgument", invocation.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)invocation)).getName(), invocation, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), expression));
                    exception.fillInStackTrace();
                    throw exception;
                }
                newArguments.add(argValue);
            }
            List<Template> applicableCandidates = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getAllCandidates((Module)EcoreUtil.getRootContainer((EObject)invocation), template, newArguments);
            this.evaluateGuards(applicableCandidates, newArguments);
            if (applicableCandidates.size() > 0) {
                actualTemplate = ((AcceleoEvaluationEnvironment)this.getEvaluationEnvironment()).getMostSpecificTemplate(applicableCandidates, newArguments);
                int i = 0;
                while (i < actualTemplate.getParameter().size()) {
                    param = (Variable)actualTemplate.getParameter().get(i);
                    oldArgs[i] = this.getEvaluationEnvironment().getValueOf(param.getName());
                    this.getEvaluationEnvironment().replace(param.getName(), newArguments.get(i));
                    if (i == 0) {
                        oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                        this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, newArguments.get(i));
                    }
                    ++i;
                }
            } else {
                actualTemplate = MtlFactory.eINSTANCE.createTemplate();
            }
        }
        if (invocation.getBefore() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getBefore());
        }
        if ((source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME)) instanceof EObject) {
            this.lastEObjectSelfValue = (EObject)source;
        }
        this.context.append(this.visitExpression((OCLExpression<C>)actualTemplate).toString(), (Block)actualTemplate, this.lastEObjectSelfValue);
        if (invocation.getAfter() != null) {
            this.visitExpression((OCLExpression<C>)invocation.getAfter());
        }
        int i = 0;
        while (i < actualTemplate.getParameter().size()) {
            param = (Variable)actualTemplate.getParameter().get(i);
            this.getEvaluationEnvironment().replace(param.getName(), oldArgs[i]);
            ++i;
        }
        if (actualTemplate.getParameter().size() > 0) {
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, oldArgs[oldArgs.length - 1]);
        }
        return this.context.closeContext();
    }

    public Object visitExpression(OCLExpression<C> expression) {
        Object result;
        block37: {
            result = null;
            EObject debugInput = null;
            ASTFragment astFragment = null;
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                Object name;
                debugInput = this.lastEObjectSelfValue;
                astFragment = new ASTFragment(expression);
                if (debugInput != null && debugInput.eClass().getEStructuralFeature("name") != null && (name = debugInput.eGet(debugInput.eClass().getEStructuralFeature("name"))) instanceof String) {
                    astFragment.setEObjectNameFilter((String)name);
                }
                debug.startDebug(astFragment);
                debug.stepDebugInput(astFragment, debugInput);
            }
            try {
                boolean hasInit;
                boolean bl = hasInit = expression instanceof Block && ((Block)expression).getInit() != null;
                if (hasInit) {
                    this.handleAcceleoInitSection(((Block)expression).getInit());
                }
                if (expression instanceof Template) {
                    result = this.visitAcceleoTemplate((Template)expression);
                } else if (expression instanceof IfBlock) {
                    this.visitAcceleoIfBlock((IfBlock)expression);
                    result = "";
                } else if (expression instanceof ForBlock) {
                    this.visitAcceleoForBlock((ForBlock)expression);
                    result = "";
                } else if (expression instanceof FileBlock) {
                    this.visitAcceleoFileBlock((FileBlock)expression);
                    result = "";
                } else if (expression instanceof TemplateInvocation) {
                    result = this.visitAcceleoTemplateInvocation((TemplateInvocation)expression);
                } else if (expression instanceof QueryInvocation) {
                    result = this.visitAcceleoQueryInvocation((QueryInvocation)expression);
                } else if (expression instanceof LetBlock) {
                    this.visitAcceleoLetBlock((LetBlock)expression);
                    result = "";
                } else if (expression instanceof ProtectedAreaBlock) {
                    this.visitAcceleoProtectedArea((ProtectedAreaBlock)expression);
                    result = "";
                } else {
                    result = super.visitExpression(expression);
                }
                if (expression == this.lastSourceExpression) {
                    this.lastSourceExpressionResult = result;
                }
                if (this.shouldGenerateText((EReference)expression.eContainingFeature())) {
                    Object source = null;
                    EObject generatedBlock = expression;
                    while (!(generatedBlock instanceof Block)) {
                        generatedBlock = generatedBlock.eContainer();
                    }
                    if (this.lastSourceExpressionResult == null) {
                        source = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    } else {
                        source = this.lastSourceExpressionResult;
                        this.lastSourceExpressionResult = null;
                    }
                    if (source instanceof EObject) {
                        this.lastEObjectSelfValue = (EObject)source;
                    }
                    this.context.append(String.valueOf(result), (Block)generatedBlock, this.lastEObjectSelfValue);
                }
                if (hasInit) {
                    this.restoreVariables();
                }
            }
            catch (AcceleoEvaluationException e) {
                AcceleoEnginePlugin.log(e, false);
                if (debug != null && !(expression instanceof StringLiteralExp)) {
                    debug.stepDebugOutput(astFragment, debugInput, result);
                    debug.endDebug(astFragment);
                }
                break block37;
            }
            catch (RuntimeException e) {
                try {
                    try {
                        this.context.dispose();
                    }
                    catch (AcceleoEvaluationException acceleoEvaluationException) {}
                    throw e;
                }
                catch (Throwable throwable) {
                    if (debug != null && !(expression instanceof StringLiteralExp)) {
                        debug.stepDebugOutput(astFragment, debugInput, result);
                        debug.endDebug(astFragment);
                    }
                    throw throwable;
                }
            }
            if (debug != null && !(expression instanceof StringLiteralExp)) {
                debug.stepDebugOutput(astFragment, debugInput, result);
                debug.endDebug(astFragment);
            }
        }
        return result;
    }

    public Object visitOperationCallExp(OperationCallExp<C, O> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return super.visitOperationCallExp(callExp);
    }

    public Object visitPropertyCallExp(PropertyCallExp<C, P> callExp) {
        this.lastSourceExpression = callExp.getSource();
        return super.visitPropertyCallExp(callExp);
    }

    private void evaluateGuards(List<Template> candidates, List<Object> arguments) {
        AcceleoEvaluationException exception = null;
        for (Template candidate : new ArrayList<Template>(candidates)) {
            Object[] oldArgs = new Object[candidate.getParameter().size() + 1];
            int i = 0;
            while (i < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i);
                oldArgs[i] = this.getEvaluationEnvironment().getValueOf(param.getName());
                this.getEvaluationEnvironment().replace(param.getName(), arguments.get(i));
                if (i == 0) {
                    oldArgs[oldArgs.length - 1] = this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME);
                    this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, arguments.get(i));
                }
                ++i;
            }
            Object guardValue = candidate.getGuard() == null ? Boolean.TRUE : this.visitExpression((OCLExpression<C>)candidate.getGuard());
            if (this.isUndefined(guardValue)) {
                exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString(UNDEFINED_GUARD_MESSAGE_KEY, candidate.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)candidate)).getName(), candidate, this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), candidate.getGuard()));
                exception.fillInStackTrace();
                candidates.remove(candidate);
                continue;
            }
            if (!((Boolean)guardValue).booleanValue()) {
                candidates.remove(candidate);
            }
            int i2 = 0;
            while (i2 < candidate.getParameter().size()) {
                Variable param = (Variable)candidate.getParameter().get(i2);
                this.getEvaluationEnvironment().replace(param.getName(), oldArgs[i2]);
                ++i2;
            }
            if (candidate.getParameter().size() <= 0) continue;
            this.getEvaluationEnvironment().replace(SELF_VARIABLE_NAME, oldArgs[oldArgs.length - 1]);
        }
        if (candidates.size() == 0 && exception != null) {
            throw exception;
        }
    }

    private void handleAcceleoInitSection(InitSection init) {
        HashMap<String, Object> oldVariables = new HashMap<String, Object>(init.getVariable().size());
        for (Variable var : init.getVariable()) {
            String varName = var.getName();
            Object oldValue = this.getEvaluationEnvironment().getValueOf(varName);
            oldVariables.put(varName, oldValue);
            Object newValue = this.visitExpression(var.getInitExpression());
            if (this.isUndefined(newValue)) {
                AcceleoEvaluationException exception = new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEvaluationVisitor.UndefinedVariable", var.getStartPosition(), ((Module)EcoreUtil.getRootContainer((EObject)init)).getName(), init.eContainer(), this.getEvaluationEnvironment().getValueOf(SELF_VARIABLE_NAME), var));
                exception.fillInStackTrace();
                throw exception;
            }
            this.getEvaluationEnvironment().replace(varName, newValue);
        }
        this.context.saveVariableValues(oldVariables);
    }

    private boolean isUndefined(Object value) {
        return value == null || value == this.oclInvalid;
    }

    private void restoreVariables() {
        Map<String, Object> variables = this.context.getLastVariablesValues();
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.getEvaluationEnvironment().replace(entry.getKey(), entry.getValue());
        }
    }

    private boolean shouldGenerateText(EReference reference) {
        boolean generate = reference == MtlPackage.eINSTANCE.getBlock_Body();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Each();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getForBlock_After();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_Before();
        generate = generate || reference == MtlPackage.eINSTANCE.getTemplateInvocation_After();
        return generate;
    }
}

