/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import java.util.ArrayList;
import org.eclipse.acceleo.internal.ide.ui.editors.template.ColorManager;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.SequenceBlockRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoWhitespaceDetector;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.IAcceleoColorConstants;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class AcceleoQueryScanner
extends AbstractAcceleoScanner {
    public AcceleoQueryScanner(ColorManager manager) {
        ArrayList<SequenceBlockRule> rules = new ArrayList<SequenceBlockRule>();
        rules.add(new SequenceBlockRule((ISequenceRule)new KeywordRule("'"), (ISequenceRule)new KeywordRule("'"), new KeywordRule("\\'"), (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.LITERAL)))));
        rules.add((SequenceBlockRule)new WhitespaceRule((IWhitespaceDetector)new AcceleoWhitespaceDetector()));
        rules.add((SequenceBlockRule)this.computeDelimiterRule("[", manager));
        rules.add((SequenceBlockRule)this.computeDelimiterRule("]", manager));
        rules.add((SequenceBlockRule)this.computeDelimiterRule("/", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("query", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("self", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("public", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("protected", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("private", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("if", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("then", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("else", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("endif", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("and", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("or", manager));
        rules.add((SequenceBlockRule)this.computeKeywordRule("not", manager));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.DEFAULT))));
    }

    private IRule computeKeywordRule(String keyword, ColorManager manager) {
        return new KeywordRule(keyword, true, false, (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.QUERY), null, 1)));
    }

    private IRule computeDelimiterRule(String delimiter, ColorManager manager) {
        return new KeywordRule(delimiter, false, false, (IToken)new Token((Object)new TextAttribute(manager.getColor(IAcceleoColorConstants.QUERY), null, 1)));
    }

    public String getConfiguredContentType() {
        return "__ACCELEO_query";
    }
}

