/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.WorskpaceMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MModelURIMapFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MModelURIMapPackage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class QvtMetamodelMappingPage
extends PropertyPage {
    private TableViewer myTableViewer;
    private IProject myProject;
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private Button removeAllButton;
    private MappingContainer uriMap;
    private Map<URIMapping, ProblemInfo> uriProblems;
    private IStatus status = Status.OK_STATUS;

    public boolean performOk() {
        this.performApply();
        return this.status.isOK();
    }

    protected void performApply() {
        if (this.uriMap != null) {
            try {
                this.status = Status.OK_STATUS;
                Resource res = this.uriMap.eResource();
                res.save(null);
                this.doValidatePage();
            }
            catch (IOException e) {
                this.setErrorMessage(Messages.QvtMetamodelMappingPage_saveIOError);
                this.status = new Status(4, "org.eclipse.m2m.qvt.oml.ui", this.getErrorMessage(), (Throwable)e);
                QVTUIPlugin.log(this.status);
                return;
            }
        }
        if (this.myProject != null) {
            try {
                IFile mappingFile = MetamodelURIMappingHelper.getMappingFileHandle((IProject)this.myProject);
                mappingFile.refreshLocal(0, null);
            }
            catch (CoreException e) {
                QVTUIPlugin.log(e.getStatus());
            }
        }
    }

    protected void performDefaults() {
        if (this.uriMap != null) {
            this.load();
        }
    }

    protected boolean doValidatePage() {
        boolean valid;
        this.setMessage(null);
        this.setErrorMessage(null);
        boolean bl = valid = this.uriProblems == null || this.uriProblems.isEmpty();
        if (!valid) {
            this.setErrorMessage(Messages.QvtMetamodelMappingPage_invalidItemsInMappingTable);
        }
        return valid;
    }

    protected Control createContents(Composite parent) {
        IProject project = this.getSelectedProject();
        if (project == null) {
            this.setValid(false);
            this.setErrorMessage(Messages.QvtMetamodelMappingPage_no_QVT_projectSelected);
            return new Composite(parent, 2048);
        }
        Composite containerGroup = new Composite(parent, 2048);
        GridLayout containerLayout = new GridLayout(1, true);
        containerLayout.marginWidth = 5;
        containerLayout.marginHeight = 5;
        containerGroup.setLayout((Layout)containerLayout);
        int style = 68356;
        this.myTableViewer = new TableViewer(containerGroup, style);
        GridData gridData = new GridData(1808);
        this.myTableViewer.getControl().setLayoutData((Object)gridData);
        this.myTableViewer.setContentProvider((IContentProvider)new Contents());
        this.myTableViewer.setLabelProvider((IBaseLabelProvider)new Labels());
        Table table = this.myTableViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumn(table, layout, Messages.QvtMetamodelMappingPage_sourceURILabel);
        this.createColumn(table, layout, Messages.QvtMetamodelMappingPage_targetURILabel);
        this.createButtons(containerGroup);
        this.myTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean hasSelection = !event.getSelection().isEmpty();
                QvtMetamodelMappingPage.this.removeButton.setEnabled(hasSelection);
                QvtMetamodelMappingPage.this.editButton.setEnabled(hasSelection);
                ProblemInfo problemInfo = QvtMetamodelMappingPage.this.getProblemInfo(QvtMetamodelMappingPage.this.getSelectedElement());
                if (hasSelection && problemInfo != null && !problemInfo.isOK()) {
                    QvtMetamodelMappingPage.this.setErrorMessage(problemInfo.summaryMessage());
                } else {
                    QvtMetamodelMappingPage.this.doValidatePage();
                }
            }
        });
        this.myTableViewer.getTable().addMouseTrackListener((MouseTrackListener)new MouseTracker());
        this.load();
        return containerGroup;
    }

    private void createButtons(Composite composite) {
        Composite buttonArea = new Composite(composite, 0);
        buttonArea.setLayoutData((Object)new GridData(132));
        GridLayout layout = new GridLayout(4, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonArea.setLayout((Layout)layout);
        GridData data = new GridData(8);
        buttonArea.setLayoutData((Object)data);
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setFont(composite.getFont());
        this.setButtonLayoutData(this.addButton);
        this.addButton.setText(Messages.QvtMetamodelMappingPage_addBtnLabel);
        this.addButton.addSelectionListener((SelectionListener)new AddListener());
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setEnabled(false);
        this.editButton.setFont(composite.getFont());
        this.editButton.setText(Messages.QvtMetamodelMappingPage_editBtnLabel);
        this.editButton.addSelectionListener((SelectionListener)new EditListener());
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.setFont(composite.getFont());
        this.removeButton.setText(Messages.QvtMetamodelMappingPage_removeBtnLabel);
        this.removeButton.addSelectionListener((SelectionListener)new RemoveListener());
        this.setButtonLayoutData(this.removeButton);
        this.removeAllButton = new Button(buttonArea, 8);
        this.removeAllButton.setFont(composite.getFont());
        this.removeAllButton.setText(Messages.QvtMetamodelMappingPage_removeAllBtnLabel);
        this.removeAllButton.addSelectionListener((SelectionListener)new RemoveAllListener());
        this.setButtonLayoutData(this.editButton);
    }

    private IProject getSelectedProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        if (element instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)element;
            return javaProject.getProject();
        }
        return null;
    }

    private static EPackage loadEPackage(String uriStr) {
        try {
            return WorskpaceMetamodelProvider.loadResourceMetamodel((String)uriStr);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private void createColumn(Table table, TableLayout layout, String name) {
        TableColumn nameColumn = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        nameColumn.setText(name);
    }

    private void loadMappings() {
        assert (this.myTableViewer != null);
        MModelURIMapPackage.eINSTANCE.getNsURI();
        Resource res = MetamodelURIMappingHelper.createMappingResource((IProject)this.getSelectedProject());
        try {
            this.status = Status.OK_STATUS;
            if (MetamodelURIMappingHelper.hasMappingResource((IProject)this.getSelectedProject())) {
                res.load(null);
            }
        }
        catch (IOException e) {
            this.setErrorMessage(Messages.QvtMetamodelMappingPage_loadIOError);
            this.status = new Status(4, "org.eclipse.m2m.qvt.oml.ui", this.getErrorMessage(), (Throwable)e);
            QVTUIPlugin.log(this.status);
        }
        if (res.getContents().isEmpty()) {
            this.uriMap = MetamodelURIMappingHelper.createNewMappings((Resource)res);
            if (!super.isValid()) {
                return;
            }
        } else {
            this.uriMap = MetamodelURIMappingHelper.getMappings((Resource)res);
            EObject root = (EObject)res.getContents().get(0);
            if (root instanceof MappingContainer) {
                this.uriMap = (MappingContainer)root;
            }
        }
        this.uriProblems = null;
        if (this.status.isOK()) {
            int pos = 0;
            for (URIMapping nextMapping : this.uriMap.getMapping()) {
                IStatus sourceStatus = QvtMetamodelMappingPage.validateURI(nextMapping.getSourceURI(), Messages.QvtMetamodelMappingPage_sourceURILabel);
                IStatus targetStatus = QvtMetamodelMappingPage.validateTargetMappingURI(nextMapping.getTargetURI());
                if (sourceStatus.isOK()) {
                    sourceStatus = this.getSourceUriAlreadyExistsStatus(nextMapping.getSourceURI(), pos++);
                }
                if (sourceStatus.isOK() && targetStatus.isOK()) continue;
                if (this.uriProblems == null) {
                    this.uriProblems = new IdentityHashMap<URIMapping, ProblemInfo>();
                }
                this.uriProblems.put(nextMapping, new ProblemInfo(sourceStatus, targetStatus));
            }
            this.doValidatePage();
        }
    }

    private IStatus getSourceUriAlreadyExistsStatus(String uri, int upToIndex) {
        if (uri != null && this.uriMap != null) {
            int pos = 0;
            for (URIMapping mapping : this.uriMap.getMapping()) {
                if (upToIndex >= 0 && pos++ == upToIndex) break;
                if (!uri.equals(mapping.getSourceURI())) continue;
                String message = Messages.QvtMetamodelMappingPage_URIAlreadyMapped;
                return new Status(4, "org.eclipse.m2m.qvt.oml.ui", NLS.bind((String)message, (Object)uri));
            }
        }
        return Status.OK_STATUS;
    }

    private static IStatus validateURI(String uriStr, String uriLabel) {
        if (uriStr == null || uriStr.trim().length() == 0) {
            String message = NLS.bind((String)Messages.QvtMetamodelMappingPage_noURISpecified, (Object)uriLabel);
            return new Status(4, "org.eclipse.m2m.qvt.oml.ui", message);
        }
        try {
            URI.createURI((String)uriStr);
        }
        catch (IllegalArgumentException e) {
            String message = NLS.bind((String)Messages.QvtMetamodelMappingPage_invalidModelURI, (Object)uriLabel);
            return new Status(4, "org.eclipse.m2m.qvt.oml.ui", String.valueOf(message) + ":" + e.getLocalizedMessage());
        }
        return Status.OK_STATUS;
    }

    private static IStatus validateTargetMappingURI(String uriStr) {
        URI targetUri;
        IStatus status = QvtMetamodelMappingPage.validateURI(uriStr, Messages.QvtMetamodelMappingPage_targetURILabel);
        if (status.isOK() && !(targetUri = URI.createURI((String)uriStr)).isPlatformResource()) {
            String message = NLS.bind((String)Messages.QvtMetamodelMappingPage_platformResourceURIexpected, (Object)Messages.QvtMetamodelMappingPage_targetURILabel);
            status = new Status(4, "org.eclipse.m2m.qvt.oml.ui", message);
        }
        if (status.isOK() && QvtMetamodelMappingPage.loadEPackage(uriStr) == null) {
            String message = NLS.bind((String)Messages.QvtMetamodelMappingPage_loadResourceMetamodelError, (Object)uriStr);
            status = new Status(4, "org.eclipse.m2m.qvt.oml.ui", message);
        }
        return status;
    }

    private void load() {
        this.myProject = this.getSelectedProject();
        if (this.myProject != null) {
            this.loadMappings();
            if (this.uriMap != null && this.myTableViewer != null) {
                this.myTableViewer.setInput((Object)this.uriMap);
            }
        }
    }

    private ProblemInfo getProblemInfo(URIMapping mapping) {
        return this.uriProblems != null ? this.uriProblems.get(mapping) : null;
    }

    private URIMapping getSelectedElement() {
        ISelection sel = this.myTableViewer.getSelection();
        if (!sel.isEmpty()) {
            return (URIMapping)((IStructuredSelection)sel).getFirstElement();
        }
        return null;
    }

    private class AddListener
    extends SelectionAdapter {
        private AddListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            URIMapping mapping;
            URIMappingDialog dlg = new URIMappingDialog(QvtMetamodelMappingPage.this.getShell());
            if (dlg.open() == 0 && (mapping = dlg.data) != null) {
                QvtMetamodelMappingPage.this.uriMap.getMapping().add((Object)mapping);
                QvtMetamodelMappingPage.this.myTableViewer.add((Object)mapping);
                QvtMetamodelMappingPage.this.doValidatePage();
            }
        }
    }

    private static class Contents
    implements IStructuredContentProvider {
        private Contents() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof MappingContainer) {
                return ((MappingContainer)inputElement).getMapping().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class EditListener
    extends SelectionAdapter {
        private EditListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            URIMapping mapping = QvtMetamodelMappingPage.this.getSelectedElement();
            if (mapping != null && new URIMappingDialog(QvtMetamodelMappingPage.this.getShell(), mapping).open() == 0) {
                if (QvtMetamodelMappingPage.this.uriProblems != null) {
                    QvtMetamodelMappingPage.this.uriProblems.remove(mapping);
                }
                QvtMetamodelMappingPage.this.myTableViewer.refresh();
                QvtMetamodelMappingPage.this.doValidatePage();
            }
        }
    }

    private class Labels
    extends LabelProvider
    implements ITableLabelProvider {
        private Labels() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof URIMapping) {
                URIMapping mapping = (URIMapping)element;
                return columnIndex == 0 ? mapping.getSourceURI() : mapping.getTargetURI();
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!(element instanceof URIMapping)) {
                return null;
            }
            URIMapping mapping = (URIMapping)element;
            ProblemInfo problemInfo = QvtMetamodelMappingPage.this.getProblemInfo(mapping);
            if (problemInfo != null && !problemInfo.isOK()) {
                IStatus status = columnIndex == 0 ? problemInfo.sourceUriStatus : problemInfo.targetUriStatus;
                String imageName = status.isOK() ? null : "IMG_OBJS_INFO_TSK";
                switch (status.getSeverity()) {
                    case 4: {
                        imageName = "IMG_OBJS_ERROR_TSK";
                        break;
                    }
                    case 2: {
                        imageName = "IMG_OBJS_ERROR_TSK";
                    }
                }
                if (imageName != null) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
                }
            }
            return null;
        }
    }

    private class MouseTracker
    implements MouseTrackListener {
        private MouseTracker() {
        }

        public void mouseExit(MouseEvent e) {
            this.resetToolTip();
        }

        public void mouseEnter(MouseEvent e) {
            this.resetToolTip();
        }

        public void mouseHover(MouseEvent e) {
            TableItem item = QvtMetamodelMappingPage.this.myTableViewer.getTable().getItem(new Point(e.x, e.y));
            if (item != null) {
                ProblemInfo problemInfo = QvtMetamodelMappingPage.this.getProblemInfo((URIMapping)item.getData());
                if (problemInfo != null) {
                    String tooltip = this.buildTooltipText(problemInfo);
                    QvtMetamodelMappingPage.this.myTableViewer.getControl().setToolTipText(tooltip);
                }
            } else {
                this.resetToolTip();
            }
        }

        void resetToolTip() {
            QvtMetamodelMappingPage.this.myTableViewer.getControl().setToolTipText(null);
        }

        String buildTooltipText(ProblemInfo problemInfo) {
            StringBuilder buf = new StringBuilder();
            if (!problemInfo.sourceUriStatus.isOK()) {
                buf.append("<b>Source</b> URI:").append('\n');
                buf.append('-').append(problemInfo.sourceUriStatus.getMessage());
            }
            if (!problemInfo.targetUriStatus.isOK()) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append("Target URI:").append('\n');
                buf.append('-').append(problemInfo.targetUriStatus.getMessage());
            }
            return buf.toString();
        }
    }

    private static class ProblemInfo {
        final IStatus sourceUriStatus;
        final IStatus targetUriStatus;

        ProblemInfo(IStatus sourceUriStatus, IStatus targetUriStatus) {
            if (sourceUriStatus == null || targetUriStatus == null) {
                throw new NullPointerException();
            }
            this.sourceUriStatus = sourceUriStatus;
            this.targetUriStatus = targetUriStatus;
        }

        boolean isOK() {
            return this.sourceUriStatus.isOK() && this.targetUriStatus.isOK();
        }

        String summaryMessage() {
            return this.targetUriStatus.isOK() ? this.sourceUriStatus.getMessage() : this.targetUriStatus.getMessage();
        }
    }

    private class RemoveAllListener
    extends SelectionAdapter {
        private RemoveAllListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            QvtMetamodelMappingPage.this.myTableViewer.setItemCount(0);
            QvtMetamodelMappingPage.this.uriMap.getMapping().clear();
            if (QvtMetamodelMappingPage.this.uriProblems != null) {
                QvtMetamodelMappingPage.this.uriProblems.clear();
            }
            QvtMetamodelMappingPage.this.doValidatePage();
        }
    }

    private class RemoveListener
    extends SelectionAdapter {
        private RemoveListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            URIMapping mapping = QvtMetamodelMappingPage.this.getSelectedElement();
            if (mapping != null) {
                QvtMetamodelMappingPage.this.myTableViewer.remove((Object)mapping);
                if (QvtMetamodelMappingPage.this.uriProblems != null) {
                    QvtMetamodelMappingPage.this.uriProblems.remove(mapping);
                }
                QvtMetamodelMappingPage.this.uriMap.getMapping().remove((Object)mapping);
            }
            QvtMetamodelMappingPage.this.doValidatePage();
        }
    }

    private class URIMappingDialog
    extends StatusDialog {
        private URIMapping data;
        private Text modelURIText;
        private Text targetURIText;

        public URIMappingDialog(Shell parent) {
            this(parent, null);
        }

        public URIMappingDialog(Shell parent, URIMapping mappingData) {
            super(parent);
            this.data = mappingData;
            String title = Messages.QvtMetamodelMappingPage_addNewMappingTitle;
            if (this.data != null) {
                title = Messages.QvtMetamodelMappingPage_editMappingTitle;
            } else {
                this.data = MModelURIMapFactory.eINSTANCE.createURIMapping();
            }
            this.setTitle(title);
            this.setHelpAvailable(false);
            this.setStatusLineAboveButtons(true);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.data.setSourceURI(this.modelURIText.getText());
                this.data.setTargetURI(this.targetURIText.getText());
            }
            super.buttonPressed(buttonId);
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.updateStatus(this.getStatus());
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createResourceURIControls(parent, 2);
            if (this.data.eContainer() == null) {
                this.updateStatus(QvtMetamodelMappingPage.validateURI(this.modelURIText.getText(), Messages.QvtMetamodelMappingPage_sourceURILabel));
                this.modelURIText.setFocus();
                this.targetURIText.setText("platform:/resource/*");
            } else {
                this.modelURIText.setText(this.safeURIValue(this.data.getSourceURI()));
                this.targetURIText.setText(this.safeURIValue(this.data.getTargetURI()));
            }
            return composite;
        }

        protected void createResourceURIControls(Composite parent, int columnsPerLine) {
            Composite inner = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            layout.numColumns = 4;
            inner.setLayout((Layout)layout);
            Label sourceURILabel = new Label(inner, 0);
            sourceURILabel.setText(Messages.QvtMetamodelMappingPage_sourceURILabel);
            this.modelURIText = new Text(inner, 2048);
            GridData gd = new GridData(4, 2, true, false);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            gd.horizontalSpan = 3;
            this.modelURIText.setLayoutData((Object)gd);
            this.modelURIText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IStatus status = URIMappingDialog.this.validateSourceURI();
                    if (status.isOK()) {
                        status = QvtMetamodelMappingPage.validateTargetMappingURI(URIMappingDialog.this.targetURIText.getText());
                    }
                    URIMappingDialog.this.updateStatus(status);
                }
            });
            Label targetURILabel = new Label(inner, 0);
            targetURILabel.setText(Messages.QvtMetamodelMappingPage_targetURILabel);
            this.targetURIText = new Text(inner, 2048);
            GridData gd2 = new GridData(4, 2, true, false);
            gd2.widthHint = this.convertWidthInCharsToPixels(40);
            gd2.horizontalSpan = 2;
            this.targetURIText.setLayoutData((Object)gd2);
            this.targetURIText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IStatus status = QvtMetamodelMappingPage.validateTargetMappingURI(URIMappingDialog.this.targetURIText.getText());
                    if (status.isOK()) {
                        if (URIMappingDialog.this.modelURIText.getText() == null || URIMappingDialog.this.modelURIText.getText().length() == 0) {
                            URIMappingDialog.this.modelURIText.setText(QvtMetamodelMappingPage.loadEPackage(URIMappingDialog.this.targetURIText.getText()).getNsURI());
                        }
                        status = URIMappingDialog.this.validateSourceURI();
                    }
                    URIMappingDialog.this.updateStatus(status);
                }
            });
            Button browse = new Button(inner, 8);
            browse.setText(Messages.QvtMetamodelMappingPage_browseWorkspaceBtnLabel);
            GridData bgd = new GridData(3, 2, true, false);
            bgd.horizontalSpan = 1;
            browse.setLayoutData((Object)bgd);
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)URIMappingDialog.this.getShell(), null, null, (boolean)false, null, null);
                    if (files != null && files.length > 0) {
                        EPackage ePackage;
                        URI uri = URI.createPlatformResourceURI((String)files[0].getFullPath().toString(), (boolean)false);
                        URIMappingDialog.this.targetURIText.setText(uri.toString());
                        String srcURI = URIMappingDialog.this.modelURIText.getText();
                        if ((srcURI == null || srcURI.trim().length() == 0) && (ePackage = QvtMetamodelMappingPage.loadEPackage(uri.toString())) != null) {
                            URIMappingDialog.this.modelURIText.setText(ePackage.getNsURI());
                        }
                    }
                }
            });
        }

        private IStatus validateSourceURI() {
            String uri = this.modelURIText.getText();
            IStatus status = QvtMetamodelMappingPage.validateURI(uri, Messages.QvtMetamodelMappingPage_sourceURILabel);
            if (status.isOK()) {
                status = QvtMetamodelMappingPage.this.getSourceUriAlreadyExistsStatus(uri, QvtMetamodelMappingPage.this.uriMap.getMapping().indexOf((Object)this.data));
            }
            return status;
        }

        private String safeURIValue(String uriStr) {
            return uriStr != null ? uriStr : "";
        }
    }
}

