/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ExecutableXMIHelper;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;

public class BinXMISerializer {
    public static URI toSourceUnitURI(URI uri) {
        return uri.trimFileExtension().appendFileExtension("qvto");
    }

    public static URI toXMIUnitURI(URI uri) {
        return uri.trimFileExtension().appendFileExtension("xmi");
    }

    public static void saveUnitXMI(CompiledUnit[] units) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        CompiledUnit[] compiledUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            CompiledUnit nextUnit = compiledUnitArray[n2];
            if (nextUnit.getUnitCST() != null) {
                URI uri = nextUnit.getURI();
                URI xmiUnitURI = BinXMISerializer.toXMIUnitURI(uri);
                for (QvtOperationalModuleEnv nextModuleEnv : nextUnit.getModuleEnvironments()) {
                    Resource unitResource = nextModuleEnv.getTypeResolver().getResource();
                    unitResource.setURI(xmiUnitURI);
                    ExecutableXMIHelper.fixResourceOnSave((Resource)unitResource);
                    rs.getResources().add((Object)unitResource);
                }
            }
            ++n2;
        }
        for (Resource next : rs.getResources()) {
            next.save(Collections.EMPTY_MAP);
            URI savedXMIURI = next.getURI();
            URI srcURI = BinXMISerializer.toSourceUnitURI(savedXMIURI);
            Map options = Collections.emptyMap();
            Map xmiAttrs = URIConverter.INSTANCE.getAttributes(savedXMIURI, options);
            HashMap xmiNewAttributes = new HashMap(xmiAttrs);
            Object srcFileTimeStmp = URIConverter.INSTANCE.getAttributes(srcURI, options).get("timeStamp");
            xmiNewAttributes.put("timeStamp", srcFileTimeStmp);
            URIConverter.INSTANCE.setAttributes(savedXMIURI, xmiNewAttributes, options);
            if (next.getErrors().isEmpty()) continue;
            Diagnostic diagnostic = EcoreUtil.computeDiagnostic((Resource)next, (boolean)false);
            QVTOProjectPlugin.log(BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
        }
    }
}

