/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.engine.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.emfvm.lib.Model;

public class ReferenceModel
extends Model {
    private Map metaElementByName = null;
    private static ReferenceModel metametamodel;
    private Set referencedResources = new HashSet();

    public void dispose() {
        this.metaElementByName = null;
        super.dispose();
    }

    public ReferenceModel(ReferenceModel referenceModel, URL url) throws IOException {
        super(referenceModel, url);
        this.registerPackages();
        this.adapt();
        this.addAllReferencedResources(this.resource);
    }

    public ReferenceModel(ReferenceModel referenceModel, URI uri) throws IOException {
        super(referenceModel, uri, false);
        this.registerPackages();
        this.adapt();
        this.addAllReferencedResources(this.resource);
    }

    public ReferenceModel(ReferenceModel referenceModel, Resource resource) {
        super(referenceModel, resource);
        this.registerPackages();
        this.addAllReferencedResources(this.resource);
    }

    public ReferenceModel(ReferenceModel referenceModel, String uri) {
        super(referenceModel, AtlEMFModelHandler.getResourceSet().getPackageRegistry().getEPackage(uri).eResource());
        this.registerPackages();
        this.addAllReferencedResources(this.resource);
    }

    private void registerPackages() {
        for (EPackage p : this.getElementsByType(EcorePackage.eINSTANCE.getEPackage())) {
            String nsURI = p.getNsURI();
            resourceSet.getPackageRegistry().put((Object)nsURI, (Object)p);
        }
    }

    private void adapt() {
        for (EPackage p : this.getElementsByType(EcorePackage.eINSTANCE.getEPackage())) {
            String nsURI = p.getNsURI();
            if (nsURI == null) {
                nsURI = p.getName();
                p.setNsURI(nsURI);
            }
            if (resourceSet.getPackageRegistry().containsKey((Object)nsURI)) {
                p.equals(resourceSet.getPackageRegistry().getEPackage(nsURI));
            }
            resourceSet.getPackageRegistry().put((Object)nsURI, (Object)p);
        }
        for (EDataType dt : this.getElementsByType(EcorePackage.eINSTANCE.getEDataType())) {
            String tname = dt.getName();
            String icn = null;
            if (tname.equals("Boolean")) {
                icn = "boolean";
            } else if (tname.equals("Double")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            dt.setInstanceClassName(icn);
        }
    }

    private ReferenceModel(Resource resource) {
        super(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EClass getMetaElementByName(String name) {
        if (this.metaElementByName == null) {
            ReferenceModel referenceModel = this;
            synchronized (referenceModel) {
                if (this.metaElementByName == null) {
                    this.metaElementByName = this.initMetaElementsInAllResources();
                }
            }
        }
        return (EClass)this.metaElementByName.get(name);
    }

    public static ReferenceModel getMetametamodel() {
        if (metametamodel == null) {
            metametamodel = new ReferenceModel(EcorePackage.eINSTANCE.eResource());
        }
        return metametamodel;
    }

    protected void addAllReferencedResources(Resource resource) {
        TreeIterator contents = resource.getAllContents();
        while (contents.hasNext()) {
            Object o = contents.next();
            if (!(o instanceof EClass)) continue;
            this.addReferencedResourcesFor((EClass)o, new HashSet());
        }
        this.referencedResources.remove(resource);
    }

    private void addReferencedResourcesFor(EClass eClass, Set ignore) {
        if (ignore.contains(eClass)) {
            return;
        }
        ignore.add(eClass);
        for (EReference eRef : eClass.getEReferences()) {
            if (!eRef.isContainment()) continue;
            EClassifier eType = eRef.getEType();
            if (eType.eResource() == null) {
                throw new RuntimeException("Resource for " + eType.toString() + " is null; cannot be referenced");
            }
            this.referencedResources.add(eType.eResource());
            if (!(eType instanceof EClass)) continue;
            this.addReferencedResourcesFor((EClass)eType, ignore);
        }
        for (EAttribute eAtt : eClass.getEAttributes()) {
            EClassifier eType = eAtt.getEType();
            if (eType.eResource() != null) {
                this.referencedResources.add(eType.eResource());
                continue;
            }
            throw new RuntimeException("Resource for " + eType.toString() + " is null; cannot be referenced");
        }
        for (EClass eSuper : eClass.getESuperTypes()) {
            if (eSuper.eResource() != null) {
                this.referencedResources.add(eSuper.eResource());
                this.addReferencedResourcesFor(eSuper, ignore);
                continue;
            }
            throw new RuntimeException("Resource for " + eSuper.toString() + " is null; cannot be referenced");
        }
    }

    private Map initMetaElementsInAllResources() {
        HashMap eClassifiers = new HashMap();
        ReferenceModel.initMetaElements(eClassifiers, this.resource.getContents().iterator(), null);
        Iterator refResources = this.referencedResources.iterator();
        while (refResources.hasNext()) {
            ReferenceModel.initMetaElements(eClassifiers, ((Resource)refResources.next()).getContents().iterator(), null);
        }
        return eClassifiers;
    }

    private static void initMetaElements(Map eClassifiers, Iterator i, String base) {
        while (i.hasNext()) {
            String name;
            EObject eo = (EObject)i.next();
            if (eo instanceof EPackage) {
                name = ((EPackage)eo).getName();
                if (base != null) {
                    name = String.valueOf(base) + "::" + name;
                }
                ReferenceModel.initMetaElements(eClassifiers, ((EPackage)eo).eContents().iterator(), name);
                continue;
            }
            if (eo instanceof EClassifier) {
                name = ((EClassifier)eo).getName();
                ReferenceModel.register(eClassifiers, name, eo);
                if (base == null) continue;
                name = String.valueOf(base) + "::" + name;
                ReferenceModel.register(eClassifiers, name, eo);
                continue;
            }
            ReferenceModel.initMetaElements(eClassifiers, eo.eContents().iterator(), base);
        }
    }

    private static void register(Map eClassifiers, String name, EObject classifier) {
        eClassifiers.containsKey(name);
        eClassifiers.put(name, classifier);
    }

    public boolean isModelOf(Object object) {
        if (object instanceof EObject) {
            Resource res = ((EObject)object).eResource();
            if (res.equals(this.resource)) {
                return true;
            }
            Iterator i = this.referencedResources.iterator();
            while (i.hasNext()) {
                if (!res.equals(i.next())) continue;
                return true;
            }
        }
        return false;
    }
}

