/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.engine.emfvm.Bytecode;
import org.eclipse.m2m.atl.engine.emfvm.lib.Bag;
import org.eclipse.m2m.atl.engine.emfvm.lib.EMFUtils;
import org.eclipse.m2m.atl.engine.emfvm.lib.EnumLiteral;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.HasFields;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclParametrizedType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclSimpleType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;
import org.eclipse.m2m.atl.engine.emfvm.lib.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLink;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLinkSet;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;
import org.eclipse.m2m.atl.engine.emfvm.lib.VMException;

public class ASMOperation
extends Operation {
    public static final int MAX_STACK = 100;
    private String name;
    private String context;
    private List parameters = new ArrayList();
    private Bytecode[] bytecodes;
    private int nbBytecodes;
    private int nbNestedIterates = 0;
    private List lineNumberTable = new ArrayList();
    private List localVariableTable = new ArrayList();
    private static Map nativeClasses = new HashMap();
    private static WeakHashMap methodCache;

    static {
        nativeClasses.put("Sequence", ArrayList.class);
        nativeClasses.put("Set", HashSet.class);
        nativeClasses.put("Bag", Bag.class);
        nativeClasses.put("OrderedSet", LinkedHashSet.class);
        nativeClasses.put("Tuple", Tuple.class);
        nativeClasses.put("EnumLiteral", EnumLiteral.class);
        nativeClasses.put("OclSimpleType", OclSimpleType.class);
        nativeClasses.put("OclParametrizedType", OclParametrizedType.class);
        nativeClasses.put("TransientLinkSet", TransientLinkSet.class);
        nativeClasses.put("TransientLink", TransientLink.class);
        nativeClasses.put("Map", HashMap.class);
        nativeClasses.put("String", String.class);
        nativeClasses.put("Integer", Integer.class);
        nativeClasses.put("OclAny", Object.class);
        nativeClasses.put("Boolean", Boolean.class);
        nativeClasses.put("Real", Double.class);
        methodCache = new WeakHashMap();
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public ASMOperation(String name) {
        super(1);
        this.name = name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }

    public void addParameter(String name, String type) {
        this.parameters.add(name);
    }

    public void addLineNumberEntry(String id, int begin, int end) {
        this.lineNumberTable.add(new LineNumberEntry(id, begin, end));
    }

    public List getLineNumberTable() {
        return this.lineNumberTable;
    }

    public String resolveLineNumber(int l) {
        String ret = null;
        Iterator i = this.lineNumberTable.iterator();
        while (i.hasNext() && ret == null) {
            LineNumberEntry lne = (LineNumberEntry)i.next();
            if (l < lne.begin || l > lne.end) continue;
            ret = lne.id;
        }
        return ret;
    }

    public void addLocalVariableEntry(int slot, String name, int begin, int end) {
        this.localVariableTable.add(new LocalVariableEntry(slot, name, begin, end));
    }

    public List getLocalVariableTable() {
        return this.localVariableTable;
    }

    public String resolveVariableName(int slot, int l) {
        String ret = null;
        Iterator i = this.localVariableTable.iterator();
        while (i.hasNext() & ret == null) {
            LocalVariableEntry lve = (LocalVariableEntry)i.next();
            if (slot != lve.slot || l < lve.begin || l > lve.end) continue;
            ret = lve.name;
        }
        return ret;
    }

    public void setBytecodes(Bytecode[] bytecodes) {
        this.bytecodes = bytecodes;
        this.nbBytecodes = bytecodes.length;
        Stack<Integer> stack = new Stack<Integer>();
        int i = 0;
        while (i < this.nbBytecodes) {
            Bytecode bytecode = bytecodes[i];
            if (bytecode.opcode == 9) {
                bytecode.value2 = stack.size();
                stack.push(new Integer(i));
                if (bytecode.value2 > this.nbNestedIterates) {
                    this.nbNestedIterates = bytecode.value2;
                }
            } else if (bytecode.opcode == 10) {
                int iterateIndex = (Integer)stack.pop();
                bytecode.value = iterateIndex + 1;
                bytecode.value2 = stack.size();
                bytecodes[iterateIndex].value = i + 1;
            } else if ((bytecode.opcode == 6 || bytecode.opcode == 7) && bytecode.value > this.maxLocals) {
                this.maxLocals = bytecode.value;
            }
            ++i;
        }
        ++this.maxLocals;
        ++this.nbNestedIterates;
    }

    public String getName() {
        return this.name;
    }

    public Object exec(StackFrame frame) {
        boolean debug = frame.execEnv.step;
        boolean supportUML2Stereotypes = frame.execEnv.supportUML2Stereotypes;
        Object[] localVars = frame.localVars;
        int pc = 0;
        int fp = 0;
        Object[] stack = new Object[100];
        Iterator[] nestedIterate = new Iterator[this.nbNestedIterates];
        try {
            while (pc < this.nbBytecodes) {
                Bytecode bytecode = this.bytecodes[pc++];
                ++frame.execEnv.nbExecutedBytecodes;
                if (debug) {
                    frame.execEnv.out.println(String.valueOf(this.name) + ":" + (pc - 1) + "\t" + bytecode);
                }
                switch (bytecode.opcode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        stack[fp++] = bytecode.operand;
                        break;
                    }
                    case 3: {
                        stack[fp++] = Boolean.TRUE;
                        break;
                    }
                    case 4: {
                        stack[fp++] = Boolean.FALSE;
                        break;
                    }
                    case 5: {
                        Object s;
                        boolean first;
                        Object[] arguments;
                        Object type;
                        Operation operation;
                        Object self = stack[fp - bytecode.value - 1];
                        if (debug) {
                            frame.execEnv.out.print("\tCalling ");
                            frame.execEnv.prettyPrint(self);
                            frame.execEnv.out.print("." + bytecode.operand + "(");
                        }
                        if ((operation = frame.execEnv.getOperation(type = ExecEnv.getType(self), bytecode.operand)) == null) {
                            Method method;
                            int nbCalleeArgs = bytecode.value;
                            arguments = new Object[nbCalleeArgs];
                            Class[] argumentTypes = new Class[nbCalleeArgs];
                            first = true;
                            int i = nbCalleeArgs;
                            while (i >= 1) {
                                arguments[i - 1] = stack[--fp];
                                argumentTypes[i - 1] = arguments[i - 1].getClass();
                                if (debug) {
                                    if (!first) {
                                        frame.execEnv.out.print(", ");
                                    }
                                    first = false;
                                    frame.execEnv.prettyPrint(arguments[i - 1]);
                                }
                                --i;
                            }
                            if (debug) {
                                frame.execEnv.out.println(")");
                            }
                            if ((method = this.findMethod(self.getClass(), bytecode.operand.toString(), argumentTypes)) == null) {
                                throw new VMException(frame, "operation not found: " + frame.execEnv.toPrettyPrintedString(self) + "." + bytecode.operand);
                            }
                            --fp;
                            s = null;
                            if (supportUML2Stereotypes) {
                                if (bytecode.operand.equals("applyProfile") || bytecode.operand.equals("applyStereotype") || bytecode.operand.equals("setValue") || bytecode.operand.equals("applyAllRequiredStereotypes") || bytecode.operand.equals("applyAllStereotypes") || bytecode.operand.equals("unapplyAllStereotype") || bytecode.operand.equals("unapplyAllNonApplicableStereotypes")) {
                                    frame.execEnv.getModelOf((EObject)self).addDelayedInvocation(method, self, bytecode.operand.toString(), arguments);
                                } else {
                                    s = method.invoke(self, arguments);
                                }
                            } else {
                                s = method.invoke(self, arguments);
                            }
                            if (s == null) break;
                            stack[fp++] = s;
                            break;
                        }
                        org.eclipse.m2m.atl.engine.emfvm.StackFrame calleeFrame = (org.eclipse.m2m.atl.engine.emfvm.StackFrame)frame.newFrame(operation);
                        arguments = calleeFrame.localVars;
                        int nbCalleeArgs = bytecode.value;
                        first = true;
                        int i = nbCalleeArgs;
                        while (i >= 1) {
                            arguments[i] = stack[--fp];
                            if (debug) {
                                if (!first) {
                                    frame.execEnv.out.print(", ");
                                }
                                first = false;
                                frame.execEnv.prettyPrint(arguments[i]);
                            }
                            --i;
                        }
                        if (debug) {
                            frame.execEnv.out.println(")");
                        }
                        --fp;
                        arguments[0] = self;
                        s = operation.exec(calleeFrame);
                        if (s == null) break;
                        stack[fp++] = s;
                        break;
                    }
                    case 6: {
                        stack[fp++] = localVars[bytecode.value];
                        break;
                    }
                    case 7: {
                        localVars[bytecode.value] = stack[--fp];
                        break;
                    }
                    case 12: {
                        Object value = stack[--fp];
                        Object s = stack[--fp];
                        if (s instanceof EObject) {
                            if (value instanceof Collection) {
                                Collection c = (Collection)value;
                                while (c.remove(OclUndefined.SINGLETON)) {
                                }
                            } else if (value instanceof OclUndefined) {
                                value = null;
                            }
                            EMFUtils.set(frame, (EObject)s, (String)bytecode.operand, value);
                            break;
                        }
                        ((HasFields)s).set(frame, bytecode.operand, value);
                        break;
                    }
                    case 13: {
                        Object s = stack[--fp];
                        Object type = ExecEnv.getType(s);
                        String propName = (String)bytecode.operand;
                        Operation ai = frame.execEnv.getAttributeInitializer(type, propName);
                        if (ai != null) {
                            stack[fp++] = frame.execEnv.getHelperValue(frame, type, s, propName);
                            break;
                        }
                        if (s instanceof EObject) {
                            stack[fp++] = EMFUtils.get(frame, (EObject)s, propName);
                            break;
                        }
                        stack[fp++] = ((HasFields)s).get(frame, propName);
                        break;
                    }
                    case 11: {
                        Object s = stack[fp - 1];
                        stack[fp++] = s;
                        break;
                    }
                    case 20: {
                        Object s = stack[fp - 1];
                        stack[fp++] = s;
                        stack[fp - 2] = stack[fp - 3];
                        stack[fp - 3] = stack[fp - 1];
                        break;
                    }
                    case 21: {
                        Object s = stack[--fp];
                        EMFUtils.delete(frame, (EObject)s);
                        break;
                    }
                    case 15: {
                        stack[fp++] = frame.asmModule;
                        break;
                    }
                    case 8: {
                        Object c;
                        Object mname = stack[--fp];
                        Object me = stack[--fp];
                        if (mname.equals("#native")) {
                            c = (Class)nativeClasses.get(me);
                            if (c != null) {
                                stack[fp++] = ((Class)c).newInstance();
                                break;
                            }
                            throw new VMException(frame, "cannot create " + mname + "!" + me);
                        }
                        EClass ec = ExecEnv.findMetaElement(frame, mname, me);
                        stack[fp++] = frame.execEnv.newElement(frame, ec);
                        break;
                    }
                    case 19: {
                        Object c;
                        Object mname = stack[--fp];
                        Object me = stack[--fp];
                        if (mname.equals("#native")) {
                            c = (Class)nativeClasses.get(me);
                            if (c != null) {
                                stack[fp++] = c;
                                break;
                            }
                            throw new VMException(frame, "cannot find " + mname + "!" + me);
                        }
                        EClass ec = ExecEnv.findMetaElement(frame, mname, me);
                        stack[fp++] = ec;
                        break;
                    }
                    case 9: {
                        Object c = (Collection)stack[--fp];
                        Iterator it = c.iterator();
                        if (it.hasNext()) {
                            nestedIterate[bytecode.value2] = it;
                            stack[fp++] = it.next();
                            break;
                        }
                        pc = bytecode.value;
                        break;
                    }
                    case 10: {
                        Iterator it = nestedIterate[bytecode.value2];
                        if (!it.hasNext()) break;
                        stack[fp++] = it.next();
                        pc = bytecode.value;
                        break;
                    }
                    case 14: {
                        --fp;
                        break;
                    }
                    case 18: {
                        Object s = stack[fp - 1];
                        stack[fp - 1] = stack[fp - 2];
                        stack[fp - 2] = s;
                        break;
                    }
                    case 16: {
                        if (!Boolean.TRUE.equals(stack[--fp])) break;
                        pc = bytecode.value;
                        break;
                    }
                    case 17: {
                        pc = bytecode.value;
                        break;
                    }
                    default: {
                        throw new VMException(frame, "Unimplemented bytecode " + bytecode.opcode);
                    }
                }
                if (!debug) continue;
                frame.execEnv.out.print("\tstack: ");
                int i = 0;
                while (i < fp) {
                    if (i > 0) {
                        frame.execEnv.out.print(", ");
                    }
                    frame.execEnv.prettyPrint(stack[i]);
                    ++i;
                }
                frame.execEnv.out.println();
                frame.execEnv.out.print("\tlocals: ");
                boolean first = true;
                int i2 = 0;
                while (i2 < localVars.length) {
                    String name = this.resolveVariableName(i2, pc);
                    if (name != null) {
                        if (!first) {
                            frame.execEnv.out.print(", ");
                        }
                        first = false;
                        frame.execEnv.out.print(String.valueOf(name) + "=");
                        frame.execEnv.prettyPrint(localVars[i2]);
                    }
                    ++i2;
                }
                frame.execEnv.out.println();
            }
        }
        catch (Exception e) {
            ((org.eclipse.m2m.atl.engine.emfvm.StackFrame)frame).pc = pc - 1;
            if (e instanceof VMException) {
                throw (VMException)e;
            }
            throw new VMException(frame, e);
        }
        return fp > 0 ? stack[--fp] : null;
    }

    public Method findMethod(Class cls, String name, Class[] argumentTypes) throws NoSuchMethodException {
        String sig = ASMOperation.getMethodSignature(name, argumentTypes);
        Method ret = this.findCachedMethod(cls, sig);
        if (ret != null) {
            return ret;
        }
        Method[] methods = cls.getDeclaredMethods();
        int i = 0;
        while (i < methods.length && ret == null) {
            Class<?>[] pts;
            Method method = methods[i];
            if (method.getName().equals(name) && (pts = method.getParameterTypes()).length == argumentTypes.length) {
                boolean ok = true;
                int j = 0;
                while (j < pts.length && ok) {
                    if (!(pts[j].isAssignableFrom(argumentTypes[j]) || pts[j] == Boolean.TYPE && argumentTypes[j] == Boolean.class || pts[j] == Integer.TYPE && argumentTypes[j] == Integer.class || pts[j] == Character.TYPE && argumentTypes[j] == Character.class || pts[j] == Long.TYPE && argumentTypes[j] == Long.class || pts[j] == Float.TYPE && argumentTypes[j] == Float.class || pts[j] == Double.TYPE && argumentTypes[j] == Double.class)) {
                        ok = false;
                    }
                    ++j;
                }
                if (ok) {
                    ret = method;
                }
            }
            ++i;
        }
        if (ret == null && cls.getSuperclass() != null) {
            ret = this.findMethod(cls.getSuperclass(), name, argumentTypes);
        }
        this.cacheMethod(cls, sig, ret);
        return ret;
    }

    public Method findCachedMethod(Class caller, String signature) {
        Method ret = null;
        Map sigMap = (Map)methodCache.get(caller);
        if (sigMap != null) {
            ret = (Method)sigMap.get(signature);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheMethod(Class caller, String signature, Method method) {
        WeakHashMap weakHashMap = methodCache;
        synchronized (weakHashMap) {
            HashMap<String, Method> sigMap = (HashMap<String, Method>)methodCache.get(caller);
            if (sigMap == null) {
                sigMap = new HashMap<String, Method>();
                methodCache.put(caller, sigMap);
            }
            sigMap.put(signature, method);
        }
    }

    public static String getMethodSignature(String name, Class[] argumentTypes) {
        StringBuffer sig = new StringBuffer();
        sig.append(name);
        sig.append('(');
        int i = 0;
        while (i < argumentTypes.length) {
            if (i > 0) {
                sig.append(',');
            }
            sig.append(argumentTypes[i].getName());
            ++i;
        }
        sig.append(')');
        return sig.toString();
    }

    public class LineNumberEntry {
        public String id;
        public int begin;
        public int end;

        public LineNumberEntry(String id, int begin, int end) {
            this.id = id;
            this.begin = begin;
            this.end = end;
        }
    }

    public class LocalVariableEntry {
        public int slot;
        public String name;
        public int begin;
        public int end;

        public LocalVariableEntry(int slot, String name, int begin, int end) {
            this.slot = slot;
            this.name = name;
            this.begin = begin;
            this.end = end;
        }
    }
}

