/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.Set;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.ProtectedRegion;
import org.eclipse.gmf.internal.xpand.model.ProtectedRegionSyntaxException;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectStatement
extends Statement {
    private final Expression commentStart;
    private final Expression commentEnd;
    private final Statement[] body;
    private final Expression id;
    private final boolean disable;

    public ProtectStatement(int start, int end, int line, int startOffset, int endOffset, Expression commentStart, Expression commentEnd, Statement[] body, Expression id, boolean disable) {
        super(start, end, line, startOffset, endOffset);
        this.commentStart = commentStart;
        this.commentEnd = commentEnd;
        this.body = body;
        this.id = id;
        this.disable = disable;
    }

    public Statement[] getBody() {
        return this.body;
    }

    public Expression getCommentEnd() {
        return this.commentEnd;
    }

    public Expression getCommentStart() {
        return this.commentStart;
    }

    public Expression getId() {
        return this.id;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        this.getCommentStart().analyze(ctx, issues);
        this.getCommentEnd().analyze(ctx, issues);
        this.getId().analyze(ctx, issues);
        int i = 0;
        while (i < this.getBody().length) {
            this.getBody()[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        String cStart = this.nullSave(this.getCommentStart().evaluate(ctx));
        if (cStart == null) {
            throw new EvaluationException("NullEvaluation!", (SyntaxElement)this.getCommentStart());
        }
        String cEnd = this.nullSave(this.getCommentEnd().evaluate(ctx));
        if (cEnd == null) {
            throw new EvaluationException("NullEvaluation!", (SyntaxElement)this.getCommentEnd());
        }
        String id = this.nullSave(this.getId().evaluate(ctx));
        if (id == null) {
            throw new EvaluationException("NullEvaluation!", (SyntaxElement)this.getId());
        }
        ProtectedRegion region = null;
        if (ctx.getProtectedRegionResolver() == null) {
            throw new RuntimeException("No protected region resolver configured!");
        }
        region = ctx.getProtectedRegionResolver().getProtectedRegion(id.toString());
        if (region == null) {
            region = ctx.getProtectedRegionResolver().createProtectedRegion(id, this.disable);
            ctx.getOutput().write(region.getStartString(cStart, cEnd));
            int i = 0;
            while (i < this.getBody().length) {
                this.getBody()[i].evaluate(ctx);
                ++i;
            }
            ctx.getOutput().write(region.getEndString(cStart, cEnd));
        } else {
            ctx.getOutput().write(region.getStartString(cStart, cEnd));
            try {
                ctx.getOutput().write(region.getBody(cStart, cEnd));
            }
            catch (ProtectedRegionSyntaxException e) {
                throw new EvaluationException(e.getMessage(), (SyntaxElement)this.getId());
            }
            ctx.getOutput().write(region.getEndString(cStart, cEnd));
        }
    }

    private String nullSave(Object string) {
        return string != null ? string.toString() : "";
    }
}

