/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.internal.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileObserverFilterType;

public class FileObserverFilter {
    private FileObserverFilterType filterType;
    private Object filter;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.internal.resources.FileObserverFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public FileObserverFilter(FileObserverFilterType aFilterType) {
        if (!$assertionsDisabled && aFilterType != FileObserverFilterType.ALL) {
            throw new AssertionError();
        }
        this.setFilterType(aFilterType);
        this.setFilter(null);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, String[] extension) {
        if (!$assertionsDisabled && aFilterType != FileObserverFilterType.EXTENSION) {
            throw new AssertionError();
        }
        this.setFilterType(aFilterType);
        this.setFilter(extension);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, IContentType[] contentType) {
        if (!$assertionsDisabled && aFilterType != FileObserverFilterType.CONTENT_TYPE) {
            throw new AssertionError();
        }
        this.setFilterType(aFilterType);
        this.setFilter(contentType);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, IFolder folder) {
        if (!$assertionsDisabled && aFilterType != FileObserverFilterType.FOLDER) {
            throw new AssertionError();
        }
        this.setFilterType(aFilterType);
        this.setFilter(folder);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, IFile file) {
        if (!$assertionsDisabled && aFilterType != FileObserverFilterType.FILE) {
            throw new AssertionError();
        }
        this.setFilterType(aFilterType);
        this.setFilter(file);
    }

    public boolean matches(IResource resource) {
        String FileExtension;
        if (this.getFilterType() == FileObserverFilterType.ALL) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FILE && resource instanceof IFile && this.getAbsolutePath((IResource)this.getFileFilter()).equals(this.getAbsolutePath(resource))) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FOLDER && resource instanceof IFile && this.getAbsolutePath(resource).startsWith(this.getAbsolutePath((IResource)this.getFolderFilter()))) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.CONTENT_TYPE && resource instanceof IFile && this.matchesContentType(((IFile)resource).getName())) {
            return true;
        }
        return this.getFilterType() == FileObserverFilterType.EXTENSION && resource instanceof IFile && this.matchesExtension(FileExtension = resource.getFullPath().getFileExtension());
    }

    public boolean matches(IPath path) {
        if (this.getFilterType() == FileObserverFilterType.ALL) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FILE && this.getAbsolutePath((IResource)this.getFileFilter()).equals(path.toOSString())) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FOLDER && this.getAbsolutePath((IResource)this.getFolderFilter()).startsWith(path.toOSString())) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.CONTENT_TYPE && this.matchesContentType(path.toFile().getName())) {
            return true;
        }
        return this.getFilterType() == FileObserverFilterType.EXTENSION && this.matchesExtension(path.getFileExtension());
    }

    private boolean matchesContentType(String fileName) {
        IContentType[] contentTypes = this.getContentTypeFilter();
        int i = 0;
        while (i < contentTypes.length) {
            if (contentTypes[i].isAssociatedWith(fileName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matchesExtension(String extension) {
        String[] extensions = this.getExtensionFilter();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].equals(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IFile getFileFilter() {
        if (!$assertionsDisabled && this.filterType != FileObserverFilterType.FILE) {
            throw new AssertionError();
        }
        return (IFile)this.filter;
    }

    private IFolder getFolderFilter() {
        if (!$assertionsDisabled && this.filterType != FileObserverFilterType.FOLDER) {
            throw new AssertionError();
        }
        return (IFolder)this.filter;
    }

    private String[] getExtensionFilter() {
        if (!$assertionsDisabled && this.filterType != FileObserverFilterType.EXTENSION) {
            throw new AssertionError();
        }
        return (String[])this.filter;
    }

    private IContentType[] getContentTypeFilter() {
        if (!$assertionsDisabled && this.filterType != FileObserverFilterType.CONTENT_TYPE) {
            throw new AssertionError();
        }
        return (IContentType[])this.filter;
    }

    private FileObserverFilterType getFilterType() {
        return this.filterType;
    }

    private void setFilter(Object object) {
        this.filter = object;
    }

    private void setFilterType(FileObserverFilterType type) {
        this.filterType = type;
    }

    private String getAbsolutePath(IResource resource) {
        if (resource.getLocation() == null) {
            IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IPath path = root.append(resource.getFullPath());
            return path.toOSString();
        }
        return resource.getLocation().toOSString();
    }
}

