/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.printing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.printing.IPrintHelper;
import org.eclipse.gmf.runtime.common.ui.printing.internal.CommonPrintingDebugOptions;
import org.eclipse.gmf.runtime.common.ui.printing.internal.PrintingPlugin;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.PlatformUI;

public class PrintHelper
implements IPrintHelper {
    private static final String DLL_NAME = "DiagramPrint";
    private static final String SEPARATOR = "_";
    private static final String[] SUPPORTED;
    private static final String DEFAULT_LOCALE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.printing.PrintHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        SUPPORTED = new String[]{"en", "de", "es", "fr", "it", "ja", "ko", "pt_BR", "zh_CN", "zh_TW"};
        String localizedVersion = DEFAULT_LOCALE = SUPPORTED[0];
        ArrayList<String> supported = new ArrayList<String>();
        supported.addAll(Arrays.asList(SUPPORTED));
        String language = Locale.getDefault().getLanguage().toLowerCase();
        if (supported.contains(language)) {
            localizedVersion = language;
        } else {
            String locale;
            String country = Locale.getDefault().getCountry().toUpperCase();
            if (country != null && supported.contains(locale = String.valueOf(language) + SEPARATOR + country)) {
                localizedVersion = locale;
            }
        }
        try {
            System.loadLibrary("DiagramPrint_" + localizedVersion);
        }
        catch (UnsatisfiedLinkError ule) {
            Log.error((Plugin)PrintingPlugin.getDefault(), (int)1, (String)("Failed to load DiagramPrint dll for " + localizedVersion));
            PrintingPlugin printingPlugin = PrintingPlugin.getDefault();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.printing.PrintHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)printingPlugin, (String)CommonPrintingDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz2, (String)"Link", (Throwable)ule);
            PrintingPlugin printingPlugin2 = PrintingPlugin.getDefault();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.printing.PrintHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.throwing((Plugin)printingPlugin2, (String)CommonPrintingDebugOptions.EXCEPTIONS_THROWING, (Class)clazz3, (String)"Link", (Throwable)ule);
            throw ule;
        }
    }

    public static native void initScaleFitTo(int var0, int var1);

    public static native void initScalePercent(int var0);

    public static native void resetDialog();

    public static native void addDiagramString(String var0);

    public static native void setHwndOwner(String var0, String var1);

    public static native void setOrientation(boolean var0);

    public static native void setPaperSize(int var0, double var1, double var3);

    public static native int getScaleFitToM();

    public static native int getScaleFitToN();

    public static native int getScalePercent();

    public static native boolean isDiagramSelected(int var0);

    public static native boolean getDiagramPrintRangeAll();

    public static native boolean getDiagramPrintRangeCurrent();

    public static native boolean getDiagramPrintRangeSelection();

    public static native boolean getPrintRangeAll();

    public static native boolean getPrintRangePages();

    public static native boolean getCollate();

    public static native int getPagesFrom();

    public static native int getPagesTo();

    public static native int getNumberOfCopies();

    public static native boolean open(PrinterData var0);

    public PrinterData openPrintDlg(List diagramList) {
        PrinterData printerData;
        String title = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getText();
        if (!$assertionsDisabled && title == null) {
            throw new AssertionError((Object)"title cannot be null");
        }
        PrintHelper.setHwndOwner("SWT_Window0", title);
        PrintHelper.resetDialog();
        PrintHelper.initScaleFitTo(1, 1);
        PrintHelper.initScalePercent(100);
        if (diagramList != null) {
            int c = 0;
            while (c < diagramList.size()) {
                if (!$assertionsDisabled && !(diagramList.get(c) instanceof String)) {
                    throw new AssertionError();
                }
                PrintHelper.addDiagramString((String)diagramList.get(c));
                ++c;
            }
        }
        if (PrintHelper.open(printerData = new PrinterData("", ""))) {
            if (PrintHelper.getPrintRangePages()) {
                printerData.scope = 1;
                printerData.startPage = PrintHelper.getPagesFrom();
                printerData.endPage = PrintHelper.getPagesTo();
            } else {
                printerData.scope = 0;
            }
        } else {
            return null;
        }
        printerData.printToFile = false;
        printerData.copyCount = PrintHelper.getNumberOfCopies();
        printerData.collate = PrintHelper.getCollate();
        return printerData;
    }

    public int getDlgScaleFitToM() {
        return PrintHelper.getScaleFitToM();
    }

    public int getDlgScaleFitToN() {
        return PrintHelper.getScaleFitToN();
    }

    public int getDlgScalePercent() {
        return PrintHelper.getScalePercent();
    }

    public boolean isDlgDiagramSelected(int index) {
        return PrintHelper.isDiagramSelected(index);
    }

    public boolean getDlgDiagramPrintRangeAll() {
        return PrintHelper.getDiagramPrintRangeAll();
    }

    public boolean getDlgDiagramPrintRangeCurrent() {
        return PrintHelper.getDiagramPrintRangeCurrent();
    }

    public boolean getDlgDiagramPrintRangeSelection() {
        return PrintHelper.getDiagramPrintRangeSelection();
    }

    public boolean getDlgPrintRangeAll() {
        return PrintHelper.getPrintRangeAll();
    }

    public boolean getDlgPrintRangePages() {
        return PrintHelper.getPrintRangePages();
    }

    public boolean getDlgCollate() {
        return PrintHelper.getCollate();
    }

    public int getDlgPagesFrom() {
        return PrintHelper.getPagesFrom();
    }

    public int getDlgPagesTo() {
        return PrintHelper.getPagesTo();
    }

    public int getDlgNumberOfCopies() {
        return PrintHelper.getNumberOfCopies();
    }

    public void setDlgOrientation(boolean bLandscape) {
        PrintHelper.setOrientation(bLandscape);
    }

    public void setDlgPaperSize(int index, double width, double height) {
        PrintHelper.setPaperSize(index, width, height);
    }
}

