/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.tests.setup.figures.FigureCheck;
import org.eclipse.gmf.tests.setup.figures.FigureGeneratorUtil;
import org.osgi.framework.Bundle;

public class StandaloneMapModeTest
extends TestCase {
    public StandaloneMapModeTest(String name) {
        super(name);
    }

    public void testStaticIdentityMapMode() {
        StandaloneGenerator.Config config = FigureGeneratorUtil.createStandaloneGeneratorConfig("org.eclipse.gmf.tests.sample.figures", false);
        FigureGeneratorUtil.GeneratedClassData[] theOnly = FigureGeneratorUtil.generateAndCompile(config, this.createTestFigure());
        StandaloneMapModeTest.assertEquals((int)1, (int)theOnly.length);
        new FigureSizeCheck(123, 456).go(theOnly[0].getLoadedClass());
    }

    public void testRuntimeIdentityAndHiMetricMapMode() {
        StandaloneGenerator.Config config = FigureGeneratorUtil.createStandaloneGeneratorConfig("org.eclipse.gmf.tests.sample.figures", true);
        FigureGeneratorUtil.GeneratedClassData[] theOnly = FigureGeneratorUtil.generateAndCompile(config, this.createTestFigure());
        StandaloneMapModeTest.assertNotNull((Object)theOnly);
        StandaloneMapModeTest.assertEquals((int)1, (int)theOnly.length);
        Class<?> figureClass = theOnly[0].getLoadedClass();
        new InstantiateFigureHook(123, 456, MapModeTypes.IDENTITY_MM, config).go(figureClass);
        new InstantiateFigureHook(123, 456, MapModeTypes.HIMETRIC_MM, config).go(figureClass);
    }

    private RealFigure createTestFigure() {
        Rectangle result = GMFGraphFactory.eINSTANCE.createRectangle();
        result.setName("TestFigure");
        result.setSize(FigureGeneratorUtil.createPoint(123, 456));
        return result;
    }

    private static class FigureSizeCheck
    extends FigureCheck {
        private final Dimension mySize;

        public FigureSizeCheck(int width, int height) {
            this.mySize = new Dimension(width, height);
        }

        protected void checkFigure(IFigure figure) {
            FigureSizeCheck.assertEquals((Object)this.mySize, (Object)figure.getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstantiateFigureHook
    extends FigureSizeCheck {
        private final IMapMode myMapMode;
        private final StandaloneGenerator.Config myConfig;

        public InstantiateFigureHook(int width, int height, IMapMode mapMode, StandaloneGenerator.Config config) {
            super(mapMode.DPtoLP(width), mapMode.DPtoLP(height));
            this.myMapMode = mapMode;
            this.myConfig = config;
        }

        @Override
        protected IFigure instantiateFigure(Class<?> figureClass) {
            try {
                this.hookMapMode();
            }
            catch (Exception e) {
                InstantiateFigureHook.fail((String)e.getMessage());
            }
            return super.instantiateFigure(figureClass);
        }

        private void hookMapMode() throws Exception {
            Bundle bundle = Platform.getBundle((String)this.myConfig.getPluginID());
            InstantiateFigureHook.assertNotNull((Object)bundle);
            Class activatorClass = bundle.loadClass(String.valueOf(this.myConfig.getPluginActivatorPackageName()) + "." + this.myConfig.getPluginActivatorClassName());
            InstantiateFigureHook.assertNotNull((Object)activatorClass);
            Method getDefault = activatorClass.getMethod("getDefault", new Class[0]);
            InstantiateFigureHook.assertNotNull((Object)getDefault);
            Object activator = getDefault.invoke(null, new Object[0]);
            InstantiateFigureHook.assertNotNull((Object)activator);
            Method setMapMode = activatorClass.getMethod("setMapMode", IMapMode.class);
            InstantiateFigureHook.assertNotNull((Object)setMapMode);
            setMapMode.invoke(activator, this.myMapMode);
            Method getMapMode = activatorClass.getMethod("getMapMode", new Class[0]);
            InstantiateFigureHook.assertNotNull((Object)getMapMode);
            InstantiateFigureHook.assertEquals((Object)this.myMapMode, (Object)getMapMode.invoke(activator, new Object[0]));
        }
    }
}

