/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.util;

import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.util.Trace;

public abstract class Proxy {
    private Object realObject;

    protected Proxy(Object realObject) {
        assert (realObject != null) : "null argument passed to proxy";
        this.realObject = realObject;
    }

    public Object getRealObject() {
        return this.realObject;
    }

    public void setRealObject(Object realObject) {
        assert (realObject != null) : "null argument passed setRealObject";
        this.realObject = realObject;
    }

    protected void handle(Exception exception) {
        Trace.catching(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), "handle", exception);
        RuntimeException cre = new RuntimeException(exception);
        Trace.throwing(CommonCorePlugin.getDefault(), CommonCoreDebugOptions.EXCEPTIONS_THROWING, this.getClass(), "handle", cre);
        throw cre;
    }

    public final int hashCode() {
        return this.getRealObject().hashCode();
    }

    private boolean equals(Proxy proxy) {
        return this.getRealObject() == null ? proxy.getRealObject() == null : this.getRealObject().equals(proxy.getRealObject());
    }

    public final boolean equals(Object object) {
        return object instanceof Proxy && this.equals((Proxy)object);
    }
}

