/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.polocies;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GridLayout;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.Layoutable;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.StackLayout;
import org.eclipse.gmf.gmfgraph.XYLayout;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.graphdef.editor.edit.polocies.AbstractDomainBasedXYLayoutEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class FigureContainerXYLayoutEditPolicy
extends AbstractDomainBasedXYLayoutEditPolicy {
    public FigureContainerXYLayoutEditPolicy(IMapMode mapMode) {
        super(mapMode);
    }

    protected ICommand createSetBoundsCommand(TransactionalEditingDomain editingDomain, String label, Resource resource, Rectangle bounds, EObject element) {
        if (element instanceof Figure) {
            Figure figure = (Figure)element;
            return new SetBoundsCommand(editingDomain, label, resource, bounds, figure, this.getMainFigureLayout());
        }
        return null;
    }

    protected ICommand createSetBoundsCommand(TransactionalEditingDomain editingDomain, String label, Resource resource, CreateViewRequest.ViewDescriptor viewDescriptor, Rectangle rect) {
        return new SetBoundsCommand(editingDomain, label, resource, (IAdaptable)viewDescriptor, rect, this.getMainFigureLayout());
    }

    private Layout getMainFigureLayout() {
        EObject domainModelElement;
        if (this.getHost().getModel() instanceof View && (domainModelElement = ((View)this.getHost().getModel()).getElement()) instanceof Layoutable) {
            return ((Layoutable)domainModelElement).getLayout();
        }
        return null;
    }

    private final class SetBoundsCommand
    extends AbstractTransactionalCommand {
        private Rectangle myBounds;
        private Figure myFigure;
        private IAdaptable myAdaptable;
        private Layout myParentFigureLayout;

        protected SetBoundsCommand(TransactionalEditingDomain domain, String label, Resource resource, Rectangle bounds, Figure figure, Layout parentFigureLayout) {
            super(domain, label, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)resource)));
            this.myBounds = bounds;
            this.myFigure = figure;
            this.myParentFigureLayout = parentFigureLayout;
        }

        protected SetBoundsCommand(TransactionalEditingDomain domain, String label, Resource resource, IAdaptable adaptable, Rectangle bounds, Layout parentFigureLayout) {
            super(domain, label, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)resource)));
            this.myBounds = bounds;
            this.myAdaptable = adaptable;
            this.myParentFigureLayout = parentFigureLayout;
        }

        private Figure getFigure() {
            if (this.myFigure != null) {
                return this.myFigure;
            }
            View view = (View)this.myAdaptable.getAdapter(View.class);
            return (Figure)view.getElement();
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            int x = FigureContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(this.myBounds.x);
            int y = FigureContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(this.myBounds.y);
            int width = FigureContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(this.myBounds.width);
            int height = FigureContainerXYLayoutEditPolicy.this.getMapMode().LPtoDP(this.myBounds.height);
            if (this.myParentFigureLayout instanceof XYLayout) {
                this.setXYLayoutBounds(x, y, width, height, this.getFigure());
            } else if (this.myParentFigureLayout instanceof BorderLayout) {
                this.setBorderLayoutBounds(x, y, width, height, this.getFigure());
            } else if (this.myParentFigureLayout instanceof FlowLayout) {
                this.setFlowLayoutBounds(x, y, width, height, this.getFigure());
            } else if (this.myParentFigureLayout instanceof GridLayout) {
                this.setGridLayoutBounds(x, y, width, height, this.getFigure());
            } else if (!(this.myParentFigureLayout instanceof StackLayout)) {
                this.setNoLayoutBounds(x, y, width, height, this.getFigure());
            }
            return CommandResult.newOKCommandResult();
        }

        private void setNoLayoutBounds(int x, int y, int width, int height, Figure figure) {
            this.setLocation(x, y, figure);
            this.setPreferredSize(width, height, figure);
        }

        private void setLocation(int x, int y, Figure figure) {
            Point location = figure.getLocation() != null ? figure.getLocation() : GMFGraphFactory.eINSTANCE.createPoint();
            location.setX(x);
            location.setY(y);
            if (figure.getLocation() == null) {
                figure.setLocation(location);
            }
        }

        private void setPreferredSize(int width, int height, Figure figure) {
            Dimension preferredSize = figure.getPreferredSize() != null ? figure.getPreferredSize() : GMFGraphFactory.eINSTANCE.createDimension();
            preferredSize.setDx(width);
            preferredSize.setDy(height);
            if (figure.getPreferredSize() == null) {
                figure.setPreferredSize(preferredSize);
            }
        }

        private void setGridLayoutBounds(int x, int y, int width, int height, Figure figure) {
            this.setPreferredSize(width, height, figure);
        }

        private void setFlowLayoutBounds(int x, int y, int width, int height, Figure figure) {
            this.setPreferredSize(width, height, figure);
        }

        private void setBorderLayoutBounds(int x, int y, int width, int height, Figure figure) {
            Dimension preferredSize;
            BorderLayoutData borderLayoutData;
            if (!(figure.getLayoutData() instanceof BorderLayoutData)) {
                BorderLayoutData layoutData = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
                layoutData.setAlignment(Alignment.BEGINNING_LITERAL);
                figure.setLayoutData((LayoutData)layoutData);
            }
            if ((borderLayoutData = (BorderLayoutData)figure.getLayoutData()).getAlignment() == Alignment.CENTER_LITERAL) {
                return;
            }
            Dimension dimension = preferredSize = figure.getPreferredSize() != null ? figure.getPreferredSize() : GMFGraphFactory.eINSTANCE.createDimension();
            if (borderLayoutData.isVertical()) {
                preferredSize.setDy(height);
            } else {
                preferredSize.setDx(width);
            }
            if (figure.getPreferredSize() == null) {
                figure.setPreferredSize(preferredSize);
            }
        }

        private void setXYLayoutBounds(int x, int y, int width, int height, Figure figure) {
            XYLayoutData xyLayoutData = figure.getLayoutData() instanceof XYLayoutData ? (XYLayoutData)figure.getLayoutData() : this.createXYLayoutData();
            xyLayoutData.getTopLeft().setX(x);
            xyLayoutData.getTopLeft().setY(y);
            xyLayoutData.getSize().setDx(width);
            xyLayoutData.getSize().setDy(height);
            if (!(figure.getLayoutData() instanceof XYLayoutData)) {
                figure.setLayoutData((LayoutData)xyLayoutData);
            }
        }

        private XYLayoutData createXYLayoutData() {
            XYLayoutData layoutData = GMFGraphFactory.eINSTANCE.createXYLayoutData();
            layoutData.setTopLeft(GMFGraphFactory.eINSTANCE.createPoint());
            layoutData.setSize(GMFGraphFactory.eINSTANCE.createDimension());
            return layoutData;
        }
    }
}

