/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;

public class LinkCreationTest
extends GeneratedCanvasTest {
    private Node myNodeA;
    private Node myNodeB;

    public LinkCreationTest(String name) {
        super(name, new RuntimeBasedGeneratorConfiguration());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myNodeA = this.getNotation(this.getNodeEditPartA());
        this.myNodeB = this.getNotation(this.getNodeEditPartB());
    }

    public void testTypeLinkOutOnly() {
        GenLink genLink = this.getSetup().getGenModel().getLinkC();
        LinkCreationTest.assertTrue((String)"Incorrect session setup: outgoing creation should be allowed", (boolean)genLink.isOutgoingCreationAllowed());
        LinkCreationTest.assertFalse((String)"Incorrect session setup: incoming creation should not be allowed", (boolean)genLink.isIncomingCreationAllowed());
        this.checkLink(genLink);
    }

    public void testCreateMultipleTypeLinks() {
        GenLink genLink = this.getSetup().getGenModel().getLinkC();
        this.checkLinkCreation(genLink, false);
        this.checkLinkCreation(genLink, false);
        this.checkLinkCreation(genLink, false);
    }

    public void testTypeLinkInOnly() {
        GenLink genLink = this.getLink(true, 1);
        LinkCreationTest.assertFalse((String)"Incorrect session setup: outgoing creation should not be allowed", (boolean)genLink.isOutgoingCreationAllowed());
        LinkCreationTest.assertTrue((String)"Incorrect session setup: incoming creation should be allowed", (boolean)genLink.isIncomingCreationAllowed());
        this.checkLink(genLink);
    }

    public void testCreateOneTypeLink() {
        GenLink genLink = this.getLink(true, 1);
        this.checkLinkCreation(genLink, true);
        this.checkLinkCreationNotAllowed(genLink);
    }

    public void testTypeLinkInOut() {
        GenLink genLink = this.getLink(true, 2);
        LinkCreationTest.assertTrue((String)"Incorrect session setup: outgoing creation should be allowed", (boolean)genLink.isOutgoingCreationAllowed());
        LinkCreationTest.assertTrue((String)"Incorrect session setup: incoming creation should be allowed", (boolean)genLink.isIncomingCreationAllowed());
        this.checkLink(genLink);
    }

    public void testCreateTwoTypeLinks() {
        GenLink genLink = this.getLink(true, 2);
        this.checkLinkCreation(genLink, false);
        this.checkLinkCreation(genLink, true);
        this.checkLinkCreationNotAllowed(genLink);
    }

    public void testRefLinkOutOnly() {
        Node nodeB = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeB", (Object)nodeB);
        this.checkLink(this.getSetup().getGenModel().getLinkD(), (View)this.myNodeA, (View)nodeB, true, false);
    }

    public void testCreateMultipleReferenceLinks() {
        Node nodeB1 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeB", (Object)nodeB1);
        Node nodeB2 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeB", (Object)nodeB2);
        Node nodeB3 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeB", (Object)nodeB3);
        GenLink genLink = this.getSetup().getGenModel().getLinkD();
        this.checkLinkCreation(genLink, (View)this.myNodeA, (View)nodeB3, false);
        this.checkLinkCreation(genLink, (View)this.myNodeA, (View)nodeB1, false);
        this.checkLinkCreation(genLink, (View)this.myNodeA, (View)nodeB2, false);
    }

    public void testRefLinkInOnly() {
        GenLink genLink = this.getLink(false, 1);
        LinkCreationTest.assertFalse((String)"Incorrect session setup: outgoing creation should not be allowed", (boolean)genLink.isOutgoingCreationAllowed());
        LinkCreationTest.assertTrue((String)"Incorrect session setup: incoming creation should be allowed", (boolean)genLink.isIncomingCreationAllowed());
        this.checkLink(genLink);
    }

    public void testCreateOneReferenceLink() {
        Node nodeB1 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeB", (Object)nodeB1);
        GenLink genLink = this.getLink(false, 1);
        this.checkLinkCreation(genLink, (View)nodeB1, (View)this.myNodeA, true);
        this.checkLinkCreationNotAllowed(genLink);
    }

    public void testRefLinkInOut() {
        GenLink genLink = this.getLink(false, 2);
        LinkCreationTest.assertTrue((String)"Incorrect session setup: outgoing creation should be allowed", (boolean)genLink.isOutgoingCreationAllowed());
        LinkCreationTest.assertTrue((String)"Incorrect session setup: incoming creation should be allowed", (boolean)genLink.isIncomingCreationAllowed());
        this.checkLink(genLink);
    }

    public void testCreateTwoReferenceLinks() {
        Node nodeB1 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeB", (Object)nodeB1);
        Node nodeB2 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeB", (Object)nodeB2);
        GenLink genLink = this.getLink(false, 2);
        this.checkLinkCreation(genLink, (View)this.myNodeA, (View)nodeB1, false);
        this.checkLinkCreation(genLink, (View)nodeB2, (View)this.myNodeA, true);
        this.checkLinkCreationNotAllowed(genLink);
    }

    public void testCreateReferenceLinkUniqueness() {
        GenLink genLink = this.getLink(false, 2);
        LinkCreationTest.assertTrue((String)"Incorrect genLink found", (genLink.getModelFacet() instanceof FeatureLinkModelFacet && ((FeatureLinkModelFacet)genLink.getModelFacet()).getMetaFeature().isUnique() ? 1 : 0) != 0);
        this.checkLinkCreation(genLink, false);
        this.checkLinkCreationNotAllowed(genLink);
    }

    public void testSelfTypeLinkOut() {
        Node nodeA1 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeA", (Object)nodeA1);
        this.checkLinkCreation(this.getSelfLink(true), (View)this.myNodeA, (View)nodeA1, false);
    }

    public void testSelfRefLinkOut() {
        Node nodeA1 = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create another nodeA", (Object)nodeA1);
        this.checkLinkCreation(this.getSelfLink(false), (View)this.myNodeA, (View)nodeA1, false);
    }

    public void testLink2Link() {
        Edge link = this.createSourceTargetLink();
        Node node = this.createNode(this.getNodeD(), (View)this.getDiagram());
        GenLink link2Link = this.getLink(true, 3);
        LinkCreationTest.assertNotNull((Object)link2Link);
        this.checkLinkCreation(link2Link, (View)node, (View)link, false);
    }

    public void testLinkFromLink() {
        Edge link = this.createSourceTargetLink();
        Node node = this.createNode(this.getNodeD(), (View)this.getDiagram());
        GenLink link2Link = this.getLink(true, 4);
        LinkCreationTest.assertNotNull((Object)link2Link);
        this.checkLinkCreation(link2Link, (View)link, (View)node, false);
    }

    public void testLinkCrossLink() {
        Edge link = this.createSourceTargetLink();
        GenLink link2Link = this.getLink(true, 5);
        LinkCreationTest.assertNotNull((Object)link2Link);
        this.checkLinkCreation(link2Link, (View)link, (View)link, false);
    }

    public void testLink2LinkRef() {
        Edge link = this.createSourceTargetLink();
        Node node = this.createNode(this.getNodeD(), (View)this.getDiagram());
        GenLink link2Link = this.getLink(false, 3);
        LinkCreationTest.assertNotNull((Object)link2Link);
        this.checkLinkCreation(link2Link, (View)node, (View)link, false);
    }

    public void testLinkFromLinkRef() {
        Edge link = this.createSourceTargetLink();
        Node node = this.createNode(this.getNodeD(), (View)this.getDiagram());
        GenLink link2Link = this.getLink(false, 4);
        LinkCreationTest.assertNotNull((Object)link2Link);
        this.checkLinkCreation(link2Link, (View)link, (View)node, false);
    }

    public void testLinkCrossLinkRef() {
        Edge link = this.createSourceTargetLink();
        GenLink link2Link = this.getLink(false, 5);
        LinkCreationTest.assertNotNull((Object)link2Link);
        this.checkLinkCreation(link2Link, (View)link, (View)link, false);
    }

    private GenCommonBase getNodeD() {
        for (GenNode nextGenNode : this.getSetup().getGenModel().getGenDiagram().getTopLevelNodes()) {
            if (!"NodeTargetD".equals(nextGenNode.getDomainMetaClass().getName())) continue;
            return nextGenNode;
        }
        LinkCreationTest.fail((String)"No NodeTargetD found");
        return null;
    }

    private Edge createSourceTargetLink() {
        Node nodeA = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeA(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create nodeA", (Object)nodeA);
        Node nodeB = this.createNode((GenCommonBase)this.getSetup().getGenModel().getNodeB(), (View)this.getDiagram());
        LinkCreationTest.assertNotNull((String)"Unable to create nodeB", (Object)nodeB);
        Edge link = this.createLink(this.getSetup().getGenModel().getLinkC(), (View)nodeA, (View)nodeB);
        LinkCreationTest.assertNotNull((String)"Unable to create link from nodeA to nodeB", (Object)link);
        return link;
    }

    private void checkLinkCreationNotAllowed(GenLink genLink) {
        this.checkLink(genLink, (View)this.myNodeA, (View)this.myNodeB, false, false);
    }

    private void checkLink(GenLink genLink) {
        this.checkLink(genLink, (View)this.myNodeA, (View)this.myNodeB, genLink.isOutgoingCreationAllowed(), genLink.isIncomingCreationAllowed());
    }

    private void checkLink(GenLink genLink, View sourceNode, View targetNode, boolean directCreation, boolean reversedCreation) {
        Command directCommand = this.getViewerConfiguration().getCreateLinkCommand(sourceNode, targetNode, (GenCommonBase)genLink);
        LinkCreationTest.assertTrue((String)("Dirrect link creation command should " + (directCreation ? "" : "not ") + "be allowed"), ((directCommand != null && directCommand.canExecute()) == directCreation ? 1 : 0) != 0);
        Command reversedCommand = this.getViewerConfiguration().getCreateLinkCommand(targetNode, sourceNode, (GenCommonBase)genLink);
        LinkCreationTest.assertTrue((String)("Reversed link creation command should " + (reversedCreation ? "" : "not ") + "be allowed"), ((reversedCommand != null && reversedCommand.canExecute()) == reversedCreation ? 1 : 0) != 0);
    }

    private GenLink getSelfLink(boolean typeLink) {
        for (GenLink nextLink : this.getSetup().getGenModel().getGenDiagram().getLinks()) {
            TypeLinkModelFacet modelFacet;
            if (!(typeLink && nextLink.getModelFacet() instanceof TypeLinkModelFacet ? (modelFacet = (TypeLinkModelFacet)nextLink.getModelFacet()).getTargetMetaFeature().getTypeGenClass() == modelFacet.getContainmentMetaFeature().getGenClass() : !typeLink && nextLink.getModelFacet() instanceof FeatureLinkModelFacet && (modelFacet = (FeatureLinkModelFacet)nextLink.getModelFacet()).getMetaFeature().getTypeGenClass() == modelFacet.getMetaFeature().getGenClass())) continue;
            return nextLink;
        }
        LinkCreationTest.fail((String)("Self gen link was not found. Probably incorrect session setup used. isTypeLink = " + typeLink));
        return null;
    }

    private GenLink getLink(boolean typeLink, int cardinality) {
        for (GenLink nextLink : this.getSetup().getGenModel().getGenDiagram().getLinks()) {
            TypeLinkModelFacet modelFacet;
            if (!(typeLink && nextLink.getModelFacet() instanceof TypeLinkModelFacet ? (modelFacet = (TypeLinkModelFacet)nextLink.getModelFacet()).getContainmentMetaFeature().getEcoreFeature().getUpperBound() == cardinality : !typeLink && nextLink.getModelFacet() instanceof FeatureLinkModelFacet && (modelFacet = (FeatureLinkModelFacet)nextLink.getModelFacet()).getMetaFeature().getEcoreFeature().getUpperBound() == cardinality)) continue;
            return nextLink;
        }
        LinkCreationTest.fail((String)("Gen link was not found. Probably incorrect session setup used. type = " + typeLink + ", cardinality = " + cardinality));
        return null;
    }

    private void checkLinkCreation(GenLink link, boolean reversed) {
        this.checkLinkCreation(link, (View)(reversed ? this.myNodeB : this.myNodeA), (View)(reversed ? this.myNodeA : this.myNodeB), reversed);
    }

    private void checkLinkCreation(GenLink genLink, View source, View target, boolean reversed) {
        Edge link = this.createLink(genLink, source, target);
        LinkCreationTest.assertNotNull((Object)link);
        View srcView = reversed ? target : source;
        View dstView = reversed ? source : target;
        LinkCreationTest.assertEquals((Object)srcView, (Object)link.getSource());
        LinkCreationTest.assertEquals((Object)dstView, (Object)link.getTarget());
        if (genLink.getModelFacet() instanceof TypeLinkModelFacet) {
            this.checkSemanticTypeLink(link, srcView, dstView, (TypeLinkModelFacet)genLink.getModelFacet());
        } else if (genLink.getModelFacet() instanceof FeatureLinkModelFacet) {
            this.checkSemanticReferenceLink(link, srcView, dstView, (FeatureLinkModelFacet)genLink.getModelFacet());
        } else {
            LinkCreationTest.fail((String)"Link with unsupported model facet passed");
        }
    }

    private void checkSemanticReferenceLink(Edge link, View source, View target, FeatureLinkModelFacet facet) {
        EObject linkSource = source.getElement();
        EObject linkTarget = target.getElement();
        LinkCreationTest.assertNull((Object)link.getElement());
        EStructuralFeature linkFeature = linkSource.eClass().getEStructuralFeature(facet.getMetaFeature().getName());
        LinkCreationTest.assertNotNull((Object)linkFeature);
        Object linked = linkSource.eGet(linkFeature);
        if (linked instanceof Collection) {
            LinkCreationTest.assertTrue((String)"Link element was not added to the container", (boolean)((Collection)linked).contains(linkTarget));
        } else {
            LinkCreationTest.assertEquals((String)"Link element was not added to the container", (Object)linkTarget, (Object)linked);
        }
    }

    private void checkSemanticTypeLink(Edge link, View source, View target, TypeLinkModelFacet facet) {
        EObject linkSource = source.getElement();
        EObject linkElement = link.getElement();
        EObject linkTarget = target.getElement();
        LinkCreationTest.assertNotNull((Object)linkElement);
        if (facet.getSourceMetaFeature() == null) {
            EStructuralFeature containmentFeature = linkSource.eClass().getEStructuralFeature(facet.getContainmentMetaFeature().getName());
            LinkCreationTest.assertNotNull((Object)containmentFeature);
            Object contained = linkSource.eGet(containmentFeature);
            if (contained instanceof Collection) {
                LinkCreationTest.assertTrue((String)"Link element was not added to the container", (boolean)((Collection)contained).contains(linkElement));
            } else {
                LinkCreationTest.assertEquals((String)"Link element was not added to the container", (Object)linkElement, (Object)contained);
            }
        } else {
            EStructuralFeature sourceFeature = linkElement.eClass().getEStructuralFeature(facet.getSourceMetaFeature().getName());
            LinkCreationTest.assertNotNull((Object)sourceFeature);
            Object sources = linkElement.eGet(sourceFeature);
            if (sources instanceof Collection) {
                LinkCreationTest.assertTrue((String)"Link source was not set correctly", (boolean)((Collection)sources).contains(linkSource));
            } else {
                LinkCreationTest.assertEquals((String)"Link source was not set correctly", (Object)linkSource, (Object)sources);
            }
        }
        EStructuralFeature targetFeature = linkElement.eClass().getEStructuralFeature(facet.getTargetMetaFeature().getName());
        LinkCreationTest.assertNotNull((Object)targetFeature);
        Object targets = linkElement.eGet(targetFeature);
        if (targets instanceof Collection) {
            LinkCreationTest.assertTrue((String)"Link target was not set correctly", (boolean)((Collection)targets).contains(linkTarget));
        } else {
            LinkCreationTest.assertEquals((String)"Link target was not set correctly", (Object)linkTarget, (Object)targets);
        }
    }
}

