/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.ocl.cst.CSTFactory;
import org.eclipse.ocl.cst.IntegerLiteralExpCS;
import org.eclipse.ocl.cst.OCLExpressionCS;

public class OutputImplTest
extends TestCase {
    private Output output;
    private StringBuilder buffer;

    protected void setUp() throws Exception {
        super.setUp();
        this.buffer = new StringBuilder(50);
        Map emptyMap = Collections.emptyMap();
        this.output = new BufferOutput(this.buffer, emptyMap);
    }

    private Output getOutput() {
        return this.output;
    }

    private StringBuilder getBuffer() {
        return this.buffer;
    }

    public final void testDeleteLineSingleNewlineChar() {
        Output bo = this.getOutput();
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", false));
        bo.write("w  ");
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("     \n");
        OutputImplTest.assertEquals((String)"w  ", (String)this.getBuffer().toString());
        this.getBuffer().setLength(0);
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", false));
        bo.write("w  ");
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("     \r");
        OutputImplTest.assertEquals((String)"w  ", (String)this.getBuffer().toString());
    }

    public final void testDeleteLine1() {
        Output bo = this.getOutput();
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", false));
        bo.write("Hallo test \r\n    ");
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("     \n  \t  Ola");
        OutputImplTest.assertEquals((String)"Hallo test \r\n      \t  Ola", (String)this.getBuffer().toString());
    }

    public final void testDeleteLine2() {
        Output bo = this.getOutput();
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", false));
        bo.write("Hallo test \r  \t  ");
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("     \n    Ola");
        OutputImplTest.assertEquals((String)"Hallo test \r  \t      Ola", (String)this.getBuffer().toString());
    }

    public final void testDeleteLine2_5() {
        Output bo = this.getOutput();
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("\r\nfirstLine\r\n");
        OutputImplTest.assertEquals((String)"firstLine\r\n", (String)this.getBuffer().toString());
    }

    public final void testDeleteLine3() {
        Output bo = this.getOutput();
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("\r\n");
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("\r\n \tTest");
        OutputImplTest.assertEquals((String)" \tTest", (String)this.getBuffer().toString());
    }

    public final void testDeleteLine4() {
        Output bo = this.getOutput();
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("\r\n");
        IntegerLiteralExpCS fakeExpr = CSTFactory.eINSTANCE.createIntegerLiteralExpCS();
        bo.enterStatement((SyntaxElement)new ExpressionStatement(0, 1, 1, (OCLExpressionCS)fakeExpr));
        bo.write(" mein scholli ");
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write("\r\n \tTest");
        OutputImplTest.assertEquals((String)" mein scholli  \tTest", (String)this.getBuffer().toString());
    }

    public final void testPattern() {
        OutputImplTest.assertEquals((String)"   ", (String)this.del("", "   \n   "));
        OutputImplTest.assertEquals((String)"foobar", (String)this.del("foo", "\nbar"));
        OutputImplTest.assertEquals((String)"foo\n   bar", (String)this.del("foo\n   ", "  \nbar"));
        OutputImplTest.assertEquals((String)"foo\r\tbar", (String)this.del("foo\r\t", "\r\nbar"));
        OutputImplTest.assertEquals((String)"package", (String)this.del("", "\r\npackage"));
    }

    private String del(String start, String end) {
        Output bo = this.getOutput();
        this.buffer.setLength(0);
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", false));
        bo.write(start);
        bo.enterStatement((SyntaxElement)new TextStatement(0, 1, 1, "", true));
        bo.write(end);
        return this.getBuffer().toString();
    }
}

