/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.map.editor.part.GMFMapVisualIDRegistry;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class CompartmentMappingCanonicalEditPolicy
extends CanonicalEditPolicy {
    protected List getSemanticChildrenList() {
        return Collections.EMPTY_LIST;
    }

    protected boolean shouldDeleteView(View view) {
        return view.isSetElement() && view.getElement() != null && view.getElement().eIsProxy();
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        createdViews.addAll(this.refreshPhantoms());
        this.makeViewsImmutable(createdViews);
    }

    private Collection refreshPhantoms() {
        NodeMapping nextDestination;
        LinkedList<NodeMapping> phantomNodes = new LinkedList<NodeMapping>();
        EObject container = ((View)this.getHost().getModel()).getElement();
        EClass containerMetaclass = container.eClass();
        Diagram diagram = this.getDiagram();
        if (GMFMapPackage.eINSTANCE.getTopNodeReference().isSuperTypeOf(containerMetaclass) && 2003 == GMFMapVisualIDRegistry.getNodeVisualID((View)diagram, (EObject)(nextDestination = ((TopNodeReference)container).getOwnedChild()))) {
            phantomNodes.add(nextDestination);
        }
        if (GMFMapPackage.eINSTANCE.getChildReference().isSuperTypeOf(containerMetaclass) && 2003 == GMFMapVisualIDRegistry.getNodeVisualID((View)diagram, (EObject)(nextDestination = ((ChildReference)container).getOwnedChild()))) {
            phantomNodes.add(nextDestination);
        }
        for (View nextView : this.getDiagram().getChildren()) {
            EObject nextViewElement = nextView.getElement();
            if (!phantomNodes.contains(nextViewElement)) continue;
            phantomNodes.remove(nextViewElement);
        }
        return this.createPhantomNodes(phantomNodes);
    }

    private Collection createPhantomNodes(Collection nodes) {
        CreateViewRequest request;
        if (nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CreateViewRequest.ViewDescriptor> descriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (EObject element : nodes) {
            CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor(element);
            descriptors.add(descriptor);
        }
        Diagram diagram = this.getDiagram();
        EditPart diagramEditPart = this.getDiagramEditPart();
        Command cmd = diagramEditPart.getCommand((Request)(request = this.getCreateViewRequest(descriptors)));
        if (cmd == null) {
            CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
            for (CreateViewRequest.ViewDescriptor descriptor : descriptors) {
                CreateCommand createCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)diagram);
                cc.compose((IUndoableOperation)createCommand);
            }
            cmd = new ICommandProxy((ICommand)cc);
        }
        List adapters = Collections.EMPTY_LIST;
        if (cmd != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)diagramEditPart).getNotationView())).execute();
            this.executeCommand(cmd);
            adapters = (List)request.getNewObject();
        }
        diagramEditPart.refresh();
        return adapters;
    }

    private EditPart getDiagramEditPart() {
        return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(this.getDiagram());
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }
}

