/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PopupBarEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.tools.CreationTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.internal.palette.PaletteStack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;

public class DiagramPopupBarEditPolicy
extends PopupBarEditPolicy
implements PaletteListener {
    private ToolEntry theLastTool = null;

    public void activate() {
        super.activate();
        this.addPaletteListener();
    }

    public void deactivate() {
        this.removePaletteListener();
        super.deactivate();
    }

    protected void fillPopupBarDescriptors() {
        this.fillBasedOnLastActivePaletteTool();
        if (this.getPopupBarDescriptors().isEmpty()) {
            this.fillBasedOnOpenPaletteDrawer();
            if (this.getPopupBarDescriptors().isEmpty()) {
                this.fillWithDefaults();
            }
        }
    }

    public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
        if (!(tool instanceof SelectionToolEntry)) {
            this.theLastTool = tool;
        }
    }

    private void addPaletteListener() {
        PaletteViewer paletteViewer = this.getHost().getViewer().getEditDomain().getPaletteViewer();
        if (paletteViewer != null) {
            paletteViewer.addPaletteListener((PaletteListener)this);
        }
    }

    private void removePaletteListener() {
        PaletteViewer paletteViewer = this.getHost().getViewer().getEditDomain().getPaletteViewer();
        if (paletteViewer != null) {
            paletteViewer.removePaletteListener((PaletteListener)this);
        }
        this.theLastTool = null;
    }

    protected void fillBasedOnLastActivePaletteTool() {
        if (this.theLastTool == null) {
            return;
        }
        PaletteContainer container = this.theLastTool.getParent();
        while (!(container instanceof PaletteDrawer || container instanceof PaletteGroup || container instanceof PaletteRoot || container.getParent() == null)) {
            container = container.getParent();
        }
        this.fillWithPaletteToolsInContainer(container);
    }

    protected void fillWithPaletteToolsInContainer(PaletteContainer palContainer) {
        if (palContainer != null) {
            List theEntries = palContainer.getChildren();
            int isz = theEntries.size();
            int i = 0;
            while (i < isz) {
                PaletteEntry theEntry = (PaletteEntry)theEntries.get(i);
                if (theEntry != null) {
                    if (theEntry instanceof PaletteToolEntry) {
                        CreationTool theXtoolsTool;
                        IElementType theToolType;
                        PaletteToolEntry theXtoolsEntry = (PaletteToolEntry)theEntry;
                        Tool tempTool = theXtoolsEntry.createTool();
                        if (tempTool != null && tempTool instanceof CreationTool && (theToolType = (theXtoolsTool = (CreationTool)tempTool).getElementType()) != null) {
                            Image image = IconService.getInstance().getIcon((IAdaptable)theToolType);
                            if (image != null && image.type == 1 && this.isMirrored()) {
                                image = this.convert(image);
                            }
                            this.addPopupBarDescriptor(theToolType, image);
                        }
                    } else if (theEntry instanceof PaletteStack) {
                        PaletteStack theStack = (PaletteStack)theEntry;
                        this.fillWithPaletteToolsInContainer((PaletteContainer)theStack);
                    }
                }
                ++i;
            }
        }
    }

    private boolean isMirrored() {
        return (this.getHost().getViewer().getControl().getStyle() & 0x8000000) != 0;
    }

    private Image convert(Image srcImage) {
        int height = srcImage.getBounds().height;
        int width = srcImage.getBounds().width;
        ImageData srcImageData = srcImage.getImageData();
        RGB backgroundRGB = ((GraphicalEditPart)this.getHost()).getFigure().getBackgroundColor().getRGB();
        int backgroundColor = srcImageData.palette.getPixel(backgroundRGB);
        int count = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                if ((srcImageData.maskData[count >> 3] >> 7 - count % 8 & 1) == 0) {
                    srcImageData.setPixel(x, y, backgroundColor);
                }
                ++count;
                ++x;
            }
            ++y;
        }
        srcImageData.maskData = null;
        Image convertedImage = ImageDescriptor.createFromImageData((ImageData)srcImageData).createImage(srcImage.getDevice());
        this.imagesToBeDisposed.add(convertedImage);
        return convertedImage;
    }

    protected void fillBasedOnOpenPaletteDrawer() {
        PaletteViewer paletteViewer = this.getHost().getViewer().getEditDomain().getPaletteViewer();
        if (paletteViewer != null) {
            for (Object child : paletteViewer.getPaletteRoot().getChildren()) {
                PaletteDrawer drawer;
                if (!(child instanceof PaletteDrawer) || !(drawer = (PaletteDrawer)child).isInitiallyOpen()) continue;
                this.fillWithPaletteToolsInContainer((PaletteContainer)drawer);
                break;
            }
        }
    }

    protected void fillWithDefaults() {
    }
}

