/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeLiteFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.internal.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.FileGenModelAccess;
import org.eclipse.gmf.internal.bridge.genmodel.GenModelProducer;
import org.eclipse.gmf.internal.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.internal.bridge.genmodel.SpecificDiagramRunTimeModelHelper;
import org.eclipse.gmf.internal.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediatorImpl;
import org.eclipse.gmf.internal.bridge.transform.ValidationHelper;
import org.eclipse.gmf.internal.bridge.transform.VisualIdentifierDispenserProvider;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.internal.codegen.popup.actions.DiagnosticsDialog;
import org.eclipse.gmf.internal.codegen.popup.actions.GenModelDetector;
import org.eclipse.gmf.internal.codegen.popup.actions.StaleGenModelDetector;
import org.eclipse.gmf.internal.codegen.popup.actions.TransformToGenModelOptionsDialog;
import org.eclipse.gmf.internal.common.URIUtil;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.gmf.internal.common.reconcile.Reconciler;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;
import org.eclipse.gmf.internal.util.GMFGenConfig;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TransformToGenModelOperation {
    private static final String ASK_WARN = "ask_warn";
    private static final Boolean THERE_IS_NO_SPECIFIC_RT = Boolean.TRUE;
    private String name;
    private Shell shell;
    private URI mapModelURI;
    private URI genModelURI;
    private URI domainGenModelURI;
    private Boolean useRuntimeFigures;
    private Boolean useMapMode;
    private Boolean rcp;
    private ResourceSet myResourceSet;

    public String getName() {
        if (this.name == null) {
            return "Transform Model";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Shell getShell() {
        if (this.shell == null) {
            return Display.getDefault().getActiveShell();
        }
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public URI getMapModelURI() {
        return this.mapModelURI;
    }

    public void setMapModelURI(URI uri) {
        this.mapModelURI = uri;
    }

    public URI getGenModelURI() {
        return this.genModelURI;
    }

    public void setGenModelURI(URI uri) {
        this.genModelURI = uri;
    }

    public URI getDomainGenModelURI() {
        return this.domainGenModelURI;
    }

    public void setDomainGenModelURI(URI uri) {
        this.domainGenModelURI = uri;
    }

    public Boolean getUseMapMode() {
        return this.useMapMode;
    }

    public void setUseMapMode(Boolean useMapMode) {
        this.useMapMode = useMapMode;
    }

    public Boolean getUseRuntimeFigures() {
        return this.useRuntimeFigures;
    }

    public void setUseRuntimeFigures(Boolean useRuntimeFigures) {
        this.useRuntimeFigures = useRuntimeFigures;
    }

    public Boolean getRCP() {
        return this.rcp;
    }

    public void setRCP(Boolean rcp) {
        this.rcp = rcp;
    }

    protected ResourceSet getResourceSet() {
        if (this.myResourceSet == null) {
            this.myResourceSet = new ResourceSetImpl();
        }
        return this.myResourceSet;
    }

    protected void forgetResourceSet() {
        this.myResourceSet = null;
    }

    public void run() {
        StaleGenModelDetector staleDetector;
        ModelLoadHelper loadHelper = new ModelLoadHelper(this.getResourceSet(), this.getMapModelURI());
        if (!this.canProcessMappingModel(loadHelper)) {
            return;
        }
        Mapping mapping = (Mapping)loadHelper.getContentsRoot();
        Diagnostic mapIsValid = this.validate(mapping);
        if (ValidationHelper.matches((Diagnostic)mapIsValid, (int)8)) {
            return;
        }
        if (ValidationHelper.matches((Diagnostic)mapIsValid, (int)4)) {
            String msg = CodeGenUIPlugin.getBundleString("transform.err");
            if (DiagnosticsDialog.openProceedCancel(this.getShell(), this.getName(), msg, mapIsValid) == 1) {
                return;
            }
        } else if (ValidationHelper.matches((Diagnostic)mapIsValid, (int)3) && !"always".equals(TransformToGenModelOperation.getPreferences().getString(ASK_WARN))) {
            String warn = CodeGenUIPlugin.getBundleString("transform.warn");
            String nwarn = CodeGenUIPlugin.getBundleString("transform.neverwarn");
            if (MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)this.getName(), (String)warn, (String)nwarn, (boolean)false, (IPreferenceStore)TransformToGenModelOperation.getPreferences(), (String)ASK_WARN).getReturnCode() != 0) {
                return;
            }
        }
        GenModel domainGenModel = null;
        if (this.getDomainGenModelURI() != null) {
            FileGenModelAccess gmAccess = new FileGenModelAccess(this.getDomainGenModelURI());
            if (gmAccess.load(this.getResourceSet()).getSeverity() == 0) {
                domainGenModel = gmAccess.model();
            }
        } else {
            IFile mapFile = URIUtil.getFile((URI)this.getMapModelURI());
            if (mapFile == null) {
                return;
            }
            GenModelDetector gmDetector = new GenModelDetector(mapFile);
            IStatus findStatus = gmDetector.find(this.getShell(), mapping);
            if (findStatus.getSeverity() == 8) {
                return;
            }
            if (findStatus.isOK()) {
                domainGenModel = gmDetector.get(this.getResourceSet());
            }
        }
        if (domainGenModel != null && (staleDetector = new StaleGenModelDetector(domainGenModel)).isStale()) {
            if (staleDetector.queryUser(this.getShell()).getSeverity() == 8) {
                return;
            }
            domainGenModel = staleDetector.refresh();
        }
        DiagramRunTimeModelHelper drtModelHelper = this.detectRunTimeModel();
        ViewmapProducer viewmapProducer = this.detectTransformationOptions(this.getShell());
        if (viewmapProducer == null) {
            return;
        }
        VisualIdentifierDispenserProvider idDispenser = this.getVisualIdDispenser();
        idDispenser.acquire();
        GenModelProducer t = this.createGenModelProducer(domainGenModel, drtModelHelper, viewmapProducer, idDispenser.get());
        Job transformJob = this.createTransformJob(mapping, this.getName(), t);
        transformJob.schedule();
        try {
            transformJob.join();
            if (transformJob.getResult().getSeverity() != 8) {
                idDispenser.release();
            }
        }
        catch (InterruptedException interruptedException) {}
        this.forgetResourceSet();
    }

    private Job createTransformJob(final Mapping mapping, String title, final GenModelProducer t) {
        return new Job(title){
            {
                super($anonymous0);
                this.setUser(true);
                this.setPriority(20);
            }

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(this.getName(), 4);
                try {
                    GenEditorGenerator genEditor = t.process(mapping, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (CodeGenUIPlugin.needsReconcile()) {
                        this.reconcile(genEditor);
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    this.save(genEditor);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = this.validate(genEditor, monitor);
                    return iStatus;
                }
                catch (IOException ex) {
                    IStatus iStatus = CodeGenUIPlugin.createError(ex.getMessage(), ex);
                    return iStatus;
                }
                catch (IllegalArgumentException ex) {
                    IStatus iStatus = CodeGenUIPlugin.createError(ex.getMessage(), ex);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }

            private IStatus validate(GenEditorGenerator genBurdern, IProgressMonitor monitor) {
                final Diagnostic d = ValidationHelper.validate((EObject)genBurdern, (boolean)true, (IProgressMonitor)monitor);
                if (ValidationHelper.matches((Diagnostic)d, (int)4)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            DiagnosticsDialog.openOk(TransformToGenModelOperation.this.getShell(), this.getName(), CodeGenUIPlugin.getBundleString("transform.result.error"), d);
                        }
                    });
                }
                if (ValidationHelper.matches((Diagnostic)d, (int)8)) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private void save(GenEditorGenerator genBurdern) throws IOException {
                Resource dgmmRes = TransformToGenModelOperation.this.getResourceSet().createResource(TransformToGenModelOperation.this.getGenModelURI());
                dgmmRes.getContents().add((Object)genBurdern);
                dgmmRes.save(this.getSaveOptions());
            }

            protected Map getSaveOptions() {
                HashMap<String, String> saveOptions = new HashMap<String, String>();
                saveOptions.put("ENCODING", "UTF-8");
                return saveOptions;
            }

            private void reconcile(GenEditorGenerator genBurdern) {
                GenEditorGenerator old = null;
                Resource resource = null;
                try {
                    try {
                        resource = TransformToGenModelOperation.this.getResourceSet().getResource(TransformToGenModelOperation.this.getGenModelURI(), true);
                        EList contents = resource.getContents();
                        if (!contents.isEmpty() && contents.get(0) instanceof GenEditorGenerator) {
                            old = (GenEditorGenerator)contents.get(0);
                        }
                        if (old != null) {
                            new Reconciler((ReconcilerConfig)new GMFGenConfig()).reconcileTree((EObject)genBurdern, (EObject)old);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        old = null;
                        if (resource != null) {
                            resource.unload();
                        }
                    }
                }
                finally {
                    if (resource != null) {
                        resource.unload();
                    }
                }
            }
        };
    }

    private GenModelProducer createGenModelProducer(GenModel domainGenModel, DiagramRunTimeModelHelper drtModelHelper, ViewmapProducer viewmapProducer, VisualIdentifierDispenser idDespenser) {
        final DiagramGenModelTransformer t = new DiagramGenModelTransformer(drtModelHelper, (GenModelNamingMediator)new GenModelNamingMediatorImpl(), viewmapProducer, idDespenser, this.getRCP() == null ? false : this.getRCP());
        if (domainGenModel != null) {
            t.setEMFGenModel(domainGenModel);
        }
        return new GenModelProducer(){

            public GenEditorGenerator process(Mapping mapping, IProgressMonitor progress) {
                progress.beginTask(null, 1);
                try {
                    t.transform(mapping);
                    GenEditorGenerator genEditorGenerator = t.getResult();
                    return genEditorGenerator;
                }
                finally {
                    progress.done();
                }
            }
        };
    }

    private boolean canProcessMappingModel(ModelLoadHelper loadHelper) {
        Diagnostic loadDiagnostic = ValidationHelper.createResourceProblemMarkers((Diagnostic)loadHelper.getDiagnostics());
        if (!loadHelper.getStatus().isOK()) {
            boolean disableProceed = !(loadHelper.getContentsRoot() instanceof Mapping);
            String message = CodeGenUIPlugin.getBundleString("transform.err");
            if (DiagnosticsDialog.openProceedCancel(this.getShell(), this.getName(), message, loadDiagnostic, disableProceed) == 1) {
                return false;
            }
        }
        return true;
    }

    private VisualIdentifierDispenserProvider getVisualIdDispenser() {
        return new VisualIdentifierDispenserProvider(this.getGenModelURI());
    }

    private ViewmapProducer detectTransformationOptions(Shell shell) {
        if (this.getUseRuntimeFigures() != null && this.getUseMapMode() != null && this.getRCP() != null) {
            RuntimeFQNSwitch fSwitch = this.getUseRuntimeFigures() != false ? new RuntimeFQNSwitch() : new RuntimeLiteFQNSwitch();
            MapModeCodeGenStrategy mmStrategy = this.getUseMapMode() != false ? MapModeCodeGenStrategy.DYNAMIC : MapModeCodeGenStrategy.STATIC;
            return new InnerClassViewmapProducer((FigureQualifiedNameSwitch)fSwitch, mmStrategy);
        }
        if (!TransformToGenModelOperation.checkLiteOptionPresent()) {
            this.rcp = MessageDialog.openQuestion((Shell)shell, (String)"Create Generator Model", (String)"Would you like to generate RCP application?") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            MapModeCodeGenStrategy strategy = MessageDialog.openQuestion((Shell)shell, (String)"Create Generator Model", (String)"Would you like to use IMapMode?") ? MapModeCodeGenStrategy.DYNAMIC : MapModeCodeGenStrategy.STATIC;
            return new InnerClassViewmapProducer((FigureQualifiedNameSwitch)new RuntimeFQNSwitch(), strategy);
        }
        TransformToGenModelOptionsDialog dlg = new TransformToGenModelOptionsDialog(shell, "Create Generator Model", this.getUseRuntimeFigures() == null ? true : this.getUseRuntimeFigures(), this.getUseMapMode() == null ? true : this.getUseMapMode(), this.getRCP() == null ? false : this.getRCP());
        if (dlg.open() != 0) {
            return null;
        }
        this.setRCP(dlg.isRCP());
        return new InnerClassViewmapProducer(dlg.getFigureQualifiedNameSwitch(), dlg.getMapModeCodeGenStrategy());
    }

    private static boolean checkLiteOptionPresent() {
        return Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") != null;
    }

    private DiagramRunTimeModelHelper detectRunTimeModel() {
        Resource drtGenModelRes;
        BasicDiagramRunTimeModelHelper drtModelHelper = null;
        URI specificRTGenModelURI = this.decideOnRunTimeModel();
        if (specificRTGenModelURI != null && (drtGenModelRes = this.getResourceSet().getResource(specificRTGenModelURI, true)) != null) {
            GenModel drtGenModel = (GenModel)drtGenModelRes.getContents().get(0);
            drtModelHelper = new SpecificDiagramRunTimeModelHelper(drtGenModel);
        }
        if (drtModelHelper == null) {
            drtModelHelper = new BasicDiagramRunTimeModelHelper();
        }
        return drtModelHelper;
    }

    private Diagnostic validate(final Mapping mapping) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final Diagnostic[] result = new Diagnostic[1];
        try {
            progressService.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 1);
                    result[0] = ValidationHelper.validate((EObject)mapping, (boolean)true, (IProgressMonitor)monitor);
                    monitor.done();
                }
            });
            if (result[0] == null) {
                return Diagnostic.CANCEL_INSTANCE;
            }
            return result[0];
        }
        catch (InvocationTargetException invocationTargetException) {
            return Diagnostic.CANCEL_INSTANCE;
        }
        catch (InterruptedException interruptedException) {
            return Diagnostic.CANCEL_INSTANCE;
        }
    }

    private URI decideOnRunTimeModel() {
        if (THERE_IS_NO_SPECIFIC_RT.booleanValue()) {
            return null;
        }
        InputDialog dlg = new InputDialog(this.getShell(), "Diagram RunTime Model", "Please specify path to genmodel file that describes specific diagram runtime model, or press Cancel if you don't need one", null, null);
        if (dlg.open() == 0) {
            return URI.createPlatformResourceURI((String)dlg.getValue(), (boolean)true);
        }
        return null;
    }

    private static IPreferenceStore getPreferences() {
        return CodeGenUIPlugin.getDefault().getPreferenceStore();
    }
}

