/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.ui.printing.IPrintHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageSetupPageType;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.IEditorPart;

public class DiagramPrinterHelper {
    protected void printDiagrams(DiagramPrinter diagramPrinter, IPrintHelper helper) {
        if (helper.getDlgPrintRangePages()) {
            diagramPrinter.setPrintRangePageSelection(true);
            diagramPrinter.setPrintRangePages(helper.getDlgPagesFrom(), helper.getDlgPagesTo());
            diagramPrinter.setFitToPage(false);
        }
        if (helper.getDlgScalePercent() == -1) {
            diagramPrinter.setColumns(helper.getDlgScaleFitToM());
            diagramPrinter.setRows(helper.getDlgScaleFitToN());
            diagramPrinter.setFitToPage(true);
        } else {
            diagramPrinter.setScaledPercent(helper.getDlgScalePercent());
            diagramPrinter.setFitToPage(false);
        }
        diagramPrinter.run();
    }

    protected PrinterData collectPrintInformation(DiagramPrinter diagramPrinter, IPrintHelper helper, List diagramNames, IEditorPart editorPart, Map diagramMap) {
        IDiagramGraphicalViewer viewer;
        IPreferenceStore pref = null;
        if (editorPart instanceof IDiagramWorkbenchPart && (viewer = ((IDiagramWorkbenchPart)editorPart).getDiagramGraphicalViewer()) instanceof DiagramGraphicalViewer && (pref = ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore()).getBoolean("print.useWorkspaceSettings") && ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore() != null) {
            pref = (IPreferenceStore)((IDiagramWorkbenchPart)editorPart).getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore();
        }
        if (pref != null) {
            helper.setDlgOrientation(pref.getBoolean("print.useLandscape"));
            PageSetupPageType storedPageType = PageSetupPageType.LETTER;
            String strPageType = pref.getString("print.page.size");
            int i = 0;
            while (i < PageSetupPageType.pages.length) {
                if (strPageType.startsWith(PageSetupPageType.pages[i].getName())) {
                    storedPageType = PageSetupPageType.pages[i];
                    break;
                }
                ++i;
            }
            if (storedPageType.getIndex() == PageSetupPageType.USER_DEFINED.getIndex()) {
                NumberFormat fNumberFormat = NumberFormat.getNumberInstance();
                String strWidth = pref.getString("print.page.width");
                String strHeight = pref.getString("print.page.height");
                double width = 0.0;
                double height = 0.0;
                try {
                    Number num = fNumberFormat.parse(strWidth);
                    width = num.doubleValue() / 0.0394;
                    num = fNumberFormat.parse(strHeight);
                    height = num.doubleValue() / 0.0394;
                    helper.setDlgPaperSize(PageSetupPageType.USER_DEFINED.getIndex(), width, height);
                }
                catch (ParseException e) {
                    Log.warning((Plugin)DiagramPrintingPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
                }
            } else {
                helper.setDlgPaperSize(storedPageType.getIndex(), 0.0, 0.0);
            }
        }
        helper.setScaleFactor(PrintHelperUtil.getScale());
        helper.setScaleToWidthHeight(PrintHelperUtil.getScaleToWidth(), PrintHelperUtil.getScaleToHeight());
        PrinterData printerData = helper.openPrintDlg(diagramNames);
        if (printerData != null) {
            if (helper.getDlgScalePercent() != -1) {
                PrintHelperUtil.setScale(helper.getDlgScalePercent());
            }
            if (helper.getDlgScaleFitToM() != -1) {
                PrintHelperUtil.setScaleToWidth(helper.getDlgScaleFitToM());
            }
            if (helper.getDlgScaleFitToN() != -1) {
                PrintHelperUtil.setScaleToHeight(helper.getDlgScaleFitToN());
            }
        }
        return printerData;
    }
}

