/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.descriptors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.AbstractAdviceBindingDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.AdviceBindingInheritance;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.XMLExpressionMatcher;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class AdviceBindingDescriptor
extends AbstractAdviceBindingDescriptor
implements IEditHelperAdviceDescriptor {
    private String matcherClassName;
    private IElementMatcher matcher;
    private IConfigurationElement matcherConfig;
    final IConfigurationElement bindingConfig;
    String editHelperAdviceName;
    private IContainerDescriptor containerDescriptor;
    private final MetamodelDescriptor metamodelDescriptor;

    public AdviceBindingDescriptor(IConfigurationElement config, MetamodelDescriptor metamodelDescriptor) throws CoreException {
        super(config.getAttribute("id"), config.getAttribute("typeId"), AdviceBindingDescriptor.getInheritance(config));
        IConfigurationElement[] matcherConfigs;
        IConfigurationElement[] enablementConfigs;
        this.bindingConfig = config;
        this.metamodelDescriptor = metamodelDescriptor;
        if (this.id == null) {
            throw EMFTypePluginStatusCodes.getAdviceBindingInitException("", EMFTypeCoreMessages.adviceBinding_reason_no_id_WARN_);
        }
        this.editHelperAdviceName = config.getAttribute("class");
        if (this.editHelperAdviceName == null) {
            throw EMFTypePluginStatusCodes.getAdviceBindingInitException(this.id, EMFTypeCoreMessages.adviceBinding_reason_no_edit_helper_advice_id_WARN_);
        }
        if (this.typeId == null) {
            throw EMFTypePluginStatusCodes.getAdviceBindingInitException(this.id, EMFTypeCoreMessages.adviceBinding_reason_no_type_id_WARN_);
        }
        IConfigurationElement[] containerConfigs = config.getChildren("eContainer");
        if (containerConfigs.length > 0) {
            this.containerDescriptor = new ContainerDescriptor(containerConfigs[0], metamodelDescriptor, this.getId());
        }
        if ((enablementConfigs = config.getChildren("enablement")).length > 0) {
            this.matcher = new XMLExpressionMatcher(enablementConfigs[0], this.id);
        }
        if (this.matcher == null && (matcherConfigs = config.getChildren("matcher")).length > 0) {
            this.matcherClassName = matcherConfigs[0].getAttribute("class");
            if (this.matcherClassName == null) {
                throw EMFTypePluginStatusCodes.getInitException(this.id, EMFTypeCoreMessages.element_reason_matcher_no_class_WARN_, null);
            }
            this.matcherConfig = matcherConfigs[0];
        }
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getId() {
        return this.id;
    }

    public IElementMatcher getMatcher() {
        if (this.matcher == null && this.matcherClassName != null && this.matcherConfig != null) {
            try {
                this.matcher = (IElementMatcher)this.matcherConfig.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)21, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.matcher_class_not_found_ERROR_, (Object)this.matcherClassName), (Throwable)e);
                this.matcherClassName = null;
            }
        }
        return this.matcher;
    }

    public IEditHelperAdvice getEditHelperAdvice() {
        if (this.editHelperAdvice == null && this.editHelperAdviceName != null) {
            try {
                this.editHelperAdvice = (IEditHelperAdvice)this.bindingConfig.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)20, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.editHelperAdvice_class_not_found_ERROR_, (Object)this.editHelperAdviceName), (Throwable)e);
                this.editHelperAdviceName = null;
            }
        }
        return this.editHelperAdvice;
    }

    public MetamodelDescriptor getMetamodelDescriptor() {
        return this.metamodelDescriptor;
    }

    public AdviceBindingInheritance getInheritance() {
        return this.inheritance;
    }

    public IContainerDescriptor getContainerDescriptor() {
        return this.containerDescriptor;
    }

    public String toString() {
        return "AdviceBindingDescriptor[" + this.getId() + "]";
    }

    private static AdviceBindingInheritance getInheritance(IConfigurationElement config) throws CoreException {
        String inheritanceString = config.getAttribute("inheritance");
        AdviceBindingInheritance result = AdviceBindingInheritance.getAdviceBindingInheritance(inheritanceString);
        if (result == null) {
            if (inheritanceString != null) {
                throw EMFTypePluginStatusCodes.getAdviceBindingInitException(config.getAttribute("id"), EMFTypeCoreMessages.adviceBinding_reason_invalid_inheritance_WARN_);
            }
            result = AdviceBindingInheritance.NONE;
        }
        return result;
    }
}

