/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.notation;

import java.io.IOException;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.ListValueStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.junit.Assume;

public class NotationTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)NotationTest.suite());
    }

    public static Test suite() {
        return new TestSuite(NotationTest.class);
    }

    public NotationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int i = 0;
        while (i < pages.length) {
            IViewReference[] viewRefs = pages[i].getViewReferences();
            int j = 0;
            while (j < viewRefs.length) {
                if ("org.eclipse.ui.internal.introview".equals(viewRefs[j].getId())) {
                    pages[i].hideView(viewRefs[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private IProject getTestProject() throws CoreException {
        String projectName = this.getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        return project;
    }

    private String getTestProjectName() throws CoreException {
        IProject project = this.getTestProject();
        return project.getName();
    }

    public void test_notation() throws Exception {
        IProject project = this.getTestProject();
        IFile file = project.getFile("tests.notation");
        String fullPath = file.getFullPath().toOSString();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createPlatformResourceURI((String)fullPath, (boolean)true));
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.setName(this.getName());
        resource.getContents().add((Object)diagram);
        ShapeStyle style = NotationFactory.eINSTANCE.createShapeStyle();
        EList styles = diagram.getStyles();
        styles.add((Object)style);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        file.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        NotationTest.assertNotNull((String)"Workbench page is null", (Object)page);
        NotationTest.assertNotNull((String)"Workspace file is null", (Object)file);
        IEditorDescriptor defaultEditor = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.DefaultTextEditor");
        NotationTest.assertNotNull((String)"Default Editor is null", (Object)defaultEditor);
        page.openEditor((IEditorInput)new FileEditorInput(file), defaultEditor.getId());
    }

    public void test_ListValueStyleImpl_getRawValuesList() throws Exception {
        ListValueStyle listValueStyle = NotationFactory.eINSTANCE.createListValueStyle();
        listValueStyle.setName(this.getName());
        EList rawValuesList = listValueStyle.getRawValuesList();
        rawValuesList.add(null);
        rawValuesList.add((Object)"valid element");
        try {
            rawValuesList.add(new Object());
            NotationTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        NotationTest.assertEquals((int)2, (int)rawValuesList.size());
        rawValuesList.clear();
        listValueStyle.setInstanceType(EcorePackage.Literals.EDOUBLE);
        rawValuesList.add(null);
        rawValuesList.add((Object)"4711.0815d");
        try {
            rawValuesList.add((Object)"invalid element");
            NotationTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            rawValuesList.add((Object)4711.0815);
            NotationTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        try {
            rawValuesList.add(new Object());
            NotationTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        NotationTest.assertEquals((int)2, (int)rawValuesList.size());
        rawValuesList.clear();
        final int[] notifications = new int[1];
        listValueStyle.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                notifications[0] = notifications[0] + 1;
            }
        });
        rawValuesList.add((Object)"4711.0815d");
        NotationTest.assertEquals((int)1, (int)notifications[0]);
        EList rawValuesList2 = listValueStyle.getRawValuesList();
        NotationTest.assertSame((Object)rawValuesList, (Object)rawValuesList2);
    }

    public void test_ViewImpl_getElement() throws Exception {
        String fullPath1 = "/" + this.getTestProjectName() + "/test1.notation";
        String fullPath2 = "/" + this.getTestProjectName() + "/test2.ecore";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource1 = resourceSet.createResource(URI.createPlatformResourceURI((String)fullPath1, (boolean)true));
        Resource resource2 = resourceSet.createResource(URI.createPlatformResourceURI((String)fullPath2, (boolean)true));
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.setName(this.getName());
        resource1.getContents().add((Object)diagram);
        Node node = NotationFactory.eINSTANCE.createNode();
        diagram.getPersistedChildren().add((Object)node);
        EClass diagramElement = EcoreFactory.eINSTANCE.createEClass();
        diagramElement.setName("DiagramElement");
        diagram.setElement((EObject)diagramElement);
        resource2.getContents().add((Object)diagramElement);
        try {
            resource1.save(Collections.EMPTY_MAP);
            resource2.save(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        resourceSet = new ResourceSetImpl();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)fullPath1, (boolean)true), true);
        diagram = (Diagram)resource1.getContents().get(0);
        Assume.assumeTrue((boolean)((DiagramImpl)diagram).basicGetElement().eIsProxy());
        node = (Node)diagram.getChildren().get(0);
        EObject element = node.getElement();
        Assume.assumeFalse((boolean)element.eIsProxy());
    }
}

