/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.util.BaseInlineTextActionHandler;
import org.eclipse.gmf.runtime.common.ui.util.IInlineTextActionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class InlineTextActionHandler
extends BaseInlineTextActionHandler
implements IInlineTextActionHandler {
    private IActionBars actionBars;
    private Map actionPairMap;
    private List disableActionsIds;

    public InlineTextActionHandler(IActionBars actionBars, Text text, List disableActionsIds) {
        super(text);
        this.setActionPairMap(new HashMap());
        this.setActionBars(actionBars);
        this.disableActionsIds = disableActionsIds;
    }

    private IActionBars getActionBars() {
        return this.actionBars;
    }

    private void setActionBars(IActionBars actionBars) {
        this.actionBars = actionBars;
    }

    private void buildActionPairMap() {
        if (!this.getActionPairMap().isEmpty()) {
            return;
        }
        ActionPair actionPair = null;
        IAction action = this.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
        if (action != null) {
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.CUT.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new Action(action.getText()){

                public void run() {
                    InlineTextActionHandler.this.handleCut();
                }
            };
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        if ((action = this.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId())) != null) {
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.COPY.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new Action(action.getText()){

                public void run() {
                    InlineTextActionHandler.this.handleCopy();
                }
            };
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        if ((action = this.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId())) != null) {
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.PASTE.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new Action(action.getText()){

                public void run() {
                    InlineTextActionHandler.this.handlePaste();
                }
            };
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        if ((action = this.getActionBars().getGlobalActionHandler(ActionFactory.DELETE.getId())) != null) {
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.DELETE.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new Action(action.getText()){

                public void run() {
                    InlineTextActionHandler.this.handleDelete();
                }
            };
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        if ((action = this.getActionBars().getGlobalActionHandler(ActionFactory.SELECT_ALL.getId())) != null) {
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.SELECT_ALL.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new Action(action.getText()){

                public void run() {
                    InlineTextActionHandler.this.handleSelectAll();
                }
            };
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        if ((action = this.getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId())) != null) {
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.UNDO.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new DisabledTextActionHandler(action.getText());
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        if ((action = this.getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId())) != null) {
            action.setEnabled(false);
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.REDO.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new DisabledTextActionHandler(action.getText());
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        if ((action = this.getActionBars().getGlobalActionHandler(ActionFactory.FIND.getId())) != null) {
            actionPair = new ActionPair();
            actionPair.actionId = ActionFactory.FIND.getId();
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new DisabledTextActionHandler(action.getText());
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
        Iterator it = this.disableActionsIds.iterator();
        String specialCommandId = null;
        while (it.hasNext()) {
            specialCommandId = (String)it.next();
            action = this.getActionBars().getGlobalActionHandler(specialCommandId);
            if (action == null) continue;
            actionPair = new ActionPair();
            actionPair.actionId = specialCommandId;
            actionPair.originalAction = action;
            actionPair.textHandlerAction = new DisabledTextActionHandler(action.getText());
            this.getActionPairMap().put(actionPair.actionId, actionPair);
        }
    }

    public void hookHandlers() {
        this.buildActionPairMap();
        ActionPair actionPair = null;
        Iterator it = this.getActionPairMap().values().iterator();
        while (it.hasNext()) {
            actionPair = (ActionPair)it.next();
            this.getActionBars().setGlobalActionHandler(actionPair.actionId, null);
        }
        this.getActionBars().updateActionBars();
        it = this.getActionPairMap().values().iterator();
        while (it.hasNext()) {
            actionPair = (ActionPair)it.next();
            this.getActionBars().setGlobalActionHandler(actionPair.actionId, actionPair.textHandlerAction);
            actionPair.textHandlerAction.setEnabled(true);
        }
        this.getActionBars().updateActionBars();
        this.setHooked(true);
    }

    public void unHookHandlers() {
        ActionPair actionPair = null;
        Iterator it = this.getActionPairMap().values().iterator();
        while (it.hasNext()) {
            actionPair = (ActionPair)it.next();
            this.getActionBars().setGlobalActionHandler(actionPair.actionId, null);
        }
        this.getActionBars().updateActionBars();
        it = this.getActionPairMap().values().iterator();
        while (it.hasNext()) {
            actionPair = (ActionPair)it.next();
            this.getActionBars().setGlobalActionHandler(actionPair.actionId, actionPair.originalAction);
            actionPair.originalAction.setEnabled(actionPair.originalAction.isEnabled());
        }
        this.getActionBars().updateActionBars();
        this.setHooked(false);
    }

    public void dispose() {
        super.dispose();
        this.setActionPairMap(null);
        this.setActionBars(null);
        this.disableActionsIds = null;
    }

    private Map getActionPairMap() {
        return this.actionPairMap;
    }

    private void setActionPairMap(Map actionPairMap) {
        this.actionPairMap = actionPairMap;
    }

    private class DisabledTextActionHandler
    extends Action {
        protected DisabledTextActionHandler(String name) {
            super(name);
            this.setEnabled(false);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(false);
        }
    }

    private class ActionPair {
        String actionId;
        IAction originalAction;
        IAction textHandlerAction;

        private ActionPair() {
        }
    }
}

